use 5.006002;
use ExtUtils::MakeMaker;

use strict;

use File::Spec;

my $os;
if($^O eq "MSWin32") {
    $os = "XP_PC";
} else {
    $os = "XP_UNIX";
}

my $lib_search_paths = "";
my $inc_search_paths = "";

if ($ENV{NSS_BASE}) {
    $lib_search_paths = "-L" . File::Spec->catdir($ENV{NSS_BASE}, "lib");
    $inc_search_paths = "-I" . File::Spec->catdir($ENV{NSS_BASE}, "include");
    
    generate_Crypt_NSS_Constant_pm(substr($inc_search_paths, 2));
}
else {
    print "Aborting. No NSS_BASE set\n";
    exit 0;
}

WriteMakefile(
    NAME            => 'Crypt::NSS',
    VERSION_FROM    => 'lib/Crypt/NSS.pm',
    PREREQ_PM       => {},
    ABSTRACT_FROM   => 'lib/Crypt/NSS.pm',
    AUTHOR          => 'Claes Jakobsson <claesjac@cpan.org>',
    LICENSE         => "mit",
    LIBS            => ["${lib_search_paths} -lnss3 -lssl3 -lsmime3"],
    DEFINE          => "-D${os}", 
    INC             => "${inc_search_paths} -I.",
);

sub generate_Crypt_NSS_Constant_pm {
    my $inc_base = shift;

    my @Constants_groups = (
        ssl => "ssl.h",
        ssl => "sslproto.h",
    );
        
    my %constants_by_group = (
        'ssl'   => [
            [SSL_OPTION_ENABLED  => 1, "Enables an option" ],
            [SSL_OPTION_DISABLED => 2, "Disables an option" ],
        ],
    );
    
    while (my ($group, $header) = splice @Constants_groups, 0, 2) {
        open (my $in, "<", File::Spec->catfile($inc_base, $header)) || die $!;
        while (<$in>) {
            chomp;
            if ($_ =~ m{^ \#define \s+ (\w+) \s+ (?:\(\(PRBool\))?(0x[0-9A-Fa-f]+|\d+)\)? \s* (?:/\* \s* (.*?) \s* \*/)? }x) {
                push @{$constants_by_group{$group}}, [ $1, $2, $3 ]; 
            }
        }
        close ($in);
    }

    open (my $out, ">", File::Spec->catfile(".", "lib", "Crypt", "NSS", "Constants.pm")) || die $!;
    print $out q{# Autogenerated file. DO NOT EDIT
        
package Crypt::NSS::Constants;

require Exporter;

our @ISA = qw(Exporter);

our @EXPORT = qw();

};

    print $out "our \@EXPORT_OK = qw(\n";
    for my $group (sort keys %constants_by_group) {
        print $out join("\n", map { "\t$_->[0]" } sort { $a->[0] cmp $b->[0] } @{$constants_by_group{$group}}), "\n";
    }
    print $out ");\n\n";
    print $out "our \%EXPORT_TAGS = (\n";
    for my $group (sort keys %constants_by_group) {
        print $out "\t${group} => [qw(\n";
        print $out join("\n", map { "\t\t$_->[0]" } sort { $a->[0] cmp $b->[0] } @{$constants_by_group{$group}}), "\n";
        print $out "\t)],\n";
    }
    print $out ");\n\n";
    
    for my $group (sort keys %constants_by_group) {
        if (@{$constants_by_group{$group}}) {
            print $out "use constant {\n";
            print $out join("\n", map { "\t$_->[0] => $_->[1],\t# $_->[2]" } sort { $a->[0] cmp $b->[0] } @{$constants_by_group{$group}}), "\n";
            print $out "};\n\n";
        }
    }
    
    print $out q{1;
__END__

=head1 NAME

Crypt::NSS::Constants - Constants used by NSS

=cut
};

}