#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"

I32 is_num(pTHX_ SV * sv);
I32 is_num(pTHX_ SV * sv) {
    I32 type = 0;

    if (!(sv == (SV *)&PL_sv_undef)) {
        STRLEN len;
        const char * str = NULL;

        /*
         * stringify: ironically, looks_like_number always returns 1 (at least up to 5.8.1)
         * or (at least from 5.8.8) an unhelpful conjunction of flags unless arg is a string
         */
        if (!SvPOK(sv)) { /* stringify numbers, references and overloaded objects */
            str = SvPV_const(sv, len);
            sv = sv_2mortal(newSVpv(str, len));
        }

/*
 * handle 1.#INF (Inf), -1.#INF (-Inf), and 1.#IND (NaN) on Windows:
 * http://www.johndcook.com/IEEE_exceptions_in_cpp.html
 *
 * switch trie generated by Devel::Tokenizer::C (Marcus Holland-Moritz++)
 * hacked about to make the formatting less annoying :-)
 */ 

#ifdef WIN32
        if (!str) {
            str = SvPV_const(sv, len);
        }

        switch (len) {
            case 6: /* 2 tokens of length 6 */
                switch (str[5]) {
                    case 'D':
                        if (str[0] == '1' &&
                            str[1] == '.' &&
                            str[2] == '#' &&
                            str[3] == 'I' &&
                            str[4] == 'N')
                        { /* 1.#IND */
                            return IS_NUMBER_NAN | IS_NUMBER_NOT_INT;
                        }

                        goto not_nan_or_inf;

                    case 'F':
                        if (str[0] == '1' &&
                            str[1] == '.' &&
                            str[2] == '#' &&
                            str[3] == 'I' &&
                            str[4] == 'N')
                        { /* 1.#INF */
                            return IS_NUMBER_INFINITY | IS_NUMBER_NOT_INT;
                        }

                        goto not_nan_or_inf;

                    default:
                        goto not_nan_or_inf;
                }

            case 7: /* 2 tokens of length 7 */
                switch (str[6]) {
                    case 'D':
                        if (str[0] == '-' &&
                            str[1] == '1' &&
                            str[2] == '.' &&
                            str[3] == '#' &&
                            str[4] == 'I' &&
                            str[5] == 'N')
                        { /* -1.#IND */
                            return IS_NUMBER_NEG | IS_NUMBER_NAN | IS_NUMBER_NOT_INT;
                        }

                        goto not_nan_or_inf;

                    case 'F':
                        if (str[0] == '-' &&
                            str[1] == '1' &&
                            str[2] == '.' &&
                            str[3] == '#' &&
                            str[4] == 'I' &&
                            str[5] == 'N')
                        { /* -1.#INF */
                            return IS_NUMBER_NEG | IS_NUMBER_INFINITY | IS_NUMBER_NOT_INT;
                        }

                        goto not_nan_or_inf;

                    default:
                        goto not_nan_or_inf;
                }

            default:
                goto not_nan_or_inf;
        }

        not_nan_or_inf:
#endif
        type = looks_like_number(sv);
    }

    return type;
}

MODULE = Scalar::Util::Numeric    PACKAGE = Scalar::Util::Numeric

void
uvmax()
    PROTOTYPE:
    CODE:
        XSRETURN_UV(UV_MAX);

void
isnum (sv)
    SV * sv
    PROTOTYPE: $
    CODE:
        XSRETURN_IV(is_num(aTHX_ sv));

void
isint (sv)
    SV * sv
    PROTOTYPE: $
    CODE:
        I32 type = is_num(aTHX_ sv);
        I32 ret;

        if (type == 1) {
            ret = 1;
        } else if (type == 9) {
            ret = -1;
        } else {
            ret = -0;
        }

        XSRETURN_IV(ret);

void
isuv (sv)
    SV * sv
    PROTOTYPE: $
    CODE:
        XSRETURN_IV((is_num(aTHX_ sv) & 1) ? 1 : 0);

void
isbig (sv)
    SV * sv
    PROTOTYPE: $
    CODE:
        XSRETURN_IV((is_num(aTHX_ sv) & 2) ? 1 : 0);

void
isfloat (sv)
    SV * sv
    PROTOTYPE: $
    CODE:
        XSRETURN_IV((is_num(aTHX_ sv) & 4) ? 1 : 0);

void
isneg (sv)
    SV * sv
    PROTOTYPE: $
    CODE:
        XSRETURN_IV((is_num(aTHX_ sv) & 8) ? 1 : 0);

void
isinf (sv)
    SV * sv
    PROTOTYPE: $
    CODE:
        XSRETURN_IV((is_num(aTHX_ sv) & 16) ? 1 : 0);

void
isnan (sv)
    SV * sv
    PROTOTYPE: $
    CODE:
        XSRETURN_IV((is_num(aTHX_ sv) & 32) ? 1 : 0);
