#! perl
# Copyright (C) 2005, The Perl Foundation.
# $Id: /local/languages/python/t/pmc/pyfunc.t 12840 2006-05-30T15:08:05.048089Z coke  $

use strict;
use warnings;
use lib qw( . lib ../lib ../../lib );
use Test::More skip_all => "Python dynamic PMCs are not maintained";
use Parrot::Test tests => 4;
use Parrot::Config;


=head1 NAME

t/pmc/pyfunc.t - Python Functions

=head1 SYNOPSIS

	% prove t/pmc/pyfunc.t

=head1 DESCRIPTION

Tests Python Functions.

=cut

use Parrot::Test tests => 4;

my $base = << 'CODE';

.sub __main__ :main
    new_pad 0
    loadlib P1, "python_group"

    find_type $I0, "PyFunc"       
    newsub $P0, $I0, _f0          

    $P0[0] = 'x'
    $P0[1] = 'y'
    $P0[2] = 'z'

    find_type $I1, "PyList"        
    new $P1, $I1                  
    $P1[0] = "uno"
    $P1[1] = "dos"
    $P1[2] = "tres"
    setprop $P0, 'func_defaults', $P1

    store_lex -1, 'f', $P0

    testcase()
.end

.sub _f0 :anon
    .param object x   
    .param object y   
    .param object z   

    print_item x
    print_item y
    print_item z
    print_newline                 

    .return ()
.end

CODE

pir_output_is($base . << 'CODE', << 'OUTPUT', "full");
.sub testcase
    find_lex $P0, "f"

    find_type $I2, "PyString"        
    new $P1, $I2                  
    new $P2, $I2                  
    new $P3, $I2                  
    $P1 = "one"
    $P2 = "two"
    $P3 = "three"

    $P0($P1,$P2,$P3)
.end
CODE
one two three
OUTPUT

pir_output_is($base . << 'CODE', << 'OUTPUT', "defaults");
.sub testcase
    find_lex $P0, "f"

    find_type $I2, "PyString"        
    new $P1, $I2                  
    new $P2, $I2                  
    $P1 = "one"
    $P2 = "two"

    $P0($P1,$P2)
    $P0($P1)
    $P0()
.end
CODE
one two tres
one dos tres
uno dos tres
OUTPUT

pir_output_is($base . << 'CODE', << 'OUTPUT', "positional expression");
.sub testcase
    find_lex $P0, "f"

    find_type $I1, "PyList"
    new $P1, $I1

    find_type $I2, "PyDict"
    new $P2, $I2

    $P0.__call__($P1, $P2)

    push $P1, "one"

    $P0.__call__($P1, $P2)

    push $P1, "two"

    $P0.__call__($P1, $P2)
.end
CODE
uno dos tres
one dos tres
one two tres
OUTPUT

pir_output_is($base . << 'CODE', << 'OUTPUT', "keyword expression");
.sub testcase
    find_lex $P0, "f"

    find_type $I1, "PyList"
    new $P1, $I1

    find_type $I2, "PyDict"
    new $P2, $I2

    $P2['y'] = "two"

    $P0.__call__($P1, $P2)

    $P2['z'] = "three"

    $P0.__call__($P1, $P2)

    $P2['x'] = "one"

    $P0.__call__($P1, $P2)
.end
CODE
uno two tres
uno two three
one two three
OUTPUT
