#!perl
use strict;
use warnings;

use Test::More;
use t::Util    qw[throws_ok lives_ok];

BEGIN {
    use_ok('Time::Moment');
}

{
    my @tests = (
        [ -62135596800,         0, '0001-01-01T00:00:00Z'           ],
        [ -62135596800, 123456789, '0001-01-01T00:00:00.123456789Z' ],
        [ -62135596800, 123456000, '0001-01-01T00:00:00.123456Z'    ],
        [ -62135596800, 123000000, '0001-01-01T00:00:00.123Z'       ],
        [            0,         0, '1970-01-01T00:00:00Z'           ],
        [ 253402300799,         0, '9999-12-31T23:59:59Z'           ],
        [ 253402300799, 987654321, '9999-12-31T23:59:59.987654321Z' ],
        [ 253402300799, 987654000, '9999-12-31T23:59:59.987654Z'    ],
        [ 253402300799, 987000000, '9999-12-31T23:59:59.987Z'       ],
    );

    foreach my $test (@tests) {
        my ($secs, $nos, $string) = @$test;
        my $tm;
        lives_ok { $tm = Time::Moment->from_epoch($secs, $nos) } "from_epoch($secs, $nos)";
        is($tm->epoch,       $secs,   "from_epoch($secs, $nos)->epoch");
        is($tm->nanosecond,  $nos,    "from_epoch($secs, $nos)->nanosecond");
        is($tm->offset,      0,       "from_epoch($secs, $nos)->offset");
        is($tm->to_string,   $string, "from_epoch($secs, $nos)->to_string");
    }
}

{
    my @tests = (
        [ '1936-08-24T11:39:57.320914Z', -1052569202.679085969924927 ],
        [ '1937-06-03T01:21:28.762968Z', -1028155111.237032055854797 ],
        [ '1939-07-03T00:50:18.466058Z', -962492981.533941984176636  ],
        [ '1941-02-14T13:36:17.618587Z', -911298222.381412982940674  ],
        [ '1942-09-23T23:05:10.469894Z', -860633689.530105948448181  ],
        [ '1944-03-16T20:08:33.831258Z', -813988286.168741941452026  ],
        [ '1946-08-04T09:26:27.828225Z', -738772412.171774983406067  ],
        [ '1949-03-21T07:52:51.057354Z', -655834028.942646026611328  ],
        [ '1949-06-08T03:33:29.683894Z', -649023990.316105961799622  ],
        [ '1950-06-13T07:14:28.028592Z', -617042731.971408009529114  ],
        [ '1952-09-11T01:39:52.884454Z', -546128407.115545988082886  ],
        [ '1953-12-08T07:10:08.177198Z', -506969391.822802007198334  ],
        [ '1956-03-22T16:01:40.430624Z', -434793499.569375991821289  ],
        [ '1958-03-06T03:22:18.539818Z', -373149461.460182011127472  ],
        [ '1958-07-19T20:22:03.795263Z', -361424276.20473700761795   ],
        [ '1960-08-06T23:17:12.265765Z', -296700167.734234988689423  ],
        [ '1960-09-24T06:18:14.972603Z', -292527705.027396976947784  ],
        [ '1963-05-15T15:55:21.678044Z', -209289878.321956008672714  ],
        [ '1965-07-03T00:15:50.929753Z', -141954249.070246994495392  ],
        [ '1967-04-18T06:46:56.689393Z', -85425183.310607001185417   ],
        [ '1969-12-31T00:00:00.999999Z', -86399.000000999993063      ],
        [ '1970-01-01T00:00:00Z',        0                           ],
        [ '1970-01-01T00:00:00.999999Z', 0.999999                    ],
        [ '1972-01-09T14:40:04.830045Z', 63816004.830044999718666    ],
        [ '1974-07-25T20:57:38.579644Z', 144017858.579643994569778   ],
        [ '1975-06-14T15:05:59.325212Z', 171990359.325212001800537   ],
        [ '1975-10-21T18:58:31.089527Z', 183149911.089527010917664   ],
        [ '1977-05-07T12:27:47.228509Z', 231856067.22850900888443    ],
        [ '1977-12-26T18:44:01.935770Z', 252009841.935770004987717   ],
        [ '1979-07-14T22:49:58.944910Z', 300840598.944909989833832   ],
        [ '1979-12-10T16:42:35.379793Z', 313692155.379792988300323   ],
        [ '1981-03-10T07:45:14.168389Z', 353058314.168389022350311   ],
        [ '1982-04-19T09:12:22.192669Z', 388055542.192668974399567   ],
        [ '1982-05-01T06:41:32.444018Z', 389083292.444018006324768   ],
        [ '1984-02-19T17:23:37.489470Z', 446059417.4894700050354     ],
        [ '1984-06-29T02:11:32.681826Z', 457323092.681825995445251   ],
        [ '1986-07-07T08:20:58.038464Z', 521108458.03846400976181    ],
        [ '1988-06-22T19:32:15.671250Z', 583011135.671249985694885   ],
        [ '1989-03-04T09:22:28.917558Z', 605006548.917557954788208   ],
        [ '1991-09-02T18:44:33.690216Z', 683837073.690215945243835   ],
        [ '1994-02-20T23:32:43.847238Z', 761787163.847237944602966   ],
        [ '1996-05-28T13:33:40.585896Z', 833290420.585896015167236   ],
        [ '1998-07-04T04:43:56.397516Z', 899527436.397516012191772   ],
    );

    foreach my $test (@tests) {
        my ($string, $epoch) = @$test;

        my $tm = Time::Moment->from_epoch($epoch);
        is($tm->to_string, $string, "Time::Moment->from_epoch($epoch)");
    }
}

done_testing();
