# *** DO NOT EDIT *** generated file *** DO NOT EDIT ***
#
# generated by lib/Net/IDN/UTS46/GenTests.PL from data/IdnaTest.txt
# see repository at http://github.com/cfaerber/Net-IDN-Encode for source files
#
use strict;
use utf8;
use warnings;

BEGIN {
  binmode STDOUT, ':utf8';
  binmode STDERR, ':utf8';
}

use Test::More tests => 615 + 1;
use Test::NoWarnings;
use Net::IDN::UTS46 (':all');
BEGIN { 
	plan skip_all => 'no XS version' if eval {
		\&Net::IDN::Punycode::encode_punycode ==
		\&Net::IDN::Punycode::PP::encode_punycode; }
}
no warnings 'utf8';

my %p = ("TransitionalProcessing" => "0");

is(eval{uts46_to_ascii("fass.de", %p)},	"fass.de",	"to_ascii\(\'fass\.de\'\)\ \[data\/IdnaTest\.txt\:45\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("FASS.DE", %p)},	"FASS.DE",	"to_ascii\(\'FASS\.DE\'\)\ \[data\/IdnaTest\.txt\:46\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Fass.de", %p)},	"Fass.de",	"to_ascii\(\'Fass\.de\'\)\ \[data\/IdnaTest\.txt\:47\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("faß.de", %p)},	"xn--fa-hia.de",	"to_ascii\(\'faß\.de\'\)\ \[data\/IdnaTest\.txt\:49\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Faß.de", %p)},	"xn--fa-hia.de",	"to_ascii\(\'Faß\.de\'\)\ \[data\/IdnaTest\.txt\:51\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--fa-hia.de", %p)},	"xn--fa-hia.de",	"to_ascii\(\'xn\-\-fa\-hia\.de\'\)\ \[data\/IdnaTest\.txt\:52\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--FA-HIA.DE", %p)},	"xn--fa-hia.de",	"to_ascii\(\'XN\-\-FA\-HIA\.DE\'\)\ \[data\/IdnaTest\.txt\:53\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Fa-Hia.de", %p)},	"xn--fa-hia.de",	"to_ascii\(\'Xn\-\-Fa\-Hia\.de\'\)\ \[data\/IdnaTest\.txt\:54\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à\x{05D0}", %p)},	undef,	"to_ascii\(\'à\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:55\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À\x{05D0}", %p)},	undef,	"to_ascii\(\'À\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:56\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0à.\x{05D0}", %p)},	undef,	"to_ascii\(\'0à\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:57\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0À.\x{05D0}", %p)},	undef,	"to_ascii\(\'0À\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:58\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'à\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:59\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À.\x{05D0}\x{0308}", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'À\.\\u05D0\\u0308\'\)\ \[data\/IdnaTest\.txt\:60\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca.xn--ssa73l", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'xn\-\-0ca\.xn\-\-ssa73l\'\)\ \[data\/IdnaTest\.txt\:61\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--0CA.XN--SSA73L", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'XN\-\-0CA\.XN\-\-SSA73L\'\)\ \[data\/IdnaTest\.txt\:62\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--0Ca.xn--Ssa73l", %p)},	"xn--0ca.xn--ssa73l",	"to_ascii\(\'Xn\-\-0Ca\.xn\-\-Ssa73l\'\)\ \[data\/IdnaTest\.txt\:63\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'à\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:64\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À.\x{05D0}0\x{0660}\x{05D0}", %p)},	undef,	"to_ascii\(\'À\.\\u05D00\\u0660\\u05D0\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:65\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}.\x{05D0}", %p)},	undef,	"to_ascii\(\'\\u0308\.\\u05D0\'\)\ throws\ error\ V5\ B1\ B3\ B6\ \[data\/IdnaTest\.txt\:66\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'à\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:67\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À.\x{05D0}0\x{0660}", %p)},	undef,	"to_ascii\(\'À\.\\u05D00\\u0660\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:68\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("àˇ.\x{05D0}", %p)},	undef,	"to_ascii\(\'àˇ\.\\u05D0\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:69\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Àˇ.\x{05D0}", %p)},	undef,	"to_ascii\(\'Àˇ\.\\u05D0\'\)\ throws\ error\ B6\ \[data\/IdnaTest\.txt\:70\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("à\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'à\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:71\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("À\x{0308}.\x{05D0}", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'À\\u0308\.\\u05D0\'\)\ \[data\/IdnaTest\.txt\:72\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ca81i.xn--4db", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'xn\-\-0ca81i\.xn\-\-4db\'\)\ \[data\/IdnaTest\.txt\:73\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--0CA81I.XN--4DB", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'XN\-\-0CA81I\.XN\-\-4DB\'\)\ \[data\/IdnaTest\.txt\:74\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--0Ca81i.xn--4Db", %p)},	"xn--0ca81i.xn--4db",	"to_ascii\(\'Xn\-\-0Ca81i\.xn\-\-4Db\'\)\ \[data\/IdnaTest\.txt\:75\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{200C}b", %p)},	undef,	"to_ascii\(\'a\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:77\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200C}B", %p)},	undef,	"to_ascii\(\'A\\u200CB\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:79\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200C}b", %p)},	undef,	"to_ascii\(\'A\\u200Cb\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:81\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ab", %p)},	"ab",	"to_ascii\(\'ab\'\)\ \[data\/IdnaTest\.txt\:82\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("AB", %p)},	"AB",	"to_ascii\(\'AB\'\)\ \[data\/IdnaTest\.txt\:83\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ab", %p)},	"Ab",	"to_ascii\(\'Ab\'\)\ \[data\/IdnaTest\.txt\:84\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{094D}\x{200C}b", %p)},	"xn--ab-fsf604u",	"to_ascii\(\'a\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:86\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200C}B", %p)},	"xn--ab-fsf604u",	"to_ascii\(\'A\\u094D\\u200CB\'\)\ \[data\/IdnaTest\.txt\:88\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200C}b", %p)},	"xn--ab-fsf604u",	"to_ascii\(\'A\\u094D\\u200Cb\'\)\ \[data\/IdnaTest\.txt\:90\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-fsf", %p)},	"xn--ab-fsf",	"to_ascii\(\'xn\-\-ab\-fsf\'\)\ \[data\/IdnaTest\.txt\:91\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--AB-FSF", %p)},	"xn--ab-fsf",	"to_ascii\(\'XN\-\-AB\-FSF\'\)\ \[data\/IdnaTest\.txt\:92\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Ab-Fsf", %p)},	"xn--ab-fsf",	"to_ascii\(\'Xn\-\-Ab\-Fsf\'\)\ \[data\/IdnaTest\.txt\:93\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{094D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'a\\u094Db\'\)\ \[data\/IdnaTest\.txt\:94\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}B", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094DB\'\)\ \[data\/IdnaTest\.txt\:95\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}b", %p)},	"xn--ab-fsf",	"to_ascii\(\'A\\u094Db\'\)\ \[data\/IdnaTest\.txt\:96\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-fsf604u", %p)},	"xn--ab-fsf604u",	"to_ascii\(\'xn\-\-ab\-fsf604u\'\)\ \[data\/IdnaTest\.txt\:97\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--AB-FSF604U", %p)},	"xn--ab-fsf604u",	"to_ascii\(\'XN\-\-AB\-FSF604U\'\)\ \[data\/IdnaTest\.txt\:98\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Ab-Fsf604u", %p)},	"xn--ab-fsf604u",	"to_ascii\(\'Xn\-\-Ab\-Fsf604u\'\)\ \[data\/IdnaTest\.txt\:99\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:101\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:103\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:105\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200C}\x{0308}", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200C\\u0308\'\)\ throws\ error\ B5\ B6\ C1\ \[data\/IdnaTest\.txt\:107\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:109\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628B\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:111\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200C}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200C\\u0308\\u0628b\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:113\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{200D}b", %p)},	undef,	"to_ascii\(\'a\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:115\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200D}B", %p)},	undef,	"to_ascii\(\'A\\u200DB\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:117\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{200D}b", %p)},	undef,	"to_ascii\(\'A\\u200Db\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:119\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{094D}\x{200D}b", %p)},	"xn--ab-fsf014u",	"to_ascii\(\'a\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:121\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200D}B", %p)},	"xn--ab-fsf014u",	"to_ascii\(\'A\\u094D\\u200DB\'\)\ \[data\/IdnaTest\.txt\:123\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{094D}\x{200D}b", %p)},	"xn--ab-fsf014u",	"to_ascii\(\'A\\u094D\\u200Db\'\)\ \[data\/IdnaTest\.txt\:125\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ab-fsf014u", %p)},	"xn--ab-fsf014u",	"to_ascii\(\'xn\-\-ab\-fsf014u\'\)\ \[data\/IdnaTest\.txt\:126\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--AB-FSF014U", %p)},	"xn--ab-fsf014u",	"to_ascii\(\'XN\-\-AB\-FSF014U\'\)\ \[data\/IdnaTest\.txt\:127\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Ab-Fsf014u", %p)},	"xn--ab-fsf014u",	"to_ascii\(\'Xn\-\-Ab\-Fsf014u\'\)\ \[data\/IdnaTest\.txt\:128\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:130\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:132\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:134\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200D}\x{0308}", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200D\\u0308\'\)\ throws\ error\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:136\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'a\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:138\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}B", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628B\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:140\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{0628}\x{0308}\x{200D}\x{0308}\x{0628}b", %p)},	undef,	"to_ascii\(\'A\\u0628\\u0308\\u200D\\u0308\\u0628b\'\)\ throws\ error\ B5\ C2\ \[data\/IdnaTest\.txt\:142\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1234567890ä1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890ä1234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:143\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1234567890Ä1234567890123456789012345678901234567890123456", %p)},	undef,	"to_ascii\(\'1234567890Ä1234567890123456789012345678901234567890123456\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:144\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.eXample.cOm", %p)},	"www.eXample.cOm",	"to_ascii\(\'www\.eXample\.cOm\'\)\ \[data\/IdnaTest\.txt\:145\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.example.com", %p)},	"www.example.com",	"to_ascii\(\'www\.example\.com\'\)\ \[data\/IdnaTest\.txt\:146\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("WWW.EXAMPLE.COM", %p)},	"WWW.EXAMPLE.COM",	"to_ascii\(\'WWW\.EXAMPLE\.COM\'\)\ \[data\/IdnaTest\.txt\:147\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Www.example.com", %p)},	"Www.example.com",	"to_ascii\(\'Www\.example\.com\'\)\ \[data\/IdnaTest\.txt\:148\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Bücher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'Bücher\.de\'\)\ \[data\/IdnaTest\.txt\:149\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("bücher.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'bücher\.de\'\)\ \[data\/IdnaTest\.txt\:150\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("BÜCHER.DE", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'BÜCHER\.DE\'\)\ \[data\/IdnaTest\.txt\:151\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bcher-kva.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'xn\-\-bcher\-kva\.de\'\)\ \[data\/IdnaTest\.txt\:152\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--BCHER-KVA.DE", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'XN\-\-BCHER\-KVA\.DE\'\)\ \[data\/IdnaTest\.txt\:153\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Bcher-Kva.de", %p)},	"xn--bcher-kva.de",	"to_ascii\(\'Xn\-\-Bcher\-Kva\.de\'\)\ \[data\/IdnaTest\.txt\:154\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ÖBB", %p)},	"xn--bb-eka",	"to_ascii\(\'ÖBB\'\)\ \[data\/IdnaTest\.txt\:155\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("öbb", %p)},	"xn--bb-eka",	"to_ascii\(\'öbb\'\)\ \[data\/IdnaTest\.txt\:156\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Öbb", %p)},	"xn--bb-eka",	"to_ascii\(\'Öbb\'\)\ \[data\/IdnaTest\.txt\:157\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bb-eka", %p)},	"xn--bb-eka",	"to_ascii\(\'xn\-\-bb\-eka\'\)\ \[data\/IdnaTest\.txt\:158\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--BB-EKA", %p)},	"xn--bb-eka",	"to_ascii\(\'XN\-\-BB\-EKA\'\)\ \[data\/IdnaTest\.txt\:159\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Bb-Eka", %p)},	"xn--bb-eka",	"to_ascii\(\'Xn\-\-Bb\-Eka\'\)\ \[data\/IdnaTest\.txt\:160\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--fA-hia.dE", %p)},	"xn--fa-hia.de",	"to_ascii\(\'XN\-\-fA\-hia\.dE\'\)\ \[data\/IdnaTest\.txt\:161\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλος.com", %p)},	"xn--nxasmm1c.com",	"to_ascii\(\'βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:163\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΌΛΟΣ.COM", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'ΒΌΛΟΣ\.COM\'\)\ \[data\/IdnaTest\.txt\:164\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:165\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλοσ.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Βόλοσ\.com\'\)\ \[data\/IdnaTest\.txt\:166\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmq6b.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'xn\-\-nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:167\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--NXASMQ6B.COM", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'XN\-\-NXASMQ6B\.COM\'\)\ \[data\/IdnaTest\.txt\:168\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Nxasmq6b.com", %p)},	"xn--nxasmq6b.com",	"to_ascii\(\'Xn\-\-Nxasmq6b\.com\'\)\ \[data\/IdnaTest\.txt\:169\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλος.com", %p)},	"xn--nxasmm1c.com",	"to_ascii\(\'Βόλος\.com\'\)\ \[data\/IdnaTest\.txt\:171\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmm1c.com", %p)},	"xn--nxasmm1c.com",	"to_ascii\(\'xn\-\-nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:172\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--NXASMM1C.COM", %p)},	"xn--nxasmm1c.com",	"to_ascii\(\'XN\-\-NXASMM1C\.COM\'\)\ \[data\/IdnaTest\.txt\:173\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Nxasmm1c.com", %p)},	"xn--nxasmm1c.com",	"to_ascii\(\'Xn\-\-Nxasmm1c\.com\'\)\ \[data\/IdnaTest\.txt\:174\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmm1c", %p)},	"xn--nxasmm1c",	"to_ascii\(\'xn\-\-nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:175\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--NXASMM1C", %p)},	"xn--nxasmm1c",	"to_ascii\(\'XN\-\-NXASMM1C\'\)\ \[data\/IdnaTest\.txt\:176\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Nxasmm1c", %p)},	"xn--nxasmm1c",	"to_ascii\(\'Xn\-\-Nxasmm1c\'\)\ \[data\/IdnaTest\.txt\:177\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλος", %p)},	"xn--nxasmm1c",	"to_ascii\(\'βόλος\'\)\ \[data\/IdnaTest\.txt\:179\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ΒΌΛΟΣ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'ΒΌΛΟΣ\'\)\ \[data\/IdnaTest\.txt\:180\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("βόλοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'βόλοσ\'\)\ \[data\/IdnaTest\.txt\:181\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλοσ", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Βόλοσ\'\)\ \[data\/IdnaTest\.txt\:182\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--nxasmq6b", %p)},	"xn--nxasmq6b",	"to_ascii\(\'xn\-\-nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:183\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--NXASMQ6B", %p)},	"xn--nxasmq6b",	"to_ascii\(\'XN\-\-NXASMQ6B\'\)\ \[data\/IdnaTest\.txt\:184\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Nxasmq6b", %p)},	"xn--nxasmq6b",	"to_ascii\(\'Xn\-\-Nxasmq6b\'\)\ \[data\/IdnaTest\.txt\:185\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Βόλος", %p)},	"xn--nxasmm1c",	"to_ascii\(\'Βόλος\'\)\ \[data\/IdnaTest\.txt\:187\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b660p.com",	"to_ascii\(\'www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:189\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("WWW.ශ\x{0DCA}\x{200D}ර\x{0DD3}.COM", %p)},	"www.xn--10cl1a0b660p.com",	"to_ascii\(\'WWW\.ශ\\u0DCA\\u200Dර\\u0DD3\.COM\'\)\ \[data\/IdnaTest\.txt\:191\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Www.ශ\x{0DCA}\x{200D}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b660p.com",	"to_ascii\(\'Www\.ශ\\u0DCA\\u200Dර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:193\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.xn--10cl1a0b.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'www\.xn\-\-10cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:194\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("WWW.XN--10CL1A0B.COM", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'WWW\.XN\-\-10CL1A0B\.COM\'\)\ \[data\/IdnaTest\.txt\:195\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Www.xn--10Cl1a0b.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'Www\.xn\-\-10Cl1a0b\.com\'\)\ \[data\/IdnaTest\.txt\:196\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.ශ\x{0DCA}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:197\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("WWW.ශ\x{0DCA}ර\x{0DD3}.COM", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'WWW\.ශ\\u0DCAර\\u0DD3\.COM\'\)\ \[data\/IdnaTest\.txt\:198\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Www.ශ\x{0DCA}ර\x{0DD3}.com", %p)},	"www.xn--10cl1a0b.com",	"to_ascii\(\'Www\.ශ\\u0DCAර\\u0DD3\.com\'\)\ \[data\/IdnaTest\.txt\:199\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("www.xn--10cl1a0b660p.com", %p)},	"www.xn--10cl1a0b660p.com",	"to_ascii\(\'www\.xn\-\-10cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:200\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("WWW.XN--10CL1A0B660P.COM", %p)},	"www.xn--10cl1a0b660p.com",	"to_ascii\(\'WWW\.XN\-\-10CL1A0B660P\.COM\'\)\ \[data\/IdnaTest\.txt\:201\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Www.xn--10Cl1a0b660p.com", %p)},	"www.xn--10cl1a0b660p.com",	"to_ascii\(\'Www\.xn\-\-10Cl1a0b660p\.com\'\)\ \[data\/IdnaTest\.txt\:202\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}", %p)},	"xn--mgba3gch31f060k",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:204\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'xn\-\-mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:205\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--MGBA3GCH31F", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'XN\-\-MGBA3GCH31F\'\)\ \[data\/IdnaTest\.txt\:206\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Mgba3gch31f", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'Xn\-\-Mgba3gch31f\'\)\ \[data\/IdnaTest\.txt\:207\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}", %p)},	"xn--mgba3gch31f",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\'\)\ \[data\/IdnaTest\.txt\:208\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f060k", %p)},	"xn--mgba3gch31f060k",	"to_ascii\(\'xn\-\-mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:209\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--MGBA3GCH31F060K", %p)},	"xn--mgba3gch31f060k",	"to_ascii\(\'XN\-\-MGBA3GCH31F060K\'\)\ \[data\/IdnaTest\.txt\:210\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Mgba3gch31f060k", %p)},	"xn--mgba3gch31f060k",	"to_ascii\(\'Xn\-\-Mgba3gch31f060k\'\)\ \[data\/IdnaTest\.txt\:211\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f060k.com", %p)},	"xn--mgba3gch31f060k.com",	"to_ascii\(\'xn\-\-mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:212\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--MGBA3GCH31F060K.COM", %p)},	"xn--mgba3gch31f060k.com",	"to_ascii\(\'XN\-\-MGBA3GCH31F060K\.COM\'\)\ \[data\/IdnaTest\.txt\:213\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Mgba3gch31f060k.com", %p)},	"xn--mgba3gch31f060k.com",	"to_ascii\(\'Xn\-\-Mgba3gch31f060k\.com\'\)\ \[data\/IdnaTest\.txt\:214\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.com", %p)},	"xn--mgba3gch31f060k.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:216\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.COM", %p)},	"xn--mgba3gch31f060k.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.COM\'\)\ \[data\/IdnaTest\.txt\:218\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{200C}\x{0627}\x{06CC}.Com", %p)},	"xn--mgba3gch31f060k.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u200C\\u0627\\u06CC\.Com\'\)\ \[data\/IdnaTest\.txt\:220\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--mgba3gch31f.com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'xn\-\-mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:221\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--MGBA3GCH31F.COM", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'XN\-\-MGBA3GCH31F\.COM\'\)\ \[data\/IdnaTest\.txt\:222\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Mgba3gch31f.com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'Xn\-\-Mgba3gch31f\.com\'\)\ \[data\/IdnaTest\.txt\:223\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.com\'\)\ \[data\/IdnaTest\.txt\:224\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.COM", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.COM\'\)\ \[data\/IdnaTest\.txt\:225\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0646}\x{0627}\x{0645}\x{0647}\x{0627}\x{06CC}.Com", %p)},	"xn--mgba3gch31f.com",	"to_ascii\(\'\\u0646\\u0627\\u0645\\u0647\\u0627\\u06CC\.Com\'\)\ \[data\/IdnaTest\.txt\:226\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b．c。d｡", %p)},	"a.b．c。d｡",	"to_ascii\(\'a\.b．c。d｡\'\)\ \[data\/IdnaTest\.txt\:227\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B．C。D｡", %p)},	"A.B．C。D｡",	"to_ascii\(\'A\.B．C。D｡\'\)\ \[data\/IdnaTest\.txt\:228\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b．c。D｡", %p)},	"A.b．c。D｡",	"to_ascii\(\'A\.b．c。D｡\'\)\ \[data\/IdnaTest\.txt\:229\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.c.d.", %p)},	"a.b.c.d.",	"to_ascii\(\'a\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:230\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B.C.D.", %p)},	"A.B.C.D.",	"to_ascii\(\'A\.B\.C\.D\.\'\)\ \[data\/IdnaTest\.txt\:231\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b.c.d.", %p)},	"A.b.c.d.",	"to_ascii\(\'A\.b\.c\.d\.\'\)\ \[data\/IdnaTest\.txt\:232\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:233\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:234\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ü.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'ü\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:235\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.XN--TDA", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.XN\-\-TDA\'\)\ \[data\/IdnaTest\.txt\:236\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.xn--Tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.xn\-\-Tda\'\)\ \[data\/IdnaTest\.txt\:237\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--tda.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'xn\-\-tda\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:238\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--TDA.XN--TDA", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'XN\-\-TDA\.XN\-\-TDA\'\)\ \[data\/IdnaTest\.txt\:239\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Tda.xn--Tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Xn\-\-Tda\.xn\-\-Tda\'\)\ \[data\/IdnaTest\.txt\:240\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ü.ü", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'ü\.ü\'\)\ \[data\/IdnaTest\.txt\:241\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.Ü", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.Ü\'\)\ \[data\/IdnaTest\.txt\:242\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ü.ü", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'Ü\.ü\'\)\ \[data\/IdnaTest\.txt\:243\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("u\x{0308}.xn--tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'u\\u0308\.xn\-\-tda\'\)\ \[data\/IdnaTest\.txt\:244\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.XN--TDA", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.XN\-\-TDA\'\)\ \[data\/IdnaTest\.txt\:245\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("U\x{0308}.xn--Tda", %p)},	"xn--tda.xn--tda",	"to_ascii\(\'U\\u0308\.xn\-\-Tda\'\)\ \[data\/IdnaTest\.txt\:246\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--u-ccb", %p)},	undef,	"to_ascii\(\'xn\-\-u\-ccb\'\)\ throws\ error\ V1\ \[data\/IdnaTest\.txt\:247\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--U-CCB", %p)},	undef,	"to_ascii\(\'XN\-\-U\-CCB\'\)\ throws\ error\ V1\ \[data\/IdnaTest\.txt\:248\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--U-Ccb", %p)},	undef,	"to_ascii\(\'Xn\-\-U\-Ccb\'\)\ throws\ error\ V1\ \[data\/IdnaTest\.txt\:249\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a⒈com", %p)},	undef,	"to_ascii\(\'a⒈com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:250\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A⒈COM", %p)},	undef,	"to_ascii\(\'A⒈COM\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:251\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A⒈Com", %p)},	undef,	"to_ascii\(\'A⒈Com\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:252\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-ecp.ru", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ecp\.ru\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:253\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--A-ECP.RU", %p)},	undef,	"to_ascii\(\'XN\-\-A\-ECP\.RU\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:254\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--A-Ecp.ru", %p)},	undef,	"to_ascii\(\'Xn\-\-A\-Ecp\.ru\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:255\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0.pt", %p)},	undef,	"to_ascii\(\'xn\-\-0\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:256\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--0.PT", %p)},	undef,	"to_ascii\(\'XN\-\-0\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:257\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--0.Pt", %p)},	undef,	"to_ascii\(\'Xn\-\-0\.Pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:258\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\.pt\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:259\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--A.PT", %p)},	undef,	"to_ascii\(\'XN\-\-A\.PT\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:260\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--A.pt", %p)},	undef,	"to_ascii\(\'Xn\-\-A\.pt\'\)\ throws\ error\ V6\ \[data\/IdnaTest\.txt\:261\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-Ä.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:262\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--a-ä.pt", %p)},	undef,	"to_ascii\(\'xn\-\-a\-ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:263\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--A-Ä.PT", %p)},	undef,	"to_ascii\(\'XN\-\-A\-Ä\.PT\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:264\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--A-Ä.pt", %p)},	undef,	"to_ascii\(\'Xn\-\-A\-Ä\.pt\'\)\ throws\ error\ A3\ \[data\/IdnaTest\.txt\:265\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。ＪＰ", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語。ＪＰ\'\)\ \[data\/IdnaTest\.txt\:266\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。ｊｐ", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語。ｊｐ\'\)\ \[data\/IdnaTest\.txt\:267\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語。Ｊｐ", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語。Ｊｐ\'\)\ \[data\/IdnaTest\.txt\:268\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--wgv71a119e.jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'xn\-\-wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:269\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--WGV71A119E.JP", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'XN\-\-WGV71A119E\.JP\'\)\ \[data\/IdnaTest\.txt\:270\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Wgv71a119e.jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'Xn\-\-Wgv71a119e\.jp\'\)\ \[data\/IdnaTest\.txt\:271\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語.jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\.jp\'\)\ \[data\/IdnaTest\.txt\:272\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語.JP", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\.JP\'\)\ \[data\/IdnaTest\.txt\:273\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("日本語.Jp", %p)},	"xn--wgv71a119e.jp",	"to_ascii\(\'日本語\.Jp\'\)\ \[data\/IdnaTest\.txt\:274\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("☕", %p)},	"xn--53h",	"to_ascii\(\'☕\'\)\ \[data\/IdnaTest\.txt\:275\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--53h", %p)},	"xn--53h",	"to_ascii\(\'xn\-\-53h\'\)\ \[data\/IdnaTest\.txt\:276\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--53H", %p)},	"xn--53h",	"to_ascii\(\'XN\-\-53H\'\)\ \[data\/IdnaTest\.txt\:277\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--53H", %p)},	"xn--53h",	"to_ascii\(\'Xn\-\-53H\'\)\ \[data\/IdnaTest\.txt\:278\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("1.aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_ascii\(\'1\.aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:280\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\x{0302}SSZ", %p)},	undef,	"to_ascii\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\\u0302SSZ\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:282\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ASS\x{200C}\x{200D}B\x{200C}\x{200D}CSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", %p)},	undef,	"to_ascii\(\'1\.ASS\\u200C\\u200DB\\u200C\\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:284\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_ascii\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:286\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", %p)},	undef,	"to_ascii\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:288\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_ascii\(\'1\.ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:290\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Ass\x{200C}\x{200D}b\x{200C}\x{200D}cssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\x{0302}ssz", %p)},	undef,	"to_ascii\(\'1\.Ass\\u200C\\u200Db\\u200C\\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\\u0302ssz\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:292\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("1.Aß\x{200C}\x{200D}b\x{200C}\x{200D}cßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\x{0302}ßz", %p)},	undef,	"to_ascii\(\'1\.Aß\\u200C\\u200Db\\u200C\\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\\u0302ßz\'\)\ throws\ error\ C1\ C2\ A4_2\ \[data\/IdnaTest\.txt\:294\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bß", %p)},	undef,	"to_ascii\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:296\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}X\x{200D}N\x{200C}-\x{200D}-BSS", %p)},	undef,	"to_ascii\(\'\\u200CX\\u200DN\\u200C\-\\u200D\-BSS\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:298\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}x\x{200D}n\x{200C}-\x{200D}-bss", %p)},	undef,	"to_ascii\(\'\\u200Cx\\u200Dn\\u200C\-\\u200D\-bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:300\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bss", %p)},	undef,	"to_ascii\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bss\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:302\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--bss", %p)},	"xn--bss",	"to_ascii\(\'xn\-\-bss\'\)\ \[data\/IdnaTest\.txt\:303\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--BSS", %p)},	"xn--bss",	"to_ascii\(\'XN\-\-BSS\'\)\ \[data\/IdnaTest\.txt\:304\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Bss", %p)},	"xn--bss",	"to_ascii\(\'Xn\-\-Bss\'\)\ \[data\/IdnaTest\.txt\:305\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("夙", %p)},	"xn--bss",	"to_ascii\(\'夙\'\)\ \[data\/IdnaTest\.txt\:306\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}X\x{200D}n\x{200C}-\x{200D}-Bß", %p)},	undef,	"to_ascii\(\'\\u200CX\\u200Dn\\u200C\-\\u200D\-Bß\'\)\ throws\ error\ C1\ C2\ \[data\/IdnaTest\.txt\:308\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}ſ\x{2064}𝔰\x{E01EF}ﬄ", %p)},	"xn--bssffl",	"to_ascii\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00ſ\\u2064𝔰\\uDB40\\uDDEFﬄ\'\)\ \[data\/IdnaTest\.txt\:309\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}S\x{2064}𝔰\x{E01EF}FFL", %p)},	"xn--bssffl",	"to_ascii\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00S\\u2064𝔰\\uDB40\\uDDEFFFL\'\)\ \[data\/IdnaTest\.txt\:310\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("ˣ\x{034F}ℕ\x{200B}﹣\x{00AD}－\x{180C}ℬ\x{FE00}s\x{2064}𝔰\x{E01EF}ffl", %p)},	"xn--bssffl",	"to_ascii\(\'ˣ\\u034Fℕ\\u200B﹣\\u00AD－\\u180Cℬ\\uFE00s\\u2064𝔰\\uDB40\\uDDEFffl\'\)\ \[data\/IdnaTest\.txt\:311\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("xn--bssffl", %p)},	"xn--bssffl",	"to_ascii\(\'xn\-\-bssffl\'\)\ \[data\/IdnaTest\.txt\:312\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--BSSFFL", %p)},	"xn--bssffl",	"to_ascii\(\'XN\-\-BSSFFL\'\)\ \[data\/IdnaTest\.txt\:313\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Bssffl", %p)},	"xn--bssffl",	"to_ascii\(\'Xn\-\-Bssffl\'\)\ \[data\/IdnaTest\.txt\:314\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("夡夞夜夙", %p)},	"xn--bssffl",	"to_ascii\(\'夡夞夜夙\'\)\ \[data\/IdnaTest\.txt\:315\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:316\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:317\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:318\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:319\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:320\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901234\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_2\ A4_1\ \[data\/IdnaTest\.txt\:321\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:322\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä1234567890123456789012345678901234567890123456789012345", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'Ä1234567890123456789012345678901234567890123456789012345\'\)\ \[data\/IdnaTest\.txt\:323\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--1234567890123456789012345678901234567890123456789012345-9te", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'xn\-\-1234567890123456789012345678901234567890123456789012345\-9te\'\)\ \[data\/IdnaTest\.txt\:324\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--1234567890123456789012345678901234567890123456789012345-9TE", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'XN\-\-1234567890123456789012345678901234567890123456789012345\-9TE\'\)\ \[data\/IdnaTest\.txt\:325\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--1234567890123456789012345678901234567890123456789012345-9Te", %p)},	"xn--1234567890123456789012345678901234567890123456789012345-9te",	"to_ascii\(\'Xn\-\-1234567890123456789012345678901234567890123456789012345\-9Te\'\)\ \[data\/IdnaTest\.txt\:326\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:327\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:328\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:329\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.XN--1234567890123456789012345678901234567890123456789012345-KUE.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.XN\-\-1234567890123456789012345678901234567890123456789012345\-KUE\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:330\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.Xn--1234567890123456789012345678901234567890123456789012345-Kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.Xn\-\-1234567890123456789012345678901234567890123456789012345\-Kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ \[data\/IdnaTest\.txt\:331\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:332\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:333\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.xn\-\-1234567890123456789012345678901234567890123456789012345\-kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:334\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.XN--1234567890123456789012345678901234567890123456789012345-KUE.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.XN\-\-1234567890123456789012345678901234567890123456789012345\-KUE\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:335\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.Xn--1234567890123456789012345678901234567890123456789012345-Kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", %p)},	"123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.",	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.Xn\-\-1234567890123456789012345678901234567890123456789012345\-Kue\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\.\'\)\ \[data\/IdnaTest\.txt\:336\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:337\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä123456789012345678901234567890123456789012345\.123456789012345678901234567890123456789012345678901234567890123\.12345678901234567890123456789012345678901234567890123456789012\'\)\ throws\ error\ A4_1\ \[data\/IdnaTest\.txt\:338\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:339\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:340\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:341\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.123456789012345678901234567890123456789012345678901234567890\.\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:342\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_2\ A4_1\ \[data\/IdnaTest\.txt\:343\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", %p)},	undef,	"to_ascii\(\'123456789012345678901234567890123456789012345678901234567890123\.1234567890Ä1234567890123456789012345678901234567890123456\.123456789012345678901234567890123456789012345678901234567890123\.1234567890123456789012345678901234567890123456789012345678901\'\)\ throws\ error\ A4_2\ A4_1\ \[data\/IdnaTest\.txt\:344\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..-q--a-.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.\-q\-\-a\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:345\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B..-Q--A-.E", %p)},	undef,	"to_ascii\(\'A\.B\.\.\-Q\-\-A\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:346\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b..-Q--A-.E", %p)},	undef,	"to_ascii\(\'A\.b\.\.\-Q\-\-A\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:347\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..-q--ä-.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.\-q\-\-ä\-\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:348\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B..-Q--Ä-.E", %p)},	undef,	"to_ascii\(\'A\.B\.\.\-Q\-\-Ä\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:349\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b..-Q--Ä-.E", %p)},	undef,	"to_ascii\(\'A\.b\.\.\-Q\-\-Ä\-\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:350\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b..xn---q----jra.e", %p)},	undef,	"to_ascii\(\'a\.b\.\.xn\-\-\-q\-\-\-\-jra\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:351\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B..XN---Q----JRA.E", %p)},	undef,	"to_ascii\(\'A\.B\.\.XN\-\-\-Q\-\-\-\-JRA\.E\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:352\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b..Xn---Q----Jra.e", %p)},	undef,	"to_ascii\(\'A\.b\.\.Xn\-\-\-Q\-\-\-\-Jra\.e\'\)\ throws\ error\ V2\ V3\ A4_2\ \[data\/IdnaTest\.txt\:353\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a..c", %p)},	undef,	"to_ascii\(\'a\.\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:354\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A..C", %p)},	undef,	"to_ascii\(\'A\.\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:355\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.-b.", %p)},	undef,	"to_ascii\(\'a\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:356\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.-B.", %p)},	undef,	"to_ascii\(\'A\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:357\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b-.c", %p)},	undef,	"to_ascii\(\'a\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:358\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B-.C", %p)},	undef,	"to_ascii\(\'A\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:359\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b-.C", %p)},	undef,	"to_ascii\(\'A\.b\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:360\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.-.c", %p)},	undef,	"to_ascii\(\'a\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:361\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.-.C", %p)},	undef,	"to_ascii\(\'A\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:362\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.bc--de.f", %p)},	undef,	"to_ascii\(\'a\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:363\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.BC--DE.F", %p)},	undef,	"to_ascii\(\'A\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:364\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.bc--De.f", %p)},	undef,	"to_ascii\(\'A\.bc\-\-De\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:365\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.\x{00AD}.c", %p)},	undef,	"to_ascii\(\'ä\.\\u00AD\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:366\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.\x{00AD}.C", %p)},	undef,	"to_ascii\(\'Ä\.\\u00AD\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:367\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä..c", %p)},	undef,	"to_ascii\(\'ä\.\.c\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:368\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä..C", %p)},	undef,	"to_ascii\(\'Ä\.\.C\'\)\ throws\ error\ A4_2\ \[data\/IdnaTest\.txt\:369\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.-b.", %p)},	undef,	"to_ascii\(\'ä\.\-b\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:370\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.-B.", %p)},	undef,	"to_ascii\(\'Ä\.\-B\.\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:371\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.b-.c", %p)},	undef,	"to_ascii\(\'ä\.b\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:372\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.B-.C", %p)},	undef,	"to_ascii\(\'Ä\.B\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:373\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.b-.C", %p)},	undef,	"to_ascii\(\'Ä\.b\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:374\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.-.c", %p)},	undef,	"to_ascii\(\'ä\.\-\.c\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:375\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.-.C", %p)},	undef,	"to_ascii\(\'Ä\.\-\.C\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:376\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ä.bc--de.f", %p)},	undef,	"to_ascii\(\'ä\.bc\-\-de\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:377\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.BC--DE.F", %p)},	undef,	"to_ascii\(\'Ä\.BC\-\-DE\.F\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:378\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Ä.bc--De.f", %p)},	undef,	"to_ascii\(\'Ä\.bc\-\-De\.f\'\)\ throws\ error\ V2\ \[data\/IdnaTest\.txt\:379\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.\x{0308}c.d", %p)},	undef,	"to_ascii\(\'a\.b\.\\u0308c\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:380\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B.\x{0308}C.D", %p)},	undef,	"to_ascii\(\'A\.B\.\\u0308C\.D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:381\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b.\x{0308}c.d", %p)},	undef,	"to_ascii\(\'A\.b\.\\u0308c\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:382\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a.b.xn--c-bcb.d", %p)},	undef,	"to_ascii\(\'a\.b\.xn\-\-c\-bcb\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:383\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.B.XN--C-BCB.D", %p)},	undef,	"to_ascii\(\'A\.B\.XN\-\-C\-BCB\.D\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:384\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A.b.xn--C-Bcb.d", %p)},	undef,	"to_ascii\(\'A\.b\.xn\-\-C\-Bcb\.d\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:385\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A0", %p)},	"A0",	"to_ascii\(\'A0\'\)\ \[data\/IdnaTest\.txt\:386\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a0", %p)},	"a0",	"to_ascii\(\'a0\'\)\ \[data\/IdnaTest\.txt\:387\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0A", %p)},	"0A",	"to_ascii\(\'0A\'\)\ \[data\/IdnaTest\.txt\:388\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0a", %p)},	"0a",	"to_ascii\(\'0a\'\)\ \[data\/IdnaTest\.txt\:389\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0A.\x{05D0}", %p)},	undef,	"to_ascii\(\'0A\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:390\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("0a.\x{05D0}", %p)},	undef,	"to_ascii\(\'0a\.\\u05D0\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:391\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("c.xn--0-eha.xn--4db", %p)},	undef,	"to_ascii\(\'c\.xn\-\-0\-eha\.xn\-\-4db\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:392\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("C.XN--0-EHA.XN--4DB", %p)},	undef,	"to_ascii\(\'C\.XN\-\-0\-EHA\.XN\-\-4DB\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:393\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("C.xn--0-Eha.xn--4Db", %p)},	undef,	"to_ascii\(\'C\.xn\-\-0\-Eha\.xn\-\-4Db\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:394\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("b-.\x{05D0}", %p)},	undef,	"to_ascii\(\'b\-\.\\u05D0\'\)\ throws\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:395\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("B-.\x{05D0}", %p)},	undef,	"to_ascii\(\'B\-\.\\u05D0\'\)\ throws\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:396\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("d.xn----dha.xn--4db", %p)},	undef,	"to_ascii\(\'d\.xn\-\-\-\-dha\.xn\-\-4db\'\)\ throws\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:397\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("D.XN----DHA.XN--4DB", %p)},	undef,	"to_ascii\(\'D\.XN\-\-\-\-DHA\.XN\-\-4DB\'\)\ throws\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:398\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("D.xn----Dha.xn--4Db", %p)},	undef,	"to_ascii\(\'D\.xn\-\-\-\-Dha\.xn\-\-4Db\'\)\ throws\ error\ V3\ B6\ \[data\/IdnaTest\.txt\:399\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{05D0}", %p)},	undef,	"to_ascii\(\'a\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:400\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{05D0}", %p)},	undef,	"to_ascii\(\'A\\u05D0\'\)\ throws\ error\ B5\ B6\ \[data\/IdnaTest\.txt\:401\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("\x{05D0}\x{05C7}", %p)},	"xn--vdbr",	"to_ascii\(\'\\u05D0\\u05C7\'\)\ \[data\/IdnaTest\.txt\:402\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("xn--vdbr", %p)},	"xn--vdbr",	"to_ascii\(\'xn\-\-vdbr\'\)\ \[data\/IdnaTest\.txt\:403\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("XN--VDBR", %p)},	"xn--vdbr",	"to_ascii\(\'XN\-\-VDBR\'\)\ \[data\/IdnaTest\.txt\:404\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("Xn--Vdbr", %p)},	"xn--vdbr",	"to_ascii\(\'Xn\-\-Vdbr\'\)\ \[data\/IdnaTest\.txt\:405\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("\x{05D0}9\x{05C7}", %p)},	"xn--9-ihcz",	"to_ascii\(\'\\u05D09\\u05C7\'\)\ \[data\/IdnaTest\.txt\:406\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("xn--9-ihcz", %p)},	"xn--9-ihcz",	"to_ascii\(\'xn\-\-9\-ihcz\'\)\ \[data\/IdnaTest\.txt\:407\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("XN--9-IHCZ", %p)},	"xn--9-ihcz",	"to_ascii\(\'XN\-\-9\-IHCZ\'\)\ \[data\/IdnaTest\.txt\:408\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("Xn--9-Ihcz", %p)},	"xn--9-ihcz",	"to_ascii\(\'Xn\-\-9\-Ihcz\'\)\ \[data\/IdnaTest\.txt\:409\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("\x{05D0}a\x{05C7}", %p)},	undef,	"to_ascii\(\'\\u05D0a\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:410\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("\x{05D0}A\x{05C7}", %p)},	undef,	"to_ascii\(\'\\u05D0A\\u05C7\'\)\ throws\ error\ B2\ B3\ \[data\/IdnaTest\.txt\:411\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{05D0}\x{05EA}", %p)},	"xn--4db6c",	"to_ascii\(\'\\u05D0\\u05EA\'\)\ \[data\/IdnaTest\.txt\:412\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4db6c", %p)},	"xn--4db6c",	"to_ascii\(\'xn\-\-4db6c\'\)\ \[data\/IdnaTest\.txt\:413\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--4DB6C", %p)},	"xn--4db6c",	"to_ascii\(\'XN\-\-4DB6C\'\)\ \[data\/IdnaTest\.txt\:414\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--4Db6c", %p)},	"xn--4db6c",	"to_ascii\(\'Xn\-\-4Db6c\'\)\ \[data\/IdnaTest\.txt\:415\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}\x{05F3}\x{05EA}", %p)},	"xn--4db6c0a",	"to_ascii\(\'\\u05D0\\u05F3\\u05EA\'\)\ \[data\/IdnaTest\.txt\:416\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4db6c0a", %p)},	"xn--4db6c0a",	"to_ascii\(\'xn\-\-4db6c0a\'\)\ \[data\/IdnaTest\.txt\:417\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--4DB6C0A", %p)},	"xn--4db6c0a",	"to_ascii\(\'XN\-\-4DB6C0A\'\)\ \[data\/IdnaTest\.txt\:418\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--4Db6c0a", %p)},	"xn--4db6c0a",	"to_ascii\(\'Xn\-\-4Db6c0a\'\)\ \[data\/IdnaTest\.txt\:419\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{05D0}Tz", %p)},	undef,	"to_ascii\(\'a\\u05D0Tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:420\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a\x{05D0}tz", %p)},	undef,	"to_ascii\(\'a\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:421\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{05D0}TZ", %p)},	undef,	"to_ascii\(\'A\\u05D0TZ\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:422\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A\x{05D0}tz", %p)},	undef,	"to_ascii\(\'A\\u05D0tz\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:423\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}T\x{05EA}", %p)},	undef,	"to_ascii\(\'\\u05D0T\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:424\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}t\x{05EA}", %p)},	undef,	"to_ascii\(\'\\u05D0t\\u05EA\'\)\ throws\ error\ B2\ \[data\/IdnaTest\.txt\:425\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}7\x{05EA}", %p)},	"xn--7-zhc3f",	"to_ascii\(\'\\u05D07\\u05EA\'\)\ \[data\/IdnaTest\.txt\:426\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--7-zhc3f", %p)},	"xn--7-zhc3f",	"to_ascii\(\'xn\-\-7\-zhc3f\'\)\ \[data\/IdnaTest\.txt\:427\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--7-ZHC3F", %p)},	"xn--7-zhc3f",	"to_ascii\(\'XN\-\-7\-ZHC3F\'\)\ \[data\/IdnaTest\.txt\:428\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--7-Zhc3f", %p)},	"xn--7-zhc3f",	"to_ascii\(\'Xn\-\-7\-Zhc3f\'\)\ \[data\/IdnaTest\.txt\:429\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}\x{0667}\x{05EA}", %p)},	"xn--4db6c6t",	"to_ascii\(\'\\u05D0\\u0667\\u05EA\'\)\ \[data\/IdnaTest\.txt\:430\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--4db6c6t", %p)},	"xn--4db6c6t",	"to_ascii\(\'xn\-\-4db6c6t\'\)\ \[data\/IdnaTest\.txt\:431\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--4DB6C6T", %p)},	"xn--4db6c6t",	"to_ascii\(\'XN\-\-4DB6C6T\'\)\ \[data\/IdnaTest\.txt\:432\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--4Db6c6t", %p)},	"xn--4db6c6t",	"to_ascii\(\'Xn\-\-4Db6c6t\'\)\ \[data\/IdnaTest\.txt\:433\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("a7\x{0667}z", %p)},	undef,	"to_ascii\(\'a7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:434\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A7\x{0667}Z", %p)},	undef,	"to_ascii\(\'A7\\u0667Z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:435\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("A7\x{0667}z", %p)},	undef,	"to_ascii\(\'A7\\u0667z\'\)\ throws\ error\ B5\ \[data\/IdnaTest\.txt\:436\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{05D0}7\x{0667}\x{05EA}", %p)},	undef,	"to_ascii\(\'\\u05D07\\u0667\\u05EA\'\)\ throws\ error\ B4\ \[data\/IdnaTest\.txt\:437\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{0BCD}\x{200D}", %p)},	"xn--dmc4b194h",	"to_ascii\(\'ஹ\\u0BCD\\u200D\'\)\ \[data\/IdnaTest\.txt\:439\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc4b", %p)},	"xn--dmc4b",	"to_ascii\(\'xn\-\-dmc4b\'\)\ \[data\/IdnaTest\.txt\:440\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--DMC4B", %p)},	"xn--dmc4b",	"to_ascii\(\'XN\-\-DMC4B\'\)\ \[data\/IdnaTest\.txt\:441\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Dmc4b", %p)},	"xn--dmc4b",	"to_ascii\(\'Xn\-\-Dmc4b\'\)\ \[data\/IdnaTest\.txt\:442\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{0BCD}", %p)},	"xn--dmc4b",	"to_ascii\(\'ஹ\\u0BCD\'\)\ \[data\/IdnaTest\.txt\:443\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc4b194h", %p)},	"xn--dmc4b194h",	"to_ascii\(\'xn\-\-dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:444\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--DMC4B194H", %p)},	"xn--dmc4b194h",	"to_ascii\(\'XN\-\-DMC4B194H\'\)\ \[data\/IdnaTest\.txt\:445\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Dmc4b194h", %p)},	"xn--dmc4b194h",	"to_ascii\(\'Xn\-\-Dmc4b194h\'\)\ \[data\/IdnaTest\.txt\:446\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{200D}", %p)},	undef,	"to_ascii\(\'ஹ\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:448\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc", %p)},	"xn--dmc",	"to_ascii\(\'xn\-\-dmc\'\)\ \[data\/IdnaTest\.txt\:449\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--DMC", %p)},	"xn--dmc",	"to_ascii\(\'XN\-\-DMC\'\)\ \[data\/IdnaTest\.txt\:450\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Dmc", %p)},	"xn--dmc",	"to_ascii\(\'Xn\-\-Dmc\'\)\ \[data\/IdnaTest\.txt\:451\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ", %p)},	"xn--dmc",	"to_ascii\(\'ஹ\'\)\ \[data\/IdnaTest\.txt\:452\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200D}", %p)},	undef,	"to_ascii\(\'\\u200D\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:454\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("", %p)},	"",	"to_ascii\(\'\'\)\ \[data\/IdnaTest\.txt\:455\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{0BCD}\x{200C}", %p)},	"xn--dmc4by94h",	"to_ascii\(\'ஹ\\u0BCD\\u200C\'\)\ \[data\/IdnaTest\.txt\:457\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--dmc4by94h", %p)},	"xn--dmc4by94h",	"to_ascii\(\'xn\-\-dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:458\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--DMC4BY94H", %p)},	"xn--dmc4by94h",	"to_ascii\(\'XN\-\-DMC4BY94H\'\)\ \[data\/IdnaTest\.txt\:459\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Dmc4by94h", %p)},	"xn--dmc4by94h",	"to_ascii\(\'Xn\-\-Dmc4by94h\'\)\ \[data\/IdnaTest\.txt\:460\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("ஹ\x{200C}", %p)},	undef,	"to_ascii\(\'ஹ\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:462\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{200C}", %p)},	undef,	"to_ascii\(\'\\u200C\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:464\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{200C}\x{06ED}\x{06EF}", %p)},	"xn--ghb2gxqia7523a",	"to_ascii\(\'\\u0644\\u0670\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:466\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--ghb2gxqia", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'xn\-\-ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:467\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--GHB2GXQIA", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'XN\-\-GHB2GXQIA\'\)\ \[data\/IdnaTest\.txt\:468\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--Ghb2gxqia", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'Xn\-\-Ghb2gxqia\'\)\ \[data\/IdnaTest\.txt\:469\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{06ED}\x{06EF}", %p)},	"xn--ghb2gxqia",	"to_ascii\(\'\\u0644\\u0670\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:470\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--ghb2gxqia7523a", %p)},	"xn--ghb2gxqia7523a",	"to_ascii\(\'xn\-\-ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:471\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--GHB2GXQIA7523A", %p)},	"xn--ghb2gxqia7523a",	"to_ascii\(\'XN\-\-GHB2GXQIA7523A\'\)\ \[data\/IdnaTest\.txt\:472\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--Ghb2gxqia7523a", %p)},	"xn--ghb2gxqia7523a",	"to_ascii\(\'Xn\-\-Ghb2gxqia7523a\'\)\ \[data\/IdnaTest\.txt\:473\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{200C}\x{06EF}", %p)},	"xn--ghb2g3qq34f",	"to_ascii\(\'\\u0644\\u0670\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:475\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--ghb2g3q", %p)},	"xn--ghb2g3q",	"to_ascii\(\'xn\-\-ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:476\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--GHB2G3Q", %p)},	"xn--ghb2g3q",	"to_ascii\(\'XN\-\-GHB2G3Q\'\)\ \[data\/IdnaTest\.txt\:477\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--Ghb2g3q", %p)},	"xn--ghb2g3q",	"to_ascii\(\'Xn\-\-Ghb2g3q\'\)\ \[data\/IdnaTest\.txt\:478\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{06EF}", %p)},	"xn--ghb2g3q",	"to_ascii\(\'\\u0644\\u0670\\u06EF\'\)\ \[data\/IdnaTest\.txt\:479\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--ghb2g3qq34f", %p)},	"xn--ghb2g3qq34f",	"to_ascii\(\'xn\-\-ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:480\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--GHB2G3QQ34F", %p)},	"xn--ghb2g3qq34f",	"to_ascii\(\'XN\-\-GHB2G3QQ34F\'\)\ \[data\/IdnaTest\.txt\:481\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--Ghb2g3qq34f", %p)},	"xn--ghb2g3qq34f",	"to_ascii\(\'Xn\-\-Ghb2g3qq34f\'\)\ \[data\/IdnaTest\.txt\:482\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{0644}\x{200C}\x{06ED}\x{06EF}", %p)},	"xn--ghb25aga828w",	"to_ascii\(\'\\u0644\\u200C\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:484\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--ghb25aga", %p)},	"xn--ghb25aga",	"to_ascii\(\'xn\-\-ghb25aga\'\)\ \[data\/IdnaTest\.txt\:485\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--GHB25AGA", %p)},	"xn--ghb25aga",	"to_ascii\(\'XN\-\-GHB25AGA\'\)\ \[data\/IdnaTest\.txt\:486\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--Ghb25aga", %p)},	"xn--ghb25aga",	"to_ascii\(\'Xn\-\-Ghb25aga\'\)\ \[data\/IdnaTest\.txt\:487\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{0644}\x{06ED}\x{06EF}", %p)},	"xn--ghb25aga",	"to_ascii\(\'\\u0644\\u06ED\\u06EF\'\)\ \[data\/IdnaTest\.txt\:488\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--ghb25aga828w", %p)},	"xn--ghb25aga828w",	"to_ascii\(\'xn\-\-ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:489\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--GHB25AGA828W", %p)},	"xn--ghb25aga828w",	"to_ascii\(\'XN\-\-GHB25AGA828W\'\)\ \[data\/IdnaTest\.txt\:490\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--Ghb25aga828w", %p)},	"xn--ghb25aga828w",	"to_ascii\(\'Xn\-\-Ghb25aga828w\'\)\ \[data\/IdnaTest\.txt\:491\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{0644}\x{200C}\x{06EF}", %p)},	"xn--ghb65a953d",	"to_ascii\(\'\\u0644\\u200C\\u06EF\'\)\ \[data\/IdnaTest\.txt\:493\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--ghb65a", %p)},	"xn--ghb65a",	"to_ascii\(\'xn\-\-ghb65a\'\)\ \[data\/IdnaTest\.txt\:494\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--GHB65A", %p)},	"xn--ghb65a",	"to_ascii\(\'XN\-\-GHB65A\'\)\ \[data\/IdnaTest\.txt\:495\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--Ghb65a", %p)},	"xn--ghb65a",	"to_ascii\(\'Xn\-\-Ghb65a\'\)\ \[data\/IdnaTest\.txt\:496\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{0644}\x{06EF}", %p)},	"xn--ghb65a",	"to_ascii\(\'\\u0644\\u06EF\'\)\ \[data\/IdnaTest\.txt\:497\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--ghb65a953d", %p)},	"xn--ghb65a953d",	"to_ascii\(\'xn\-\-ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:498\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--GHB65A953D", %p)},	"xn--ghb65a953d",	"to_ascii\(\'XN\-\-GHB65A953D\'\)\ \[data\/IdnaTest\.txt\:499\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--Ghb65a953d", %p)},	"xn--ghb65a953d",	"to_ascii\(\'Xn\-\-Ghb65a953d\'\)\ \[data\/IdnaTest\.txt\:500\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{200C}\x{06ED}", %p)},	undef,	"to_ascii\(\'\\u0644\\u0670\\u200C\\u06ED\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:502\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb2gxq", %p)},	"xn--ghb2gxq",	"to_ascii\(\'xn\-\-ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:503\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--GHB2GXQ", %p)},	"xn--ghb2gxq",	"to_ascii\(\'XN\-\-GHB2GXQ\'\)\ \[data\/IdnaTest\.txt\:504\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Ghb2gxq", %p)},	"xn--ghb2gxq",	"to_ascii\(\'Xn\-\-Ghb2gxq\'\)\ \[data\/IdnaTest\.txt\:505\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}\x{0670}\x{06ED}", %p)},	"xn--ghb2gxq",	"to_ascii\(\'\\u0644\\u0670\\u06ED\'\)\ \[data\/IdnaTest\.txt\:506\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{06EF}\x{200C}\x{06EF}", %p)},	undef,	"to_ascii\(\'\\u06EF\\u200C\\u06EF\'\)\ throws\ error\ C1\ \[data\/IdnaTest\.txt\:508\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("xn--cmba", %p)},	"xn--cmba",	"to_ascii\(\'xn\-\-cmba\'\)\ \[data\/IdnaTest\.txt\:509\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("XN--CMBA", %p)},	"xn--cmba",	"to_ascii\(\'XN\-\-CMBA\'\)\ \[data\/IdnaTest\.txt\:510\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Xn--Cmba", %p)},	"xn--cmba",	"to_ascii\(\'Xn\-\-Cmba\'\)\ \[data\/IdnaTest\.txt\:511\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{06EF}\x{06EF}", %p)},	"xn--cmba",	"to_ascii\(\'\\u06EF\\u06EF\'\)\ \[data\/IdnaTest\.txt\:512\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0644}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0644\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:514\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--ghb", %p)},	"xn--ghb",	"to_ascii\(\'xn\-\-ghb\'\)\ \[data\/IdnaTest\.txt\:515\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--GHB", %p)},	"xn--ghb",	"to_ascii\(\'XN\-\-GHB\'\)\ \[data\/IdnaTest\.txt\:516\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--Ghb", %p)},	"xn--ghb",	"to_ascii\(\'Xn\-\-Ghb\'\)\ \[data\/IdnaTest\.txt\:517\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0644}", %p)},	"xn--ghb",	"to_ascii\(\'\\u0644\'\)\ \[data\/IdnaTest\.txt\:518\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{063D}\x{10DD6}\x{1039}", %p)},	undef,	"to_ascii\(\'\\u063D\\uD803\\uDDD6\\u1039\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:519\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("𝟽\x{1A56}\x{10E7B}", %p)},	undef,	"to_ascii\(\'𝟽\\u1A56\\uD803\\uDE7B\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:520\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E01C8}．\x{0684}\x{200C}\x{1ED62}\x{06EE}", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDDC8．\\u0684\\u200C\\uD83B\\uDD62\\u06EE\'\)\ throws\ error\ P1\ V6\ C1\ \[data\/IdnaTest\.txt\:522\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("ς\x{069C}\x{0772}\x{05BC}｡𝟎-\x{10A3F}\x{200C}\x{1BA3}\x{FD24}｡〓-\x{5E484}\x{0321}", %p)},	undef,	"to_ascii\(\'ς\\u069C\\u0772\\u05BC｡𝟎\-\\uD802\\uDE3F\\u200C\\u1BA3\\uFD24｡〓\-\\uD939\\uDC84\\u0321\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:524\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("Σ\x{069C}\x{0772}\x{05BC}｡𝟎-\x{10A3F}\x{200C}\x{1BA3}\x{FD24}｡〓-\x{5E484}\x{0321}", %p)},	undef,	"to_ascii\(\'Σ\\u069C\\u0772\\u05BC｡𝟎\-\\uD802\\uDE3F\\u200C\\u1BA3\\uFD24｡〓\-\\uD939\\uDC84\\u0321\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:526\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("σ\x{069C}\x{0772}\x{05BC}｡𝟎-\x{10A3F}\x{200C}\x{1BA3}\x{FD24}｡〓-\x{5E484}\x{0321}", %p)},	undef,	"to_ascii\(\'σ\\u069C\\u0772\\u05BC｡𝟎\-\\uD802\\uDE3F\\u200C\\u1BA3\\uFD24｡〓\-\\uD939\\uDC84\\u0321\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ \[data\/IdnaTest\.txt\:528\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{FD55}\x{AA338}-\x{10E66}\x{10837}\x{E04D8}\x{E0194}", %p)},	undef,	"to_ascii\(\'\\uFD55\\uDA68\\uDF38\-\\uD803\\uDE66\\uD802\\uDC37\\uDB41\\uDCD8\\uDB40\\uDD94\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:529\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{A953}\x{0636}\x{10A3F}\x{06C1}\x{17D2}\x{200C}ς｡\x{10D1F}\x{11C05}\x{067A}\x{062D}", %p)},	undef,	"to_ascii\(\'\\uA953\\u0636\\uD802\\uDE3F\\u06C1\\u17D2\\u200Cς｡\\uD803\\uDD1F\\uD807\\uDC05\\u067A\\u062D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B2\ \[data\/IdnaTest\.txt\:531\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{A953}\x{0636}\x{10A3F}\x{06C1}\x{17D2}\x{200C}Σ｡\x{10D1F}\x{11C05}\x{067A}\x{062D}", %p)},	undef,	"to_ascii\(\'\\uA953\\u0636\\uD802\\uDE3F\\u06C1\\u17D2\\u200CΣ｡\\uD803\\uDD1F\\uD807\\uDC05\\u067A\\u062D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B2\ \[data\/IdnaTest\.txt\:533\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{A953}\x{0636}\x{10A3F}\x{06C1}\x{17D2}\x{200C}σ｡\x{10D1F}\x{11C05}\x{067A}\x{062D}", %p)},	undef,	"to_ascii\(\'\\uA953\\u0636\\uD802\\uDE3F\\u06C1\\u17D2\\u200Cσ｡\\uD803\\uDD1F\\uD807\\uDC05\\u067A\\u062D\'\)\ throws\ error\ P1\ V5\ V6\ B5\ B2\ \[data\/IdnaTest\.txt\:535\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{A3336}\x{0340}\x{0721}\x{07DC}\x{2C01B}", %p)},	undef,	"to_ascii\(\'\\uDA4C\\uDF36\\u0340\\u0721\\u07DC\\uD870\\uDC1B\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:536\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{A3336}\x{0300}\x{0721}\x{07DC}\x{2C01B}", %p)},	undef,	"to_ascii\(\'\\uDA4C\\uDF36\\u0300\\u0721\\u07DC\\uD870\\uDC1B\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:537\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{067B}", %p)},	"xn--0ib",	"to_ascii\(\'\\u067B\'\)\ \[data\/IdnaTest\.txt\:538\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--0ib", %p)},	"xn--0ib",	"to_ascii\(\'xn\-\-0ib\'\)\ \[data\/IdnaTest\.txt\:539\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--0IB", %p)},	"xn--0ib",	"to_ascii\(\'XN\-\-0IB\'\)\ \[data\/IdnaTest\.txt\:540\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--0Ib", %p)},	"xn--0ib",	"to_ascii\(\'Xn\-\-0Ib\'\)\ \[data\/IdnaTest\.txt\:541\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E1FA9}-６\x{E0F69}｡𝟪\x{200C}\x{200C}-.-", %p)},	undef,	"to_ascii\(\'\\uDB47\\uDFA9\-６\\uDB43\\uDF69｡𝟪\\u200C\\u200C\-\.\-\'\)\ throws\ error\ P1\ V6\ V3\ C1\ \[data\/IdnaTest\.txt\:543\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0661}\x{200C}\x{1ECD1}", %p)},	undef,	"to_ascii\(\'\\u0661\\u200C\\uD83B\\uDCD1\'\)\ throws\ error\ P1\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:545\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{1A8F4}．\x{069F}\x{0639}.-\x{06E2}⒎", %p)},	undef,	"to_ascii\(\'\\uD82A\\uDCF4．\\u069F\\u0639\.\-\\u06E2⒎\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:546\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{067F}\x{10E6E}。-\x{063D}\x{5970E}。⫍\x{06AA}\x{FD9F}-", %p)},	undef,	"to_ascii\(\'\\u067F\\uD803\\uDE6E。\-\\u063D\\uD925\\uDF0E。⫍\\u06AA\\uFD9F\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:547\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E0140}\x{A806}．🄅\x{0643}.\x{FEE6}\x{E0082}\x{069E}", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDD40\\uA806．🄅\\u0643\.\\uFEE6\\uDB40\\uDC82\\u069E\'\)\ throws\ error\ P1\ V5\ V6\ B1\ B3\ B6\ \[data\/IdnaTest\.txt\:548\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("ß-⒏\x{A802}", %p)},	undef,	"to_ascii\(\'ß\-⒏\\uA802\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:550\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("SS-⒏\x{A802}", %p)},	undef,	"to_ascii\(\'SS\-⒏\\uA802\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:551\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("ss-⒏\x{A802}", %p)},	undef,	"to_ascii\(\'ss\-⒏\\uA802\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:552\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("Ss-⒏\x{A802}", %p)},	undef,	"to_ascii\(\'Ss\-⒏\\uA802\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:553\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{066B}\x{E01DF}ς\x{10E78}\x{10E67}\x{0733}。\x{FFF4}\x{075E}\x{10E78}", %p)},	undef,	"to_ascii\(\'\\u066B\\uDB40\\uDDDFς\\uD803\\uDE78\\uD803\\uDE67\\u0733。\\uFFF4\\u075E\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:555\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{066B}\x{E01DF}Σ\x{10E78}\x{10E67}\x{0733}。\x{FFF4}\x{075E}\x{10E78}", %p)},	undef,	"to_ascii\(\'\\u066B\\uDB40\\uDDDFΣ\\uD803\\uDE78\\uD803\\uDE67\\u0733。\\uFFF4\\u075E\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:556\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{066B}\x{E01DF}σ\x{10E78}\x{10E67}\x{0733}。\x{FFF4}\x{075E}\x{10E78}", %p)},	undef,	"to_ascii\(\'\\u066B\\uDB40\\uDDDFσ\\uD803\\uDE78\\uD803\\uDE67\\u0733。\\uFFF4\\u075E\\uD803\\uDE78\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:557\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟾\x{F4FAE}｡\x{E01A3}\x{0662}\x{074F}\x{10BDD}\x{6F18C}。ς\x{1714}\x{0F84}\x{07D6}-", %p)},	undef,	"to_ascii\(\'𝟾\\uDB93\\uDFAE｡\\uDB40\\uDDA3\\u0662\\u074F\\uD802\\uDFDD\\uD97C\\uDD8C。ς\\u1714\\u0F84\\u07D6\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:559\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟾\x{F4FAE}｡\x{E01A3}\x{0662}\x{074F}\x{10BDD}\x{6F18C}。Σ\x{1714}\x{0F84}\x{07D6}-", %p)},	undef,	"to_ascii\(\'𝟾\\uDB93\\uDFAE｡\\uDB40\\uDDA3\\u0662\\u074F\\uD802\\uDFDD\\uD97C\\uDD8C。Σ\\u1714\\u0F84\\u07D6\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:560\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟾\x{F4FAE}｡\x{E01A3}\x{0662}\x{074F}\x{10BDD}\x{6F18C}。σ\x{1714}\x{0F84}\x{07D6}-", %p)},	undef,	"to_ascii\(\'𝟾\\uDB93\\uDFAE｡\\uDB40\\uDDA3\\u0662\\u074F\\uD802\\uDFDD\\uD97C\\uDD8C。σ\\u1714\\u0F84\\u07D6\-\'\)\ throws\ error\ P1\ V6\ V3\ B1\ B5\ B6\ \[data\/IdnaTest\.txt\:561\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{10E6D}", %p)},	undef,	"to_ascii\(\'\\uD803\\uDE6D\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:562\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0660}\x{072B}⒊\x{8CD67}\x{0626}\x{0678}｡\x{10E71}\x{0662}\x{200D}\x{0770}\x{0E3A}\x{E019F}", %p)},	undef,	"to_ascii\(\'\\u0660\\u072B⒊\\uD9F3\\uDD67\\u0626\\u0678｡\\uD803\\uDE71\\u0662\\u200D\\u0770\\u0E3A\\uDB40\\uDD9F\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:564\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E0112}𝟭۵-\x{E0E3F}-\x{E010E}", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDD12𝟭۵\-\\uDB43\\uDE3F\-\\uDB40\\uDD0E\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:565\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{031C}", %p)},	undef,	"to_ascii\(\'\\u031C\'\)\ throws\ error\ V5\ \[data\/IdnaTest\.txt\:566\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0F79}⒏\x{0647}\x{A92C}\x{07D2}\x{10ED8}\x{059A}。\x{200C}\x{069E}", %p)},	undef,	"to_ascii\(\'\\u0F79⒏\\u0647\\uA92C\\u07D2\\uD803\\uDED8\\u059A。\\u200C\\u069E\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C1\ \[data\/IdnaTest\.txt\:568\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{200D}\x{17D2}\x{7A548}\x{0683}℈\x{20D9}", %p)},	undef,	"to_ascii\(\'\\u200D\\u17D2\\uD9A9\\uDD48\\u0683℈\\u20D9\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:570\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E0321}\x{200C}-", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDF21\\u200C\-\'\)\ throws\ error\ P1\ V3\ V6\ C1\ \[data\/IdnaTest\.txt\:572\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{17B5}\x{9DF60}-。\x{E0597}\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u17B5\\uDA37\\uDF60\-。\\uDB41\\uDD97\\u200C\\u200D\'\)\ throws\ error\ P1\ V3\ V6\ C1\ C2\ \[data\/IdnaTest\.txt\:574\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("𐅫", %p)},	"xn--gy7c",	"to_ascii\(\'𐅫\'\)\ \[data\/IdnaTest\.txt\:575\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("xn--gy7c", %p)},	"xn--gy7c",	"to_ascii\(\'xn\-\-gy7c\'\)\ \[data\/IdnaTest\.txt\:576\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("XN--GY7C", %p)},	"xn--gy7c",	"to_ascii\(\'XN\-\-GY7C\'\)\ \[data\/IdnaTest\.txt\:577\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008004, this is only perl $]", 1 if $] < 5.008004; is(eval{uts46_to_ascii("Xn--Gy7c", %p)},	"xn--gy7c",	"to_ascii\(\'Xn\-\-Gy7c\'\)\ \[data\/IdnaTest\.txt\:578\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{064A}\x{0BCD}-⁹\x{1DEFD}\x{06C5}\x{E0163}.\x{10E77}\x{200D}\x{0AC3}\x{E013B}-.\x{E04AD}\x{07ED}\x{E0817}\x{0626}𝟕", %p)},	undef,	"to_ascii\(\'\\u064A\\u0BCD\-⁹\\uD837\\uDEFD\\u06C5\\uDB40\\uDD63\.\\uD803\\uDE77\\u200D\\u0AC3\\uDB40\\uDD3B\-\.\\uDB41\\uDCAD\\u07ED\\uDB42\\uDC17\\u0626𝟕\'\)\ throws\ error\ P1\ V6\ V3\ B2\ B1\ C2\ \[data\/IdnaTest\.txt\:580\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{10E69}\x{06AD}\x{200C}\x{0309}。🄂\x{E007A}\x{A806}\x{47F43}--．\x{F4273}⩆⫝", %p)},	undef,	"to_ascii\(\'\\uD803\\uDE69\\u06AD\\u200C\\u0309。🄂\\uDB40\\uDC7A\\uA806\\uD8DF\\uDF43\-\-．\\uDB90\\uDE73⩆⫝\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:582\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{06B7}\x{200D}\x{06FA}\x{0646}\x{066F}．\x{0771}\x{E067C}\x{1E973}\x{066C}\x{0B4D}.\x{0649}\x{0714}\x{10A01}\x{E0BC1}\x{10E7E}", %p)},	undef,	"to_ascii\(\'\\u06B7\\u200D\\u06FA\\u0646\\u066F．\\u0771\\uDB41\\uDE7C\\uD83A\\uDD73\\u066C\\u0B4D\.\\u0649\\u0714\\uD802\\uDE01\\uDB42\\uDFC1\\uD803\\uDE7E\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:584\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E0C53}\x{06B7}⒕ς\x{1A7F}₆\x{E0A0E}｡\x{094D}\x{1714}\x{D7241}\x{0765}\x{989A0}｡\x{E006C}\x{200D}\x{06BC}", %p)},	undef,	"to_ascii\(\'\\uDB43\\uDC53\\u06B7⒕ς\\u1A7F₆\\uDB42\\uDE0E｡\\u094D\\u1714\\uDB1C\\uDE41\\u0765\\uDA22\\uDDA0｡\\uDB40\\uDC6C\\u200D\\u06BC\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:586\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E0C53}\x{06B7}⒕Σ\x{1A7F}₆\x{E0A0E}｡\x{094D}\x{1714}\x{D7241}\x{0765}\x{989A0}｡\x{E006C}\x{200D}\x{06BC}", %p)},	undef,	"to_ascii\(\'\\uDB43\\uDC53\\u06B7⒕Σ\\u1A7F₆\\uDB42\\uDE0E｡\\u094D\\u1714\\uDB1C\\uDE41\\u0765\\uDA22\\uDDA0｡\\uDB40\\uDC6C\\u200D\\u06BC\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:588\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E0C53}\x{06B7}⒕σ\x{1A7F}₆\x{E0A0E}｡\x{094D}\x{1714}\x{D7241}\x{0765}\x{989A0}｡\x{E006C}\x{200D}\x{06BC}", %p)},	undef,	"to_ascii\(\'\\uDB43\\uDC53\\u06B7⒕σ\\u1A7F₆\\uDB42\\uDE0E｡\\u094D\\u1714\\uDB1C\\uDE41\\u0765\\uDA22\\uDDA0｡\\uDB40\\uDC6C\\u200D\\u06BC\'\)\ throws\ error\ P1\ V6\ V5\ B1\ C2\ \[data\/IdnaTest\.txt\:590\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("𦜲\x{ABE8}\x{200D}\x{0760}｡\x{0F84}．ß", %p)},	undef,	"to_ascii\(\'𦜲\\uABE8\\u200D\\u0760｡\\u0F84．ß\'\)\ throws\ error\ V5\ B5\ B6\ B1\ B3\ C2\ \[data\/IdnaTest\.txt\:592\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("𦜲\x{ABE8}\x{200D}\x{0760}｡\x{0F84}．SS", %p)},	undef,	"to_ascii\(\'𦜲\\uABE8\\u200D\\u0760｡\\u0F84．SS\'\)\ throws\ error\ V5\ B5\ B6\ B1\ B3\ C2\ \[data\/IdnaTest\.txt\:594\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("𦜲\x{ABE8}\x{200D}\x{0760}｡\x{0F84}．ss", %p)},	undef,	"to_ascii\(\'𦜲\\uABE8\\u200D\\u0760｡\\u0F84．ss\'\)\ throws\ error\ V5\ B5\ B6\ B1\ B3\ C2\ \[data\/IdnaTest\.txt\:596\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("𦜲\x{ABE8}\x{200D}\x{0760}｡\x{0F84}．Ss", %p)},	undef,	"to_ascii\(\'𦜲\\uABE8\\u200D\\u0760｡\\u0F84．Ss\'\)\ throws\ error\ V5\ B5\ B6\ B1\ B3\ C2\ \[data\/IdnaTest\.txt\:598\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0FBC}\x{2DF5}\x{E0B68}.\x{102D}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0FBC\\u2DF5\\uDB42\\uDF68\.\\u102D\\u200C\'\)\ throws\ error\ P1\ V5\ V6\ C1\ \[data\/IdnaTest\.txt\:600\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("ß\x{0778}\x{E0531}\x{0F19}\x{0649}", %p)},	undef,	"to_ascii\(\'ß\\u0778\\uDB41\\uDD31\\u0F19\\u0649\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:602\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("SS\x{0778}\x{E0531}\x{0F19}\x{0649}", %p)},	undef,	"to_ascii\(\'SS\\u0778\\uDB41\\uDD31\\u0F19\\u0649\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:603\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("ss\x{0778}\x{E0531}\x{0F19}\x{0649}", %p)},	undef,	"to_ascii\(\'ss\\u0778\\uDB41\\uDD31\\u0F19\\u0649\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:604\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("Ss\x{0778}\x{E0531}\x{0F19}\x{0649}", %p)},	undef,	"to_ascii\(\'Ss\\u0778\\uDB41\\uDD31\\u0F19\\u0649\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:605\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("\x{E012E}.\x{0C4D}\x{077F}\x{FBE1}\x{200D}\x{200D}\x{05C4}\x{200C}｡\x{0F35}\x{200C}\x{0BCD}\x{06AB}\x{0666}", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDD2E\.\\u0C4D\\u077F\\uFBE1\\u200D\\u200D\\u05C4\\u200C｡\\u0F35\\u200C\\u0BCD\\u06AB\\u0666\'\)\ throws\ error\ V5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:607\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟣.\x{E0761}\x{73F52}\x{F7435}\x{E016F}6-\x{0943}。\x{53C57}ς\x{072D}\x{1CD4}𝟟\x{E0126}", %p)},	undef,	"to_ascii\(\'𝟣\.\\uDB41\\uDF61\\uD98F\\uDF52\\uDB9D\\uDC35\\uDB40\\uDD6F6\-\\u0943。\\uD90F\\uDC57ς\\u072D\\u1CD4𝟟\\uDB40\\uDD26\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:609\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟣.\x{E0761}\x{73F52}\x{F7435}\x{E016F}6-\x{0943}。\x{53C57}Σ\x{072D}\x{1CD4}𝟟\x{E0126}", %p)},	undef,	"to_ascii\(\'𝟣\.\\uDB41\\uDF61\\uD98F\\uDF52\\uDB9D\\uDC35\\uDB40\\uDD6F6\-\\u0943。\\uD90F\\uDC57Σ\\u072D\\u1CD4𝟟\\uDB40\\uDD26\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:610\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟣.\x{E0761}\x{73F52}\x{F7435}\x{E016F}6-\x{0943}。\x{53C57}σ\x{072D}\x{1CD4}𝟟\x{E0126}", %p)},	undef,	"to_ascii\(\'𝟣\.\\uDB41\\uDF61\\uD98F\\uDF52\\uDB9D\\uDC35\\uDB40\\uDD6F6\-\\u0943。\\uD90F\\uDC57σ\\u072D\\u1CD4𝟟\\uDB40\\uDD26\'\)\ throws\ error\ P1\ V6\ B1\ B5\ \[data\/IdnaTest\.txt\:611\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{1EE79}\x{200C}ς\x{E0934}\x{1DD6}.\x{1ECB2}ς\x{10E79}\x{EEBF8}\x{06A4}\x{200D}\x{10E7A}。\x{A806}\x{10AF3}\x{06C1}\x{1EAAA}", %p)},	undef,	"to_ascii\(\'\\uD83B\\uDE79\\u200Cς\\uDB42\\uDD34\\u1DD6\.\\uD83B\\uDCB2ς\\uD803\\uDE79\\uDB7A\\uDFF8\\u06A4\\u200D\\uD803\\uDE7A。\\uA806\\uD802\\uDEF3\\u06C1\\uD83A\\uDEAA\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:613\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{1EE79}\x{200C}Σ\x{E0934}\x{1DD6}.\x{1ECB2}Σ\x{10E79}\x{EEBF8}\x{06A4}\x{200D}\x{10E7A}。\x{A806}\x{10AF3}\x{06C1}\x{1EAAA}", %p)},	undef,	"to_ascii\(\'\\uD83B\\uDE79\\u200CΣ\\uDB42\\uDD34\\u1DD6\.\\uD83B\\uDCB2Σ\\uD803\\uDE79\\uDB7A\\uDFF8\\u06A4\\u200D\\uD803\\uDE7A。\\uA806\\uD802\\uDEF3\\u06C1\\uD83A\\uDEAA\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:615\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{1EE79}\x{200C}σ\x{E0934}\x{1DD6}.\x{1ECB2}σ\x{10E79}\x{EEBF8}\x{06A4}\x{200D}\x{10E7A}。\x{A806}\x{10AF3}\x{06C1}\x{1EAAA}", %p)},	undef,	"to_ascii\(\'\\uD83B\\uDE79\\u200Cσ\\uDB42\\uDD34\\u1DD6\.\\uD83B\\uDCB2σ\\uD803\\uDE79\\uDB7A\\uDFF8\\u06A4\\u200D\\uD803\\uDE7A。\\uA806\\uD802\\uDEF3\\u06C1\\uD83A\\uDEAA\'\)\ throws\ error\ P1\ V6\ V5\ B2\ B3\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:617\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{06CA}\x{A8C4}\x{066B}。\x{E0177}\x{1C180}\x{200C}\x{200D}\x{06E7}\x{10E79}", %p)},	undef,	"to_ascii\(\'\\u06CA\\uA8C4\\u066B。\\uDB40\\uDD77\\uD830\\uDD80\\u200C\\u200D\\u06E7\\uD803\\uDE79\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C1\ C2\ \[data\/IdnaTest\.txt\:619\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("-𝟴。\x{105718}\x{1D186}₆\x{99AEB}ς\x{640A2}-．\x{200C}\x{0750}ς", %p)},	undef,	"to_ascii\(\'\-𝟴。\\uDBD5\\uDF18\\uD834\\uDD86₆\\uDA26\\uDEEBς\\uD950\\uDCA2\-．\\u200C\\u0750ς\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:621\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("-𝟴。\x{105718}\x{1D186}₆\x{99AEB}Σ\x{640A2}-．\x{200C}\x{0750}Σ", %p)},	undef,	"to_ascii\(\'\-𝟴。\\uDBD5\\uDF18\\uD834\\uDD86₆\\uDA26\\uDEEBΣ\\uD950\\uDCA2\-．\\u200C\\u0750Σ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:623\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("-𝟴。\x{105718}\x{1D186}₆\x{99AEB}σ\x{640A2}-．\x{200C}\x{0750}σ", %p)},	undef,	"to_ascii\(\'\-𝟴。\\uDBD5\\uDF18\\uD834\\uDD86₆\\uDA26\\uDEEBσ\\uD950\\uDCA2\-．\\u200C\\u0750σ\'\)\ throws\ error\ P1\ V3\ V6\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:625\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E01C5}\x{0DCA}ß\x{07DB}-\x{E0246}", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDDC5\\u0DCAß\\u07DB\-\\uDB40\\uDE46\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:627\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E01C5}\x{0DCA}SS\x{07DB}-\x{E0246}", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDDC5\\u0DCASS\\u07DB\-\\uDB40\\uDE46\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:628\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E01C5}\x{0DCA}ss\x{07DB}-\x{E0246}", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDDC5\\u0DCAss\\u07DB\-\\uDB40\\uDE46\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:629\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E01C5}\x{0DCA}Ss\x{07DB}-\x{E0246}", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDDC5\\u0DCASs\\u07DB\-\\uDB40\\uDE46\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:630\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("\x{0767}\x{A825}｡ß-\x{200C}\x{2DF2}", %p)},	undef,	"to_ascii\(\'\\u0767\\uA825｡ß\-\\u200C\\u2DF2\'\)\ throws\ error\ B6\ C1\ \[data\/IdnaTest\.txt\:632\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("\x{0767}\x{A825}｡SS-\x{200C}\x{2DF2}", %p)},	undef,	"to_ascii\(\'\\u0767\\uA825｡SS\-\\u200C\\u2DF2\'\)\ throws\ error\ B6\ C1\ \[data\/IdnaTest\.txt\:634\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("\x{0767}\x{A825}｡ss-\x{200C}\x{2DF2}", %p)},	undef,	"to_ascii\(\'\\u0767\\uA825｡ss\-\\u200C\\u2DF2\'\)\ throws\ error\ B6\ C1\ \[data\/IdnaTest\.txt\:636\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("\x{0767}\x{A825}｡Ss-\x{200C}\x{2DF2}", %p)},	undef,	"to_ascii\(\'\\u0767\\uA825｡Ss\-\\u200C\\u2DF2\'\)\ throws\ error\ B6\ C1\ \[data\/IdnaTest\.txt\:638\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("-\x{0758}-\x{200D}꒸。\x{07AB}．\x{1089D}\x{E0317}\x{ABED}\x{1036}", %p)},	undef,	"to_ascii\(\'\-\\u0758\-\\u200D꒸。\\u07AB．\\uD802\\uDC9D\\uDB40\\uDF17\\uABED\\u1036\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ B3\ B6\ C2\ \[data\/IdnaTest\.txt\:640\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{200C}𝟒\x{0625}\x{200C}\x{0667}．\x{10E6C}\x{200C}\x{0F9E}", %p)},	undef,	"to_ascii\(\'\\u200C𝟒\\u0625\\u200C\\u0667．\\uD803\\uDE6C\\u200C\\u0F9E\'\)\ throws\ error\ B1\ C1\ \[data\/IdnaTest\.txt\:642\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("\x{0671}𝟎。\x{A8C4}\x{200D}\x{1D181}\x{17C9}", %p)},	undef,	"to_ascii\(\'\\u0671𝟎。\\uA8C4\\u200D\\uD834\\uDD81\\u17C9\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:644\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{062D}\x{343B8}", %p)},	undef,	"to_ascii\(\'\\u062D\\uD890\\uDFB8\'\)\ throws\ error\ P1\ V6\ B2\ B3\ \[data\/IdnaTest\.txt\:645\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{BB22C}", %p)},	undef,	"to_ascii\(\'\\uDAAC\\uDE2C\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:646\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟥\x{1EA8D}\x{0F84}\x{45630}⁰。\x{06C8}ß\x{1D169}", %p)},	undef,	"to_ascii\(\'𝟥\\uD83A\\uDE8D\\u0F84\\uD8D5\\uDE30⁰。\\u06C8ß\\uD834\\uDD69\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:648\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟥\x{1EA8D}\x{0F84}\x{45630}⁰。\x{06C8}SS\x{1D169}", %p)},	undef,	"to_ascii\(\'𝟥\\uD83A\\uDE8D\\u0F84\\uD8D5\\uDE30⁰。\\u06C8SS\\uD834\\uDD69\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:649\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟥\x{1EA8D}\x{0F84}\x{45630}⁰。\x{06C8}ss\x{1D169}", %p)},	undef,	"to_ascii\(\'𝟥\\uD83A\\uDE8D\\u0F84\\uD8D5\\uDE30⁰。\\u06C8ss\\uD834\\uDD69\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:650\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("𝟥\x{1EA8D}\x{0F84}\x{45630}⁰。\x{06C8}Ss\x{1D169}", %p)},	undef,	"to_ascii\(\'𝟥\\uD83A\\uDE8D\\u0F84\\uD8D5\\uDE30⁰。\\u06C8Ss\\uD834\\uDD69\'\)\ throws\ error\ P1\ V6\ B1\ B2\ B3\ \[data\/IdnaTest\.txt\:651\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0661}ß。\x{1A60}\x{DAA74}\x{10E7B}", %p)},	undef,	"to_ascii\(\'\\u0661ß。\\u1A60\\uDB2A\\uDE74\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:653\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0661}SS。\x{1A60}\x{DAA74}\x{10E7B}", %p)},	undef,	"to_ascii\(\'\\u0661SS。\\u1A60\\uDB2A\\uDE74\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:654\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0661}ss。\x{1A60}\x{DAA74}\x{10E7B}", %p)},	undef,	"to_ascii\(\'\\u0661ss。\\u1A60\\uDB2A\\uDE74\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:655\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0661}Ss。\x{1A60}\x{DAA74}\x{10E7B}", %p)},	undef,	"to_ascii\(\'\\u0661Ss。\\u1A60\\uDB2A\\uDE74\\uD803\\uDE7B\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:656\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("ς\x{10E73}\x{0635}⒓", %p)},	undef,	"to_ascii\(\'ς\\uD803\\uDE73\\u0635⒓\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:658\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("Σ\x{10E73}\x{0635}⒓", %p)},	undef,	"to_ascii\(\'Σ\\uD803\\uDE73\\u0635⒓\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:659\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("σ\x{10E73}\x{0635}⒓", %p)},	undef,	"to_ascii\(\'σ\\uD803\\uDE73\\u0635⒓\'\)\ throws\ error\ P1\ V6\ B5\ \[data\/IdnaTest\.txt\:660\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{19785}㊲\x{10BE82}\x{200D}。\x{E0136}\x{2062}¹", %p)},	undef,	"to_ascii\(\'\\uD825\\uDF85㊲\\uDBEF\\uDE82\\u200D。\\uDB40\\uDD36\\u2062¹\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:662\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("\x{200D}\x{A953}.\x{FB2A}.-𝟨\x{200C}-", %p)},	undef,	"to_ascii\(\'\\u200D\\uA953\.\\uFB2A\.\-𝟨\\u200C\-\'\)\ throws\ error\ V3\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:664\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.010001, this is only perl $]", 1 if $] < 5.010001; is(eval{uts46_to_ascii("\x{200D}\x{A953}.\x{05E9}\x{05C1}.-𝟨\x{200C}-", %p)},	undef,	"to_ascii\(\'\\u200D\\uA953\.\\u05E9\\u05C1\.\-𝟨\\u200C\-\'\)\ throws\ error\ V3\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:666\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{06B2}\x{200C}-．\x{0D4D}。🄇-\x{E0AD8}\x{1DC9}\x{FA629}\x{E0BC5}\x{20E7}", %p)},	undef,	"to_ascii\(\'\\u06B2\\u200C\-．\\u0D4D。🄇\-\\uDB42\\uDED8\\u1DC9\\uDBA9\\uDE29\\uDB42\\uDFC5\\u20E7\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B3\ B1\ B6\ C1\ \[data\/IdnaTest\.txt\:668\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-", %p)},	undef,	"to_ascii\(\'\-\'\)\ throws\ error\ V3\ \[data\/IdnaTest\.txt\:669\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0680}\x{0DCA}\x{1A60}\x{0616}\x{E0A69}｡\x{1039}", %p)},	undef,	"to_ascii\(\'\\u0680\\u0DCA\\u1A60\\u0616\\uDB42\\uDE69｡\\u1039\'\)\ throws\ error\ P1\ V6\ V5\ B3\ B1\ B6\ \[data\/IdnaTest\.txt\:670\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("-\x{0683}\x{1BAA}\x{062B}𝟦．\x{FE25}\x{200D}\x{10899}\x{0777}𝟣．\x{A2A06}\x{0760}", %p)},	undef,	"to_ascii\(\'\-\\u0683\\u1BAA\\u062B𝟦．\\uFE25\\u200D\\uD802\\uDC99\\u0777𝟣．\\uDA4A\\uDE06\\u0760\'\)\ throws\ error\ P1\ V3\ V5\ V6\ B1\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:672\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{3A131}", %p)},	undef,	"to_ascii\(\'\\uD8A8\\uDD31\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:673\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{0837}。\x{0680}\x{031E}\x{0601}ß⁸", %p)},	undef,	"to_ascii\(\'\\u0837。\\u0680\\u031E\\u0601ß⁸\'\)\ throws\ error\ P1\ V6\ B2\ B4\ \[data\/IdnaTest\.txt\:675\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{0837}。\x{0680}\x{031E}\x{0601}SS⁸", %p)},	undef,	"to_ascii\(\'\\u0837。\\u0680\\u031E\\u0601SS⁸\'\)\ throws\ error\ P1\ V6\ B2\ B4\ \[data\/IdnaTest\.txt\:676\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{0837}。\x{0680}\x{031E}\x{0601}ss⁸", %p)},	undef,	"to_ascii\(\'\\u0837。\\u0680\\u031E\\u0601ss⁸\'\)\ throws\ error\ P1\ V6\ B2\ B4\ \[data\/IdnaTest\.txt\:677\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{0837}。\x{0680}\x{031E}\x{0601}Ss⁸", %p)},	undef,	"to_ascii\(\'\\u0837。\\u0680\\u031E\\u0601Ss⁸\'\)\ throws\ error\ P1\ V6\ B2\ B4\ \[data\/IdnaTest\.txt\:678\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-｡\x{06A9}7", %p)},	undef,	"to_ascii\(\'\-｡\\u06A97\'\)\ throws\ error\ V3\ B1\ \[data\/IdnaTest\.txt\:679\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{200D}\x{C27F8}\x{07D7}𝟼\x{E01E8}", %p)},	undef,	"to_ascii\(\'\\u200D\\uDAC9\\uDFF8\\u07D7𝟼\\uDB40\\uDDE8\'\)\ throws\ error\ P1\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:681\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{1CED}\x{10E61}\x{0DCA}\x{10815}\x{0CC6}．𝟙\x{0DCA}。\x{A67D}\x{0AC3}\x{1EB53}", %p)},	undef,	"to_ascii\(\'\\u1CED\\uD803\\uDE61\\u0DCA\\uD802\\uDC15\\u0CC6．𝟙\\u0DCA。\\uA67D\\u0AC3\\uD83A\\uDF53\'\)\ throws\ error\ P1\ V5\ V6\ B1\ \[data\/IdnaTest\.txt\:682\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{077B}\x{0D43}-\x{200D}．\x{10825}\x{E0FAC}\x{06BC}\x{200C}\x{10E68}.𝟶\x{071B}𝟲", %p)},	undef,	"to_ascii\(\'\\u077B\\u0D43\-\\u200D．\\uD802\\uDC25\\uDB43\\uDFAC\\u06BC\\u200C\\uD803\\uDE68\.𝟶\\u071B𝟲\'\)\ throws\ error\ P1\ V6\ B3\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:684\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{A8EF}\x{0C4D}\x{200D}ς\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}", %p)},	undef,	"to_ascii\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\uA8EF\\u0C4D\\u200Dς\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:686\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{0C4D}\x{A8EF}\x{200D}ς\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}", %p)},	undef,	"to_ascii\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\u0C4D\\uA8EF\\u200Dς\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:688\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{0C4D}\x{A8EF}\x{200D}Σ\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}", %p)},	undef,	"to_ascii\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\u0C4D\\uA8EF\\u200DΣ\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:690\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{0C4D}\x{A8EF}\x{200D}σ\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}", %p)},	undef,	"to_ascii\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\u0C4D\\uA8EF\\u200Dσ\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:692\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{A8EF}\x{0C4D}\x{200D}Σ\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}", %p)},	undef,	"to_ascii\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\uA8EF\\u0C4D\\u200DΣ\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:694\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{200D}\x{10E6B}囓\x{06A8}｡\x{0F39}\x{0723}\x{A8EF}\x{0C4D}\x{200D}σ\x{0BCD}．\x{E00A1}\x{200D}\x{108B2}䷠\x{0718}", %p)},	undef,	"to_ascii\(\'\\u200D\\uD803\\uDE6B囓\\u06A8｡\\u0F39\\u0723\\uA8EF\\u0C4D\\u200Dσ\\u0BCD．\\uDB40\\uDCA1\\u200D\\uD802\\uDCB2䷠\\u0718\'\)\ throws\ error\ P1\ V5\ V6\ B1\ C2\ \[data\/IdnaTest\.txt\:696\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("𝟚ß\x{200D}\x{0332}", %p)},	undef,	"to_ascii\(\'𝟚ß\\u200D\\u0332\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:698\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟚SS\x{200D}\x{0332}", %p)},	undef,	"to_ascii\(\'𝟚SS\\u200D\\u0332\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:700\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟚ss\x{200D}\x{0332}", %p)},	undef,	"to_ascii\(\'𝟚ss\\u200D\\u0332\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:702\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("𝟚Ss\x{200D}\x{0332}", %p)},	undef,	"to_ascii\(\'𝟚Ss\\u200D\\u0332\'\)\ throws\ error\ C2\ \[data\/IdnaTest\.txt\:704\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("xn--2ss-7ic", %p)},	"xn--2ss-7ic",	"to_ascii\(\'xn\-\-2ss\-7ic\'\)\ \[data\/IdnaTest\.txt\:705\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("XN--2SS-7IC", %p)},	"xn--2ss-7ic",	"to_ascii\(\'XN\-\-2SS\-7IC\'\)\ \[data\/IdnaTest\.txt\:706\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("Xn--2Ss-7Ic", %p)},	"xn--2ss-7ic",	"to_ascii\(\'Xn\-\-2Ss\-7Ic\'\)\ \[data\/IdnaTest\.txt\:707\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2ss\x{0332}", %p)},	"xn--2ss-7ic",	"to_ascii\(\'2ss\\u0332\'\)\ \[data\/IdnaTest\.txt\:708\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2SS\x{0332}", %p)},	"xn--2ss-7ic",	"to_ascii\(\'2SS\\u0332\'\)\ \[data\/IdnaTest\.txt\:709\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("2Ss\x{0332}", %p)},	"xn--2ss-7ic",	"to_ascii\(\'2Ss\\u0332\'\)\ \[data\/IdnaTest\.txt\:710\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("-\x{200D}．\x{200D}", %p)},	undef,	"to_ascii\(\'\-\\u200D．\\u200D\'\)\ throws\ error\ V3\ C2\ \[data\/IdnaTest\.txt\:712\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{2DEC}\x{1EBCD}\x{10E66}．\x{200C}ß⒕-", %p)},	undef,	"to_ascii\(\'\\u2DEC\\uD83A\\uDFCD\\uD803\\uDE66．\\u200Cß⒕\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:714\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{2DEC}\x{1EBCD}\x{10E66}．\x{200C}SS⒕-", %p)},	undef,	"to_ascii\(\'\\u2DEC\\uD83A\\uDFCD\\uD803\\uDE66．\\u200CSS⒕\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:716\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{2DEC}\x{1EBCD}\x{10E66}．\x{200C}ss⒕-", %p)},	undef,	"to_ascii\(\'\\u2DEC\\uD83A\\uDFCD\\uD803\\uDE66．\\u200Css⒕\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:718\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{2DEC}\x{1EBCD}\x{10E66}．\x{200C}Ss⒕-", %p)},	undef,	"to_ascii\(\'\\u2DEC\\uD83A\\uDFCD\\uD803\\uDE66．\\u200CSs⒕\-\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:720\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("⒌\x{033A}--．8\x{09CD}\x{200D}𝟴\x{1BA5}.\x{10E7B}\x{077A}\x{0626}\x{0644}𝟪\x{0729}", %p)},	undef,	"to_ascii\(\'⒌\\u033A\-\-．8\\u09CD\\u200D𝟴\\u1BA5\.\\uD803\\uDE7B\\u077A\\u0626\\u0644𝟪\\u0729\'\)\ throws\ error\ P1\ V2\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:722\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{BFD9A}𝟝\x{1EEBA}。𝟑\x{10D2D}\x{200C}\x{077F}．₧\x{4B431}\x{200C}\x{0663}￨\x{06A6}\x{1EC45}", %p)},	undef,	"to_ascii\(\'\\uDABF\\uDD9A𝟝\\uD83B\\uDEBA。𝟑\\uD803\\uDD2D\\u200C\\u077F．₧\\uD8ED\\uDC31\\u200C\\u0663￨\\u06A6\\uD83B\\uDC45\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B1\ C1\ \[data\/IdnaTest\.txt\:724\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0726}\x{0757}\x{E0887}\x{E0F9A}\x{AECF4}\x{0639}", %p)},	undef,	"to_ascii\(\'\\u0726\\u0757\\uDB42\\uDC87\\uDB43\\uDF9A\\uDA7B\\uDCF4\\u0639\'\)\ throws\ error\ P1\ V6\ B2\ \[data\/IdnaTest\.txt\:725\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("\x{E010D}\x{200C}。-", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDD0D\\u200C。\-\'\)\ throws\ error\ V3\ C1\ \[data\/IdnaTest\.txt\:727\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{200D}\x{06C7}.\x{10E72}\x{2CEF}", %p)},	undef,	"to_ascii\(\'\\u200D\\u06C7\.\\uD803\\uDE72\\u2CEF\'\)\ throws\ error\ B1\ C2\ \[data\/IdnaTest\.txt\:729\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{8D5EC}\x{1A6A}\x{077F}\x{200C}ß\x{07D6}𝟔", %p)},	undef,	"to_ascii\(\'\\uD9F5\\uDDEC\\u1A6A\\u077F\\u200Cß\\u07D6𝟔\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:731\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{8D5EC}\x{1A6A}\x{077F}\x{200C}SS\x{07D6}𝟔", %p)},	undef,	"to_ascii\(\'\\uD9F5\\uDDEC\\u1A6A\\u077F\\u200CSS\\u07D6𝟔\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:733\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{8D5EC}\x{1A6A}\x{077F}\x{200C}ss\x{07D6}𝟔", %p)},	undef,	"to_ascii\(\'\\uD9F5\\uDDEC\\u1A6A\\u077F\\u200Css\\u07D6𝟔\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:735\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{8D5EC}\x{1A6A}\x{077F}\x{200C}Ss\x{07D6}𝟔", %p)},	undef,	"to_ascii\(\'\\uD9F5\\uDDEC\\u1A6A\\u077F\\u200CSs\\u07D6𝟔\'\)\ throws\ error\ P1\ V6\ B5\ C1\ \[data\/IdnaTest\.txt\:737\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("ß\x{10A0D}-\x{200D}\x{1EC71}\x{05AA}\x{200C}｡\x{10A3F}\x{E0117}\x{0768}", %p)},	undef,	"to_ascii\(\'ß\\uD802\\uDE0D\-\\u200D\\uD83B\\uDC71\\u05AA\\u200C｡\\uD802\\uDE3F\\uDB40\\uDD17\\u0768\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:739\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("SS\x{10A0D}-\x{200D}\x{1EC71}\x{05AA}\x{200C}｡\x{10A3F}\x{E0117}\x{0768}", %p)},	undef,	"to_ascii\(\'SS\\uD802\\uDE0D\-\\u200D\\uD83B\\uDC71\\u05AA\\u200C｡\\uD802\\uDE3F\\uDB40\\uDD17\\u0768\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:741\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("ss\x{10A0D}-\x{200D}\x{1EC71}\x{05AA}\x{200C}｡\x{10A3F}\x{E0117}\x{0768}", %p)},	undef,	"to_ascii\(\'ss\\uD802\\uDE0D\-\\u200D\\uD83B\\uDC71\\u05AA\\u200C｡\\uD802\\uDE3F\\uDB40\\uDD17\\u0768\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:743\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("Ss\x{10A0D}-\x{200D}\x{1EC71}\x{05AA}\x{200C}｡\x{10A3F}\x{E0117}\x{0768}", %p)},	undef,	"to_ascii\(\'Ss\\uD802\\uDE0D\-\\u200D\\uD83B\\uDC71\\u05AA\\u200C｡\\uD802\\uDE3F\\uDB40\\uDD17\\u0768\'\)\ throws\ error\ P1\ V6\ V5\ B5\ B6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:745\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{E013F}\x{067D}\x{0615}\x{A80B}\x{200C}\x{0886}。\x{37B43}𝟿\x{10E61}\x{36146}-｡\x{062D}\x{200C}\x{A8ED}\x{E04D4}\x{200C}\x{1732}", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDD3F\\u067D\\u0615\\uA80B\\u200C\\u0886。\\uD89E\\uDF43𝟿\\uD803\\uDE61\\uD898\\uDD46\-｡\\u062D\\u200C\\uA8ED\\uDB41\\uDCD4\\u200C\\u1732\'\)\ throws\ error\ P1\ V6\ V3\ B5\ B6\ B3\ C1\ \[data\/IdnaTest\.txt\:747\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{068E}ß\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{FB43}.\x{06AB}\x{FE05}-\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u068Eß\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\uFB43\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:749\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{068E}ß\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{05E3}\x{05BC}.\x{06AB}\x{FE05}-\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u068Eß\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\u05E3\\u05BC\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:751\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{068E}SS\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{05E3}\x{05BC}.\x{06AB}\x{FE05}-\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u068ESS\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\u05E3\\u05BC\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:753\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{068E}ss\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{05E3}\x{05BC}.\x{06AB}\x{FE05}-\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u068Ess\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\u05E3\\u05BC\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:755\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{068E}Ss\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{05E3}\x{05BC}.\x{06AB}\x{FE05}-\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u068ESs\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\u05E3\\u05BC\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:757\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{068E}SS\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{FB43}.\x{06AB}\x{FE05}-\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u068ESS\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\uFB43\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:759\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{068E}ss\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{FB43}.\x{06AB}\x{FE05}-\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u068Ess\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\uFB43\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:761\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{068E}Ss\x{06DC}.\x{200D}\x{E07D9}\x{068E}\x{07E7}\x{FB43}.\x{06AB}\x{FE05}-\x{200D}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u068ESs\\u06DC\.\\u200D\\uDB41\\uDFD9\\u068E\\u07E7\\uFB43\.\\u06AB\\uFE05\-\\u200D\\u200D\'\)\ throws\ error\ P1\ V6\ B2\ B3\ B1\ C2\ \[data\/IdnaTest\.txt\:763\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{12788}\x{10A0E}\x{1EE51}\x{1097A}\x{200D}", %p)},	undef,	"to_ascii\(\'\\uD809\\uDF88\\uD802\\uDE0E\\uD83B\\uDE51\\uD802\\uDD7A\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:765\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{D97CD}１\x{0FA9}\x{200D}\x{10E7E}₁｡\x{200C}\x{200D}", %p)},	undef,	"to_ascii\(\'\\uDB25\\uDFCD１\\u0FA9\\u200D\\uD803\\uDE7E₁｡\\u200C\\u200D\'\)\ throws\ error\ P1\ V6\ B5\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:767\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{07E9}\x{108C4}\x{06D1}\x{E0616}\x{068E}", %p)},	undef,	"to_ascii\(\'\\u07E9\\uD802\\uDCC4\\u06D1\\uDB41\\uDE16\\u068E\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:768\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{109F2}.---\x{06A5}\x{07D2}", %p)},	undef,	"to_ascii\(\'\\uD802\\uDDF2\.\-\-\-\\u06A5\\u07D2\'\)\ throws\ error\ P1\ V6\ V3\ B1\ \[data\/IdnaTest\.txt\:769\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0682}\x{0B4D}-\x{10E73}\x{10E64}⛛．\x{10E62}\x{AA2D}\x{0723}\x{200C}\x{0758}\x{18F9A}", %p)},	undef,	"to_ascii\(\'\\u0682\\u0B4D\-\\uD803\\uDE73\\uD803\\uDE64⛛．\\uD803\\uDE62\\uAA2D\\u0723\\u200C\\u0758\\uD823\\uDF9A\'\)\ throws\ error\ P1\ V6\ B3\ B1\ \[data\/IdnaTest\.txt\:771\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("-❵\x{200C}\x{0649}", %p)},	undef,	"to_ascii\(\'\-❵\\u200C\\u0649\'\)\ throws\ error\ V3\ B1\ C1\ \[data\/IdnaTest\.txt\:773\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("🄈\x{200C}\x{0665}-｡\x{1DD9}⬚\x{06A9}", %p)},	undef,	"to_ascii\(\'🄈\\u200C\\u0665\-｡\\u1DD9⬚\\u06A9\'\)\ throws\ error\ P1\ V3\ V6\ V5\ B1\ C1\ \[data\/IdnaTest\.txt\:775\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("ß\x{0CBF}\x{200D}\x{0603}\x{0727}", %p)},	undef,	"to_ascii\(\'ß\\u0CBF\\u200D\\u0603\\u0727\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:777\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("SS\x{0CBF}\x{200D}\x{0603}\x{0727}", %p)},	undef,	"to_ascii\(\'SS\\u0CBF\\u200D\\u0603\\u0727\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:779\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("ss\x{0CBF}\x{200D}\x{0603}\x{0727}", %p)},	undef,	"to_ascii\(\'ss\\u0CBF\\u200D\\u0603\\u0727\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:781\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.008001, this is only perl $]", 1 if $] < 5.008001; is(eval{uts46_to_ascii("Ss\x{0CBF}\x{200D}\x{0603}\x{0727}", %p)},	undef,	"to_ascii\(\'Ss\\u0CBF\\u200D\\u0603\\u0727\'\)\ throws\ error\ P1\ V6\ B5\ B6\ C2\ \[data\/IdnaTest\.txt\:783\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("-\x{AAB7}\x{E0DE2}\x{10DEC}\x{A806}", %p)},	undef,	"to_ascii\(\'\-\\uAAB7\\uDB43\\uDDE2\\uD803\\uDDEC\\uA806\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:784\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0C4D}ς\x{0DCA}\x{06B0}", %p)},	undef,	"to_ascii\(\'\\u0C4Dς\\u0DCA\\u06B0\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:786\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C4D}Σ\x{0DCA}\x{06B0}", %p)},	undef,	"to_ascii\(\'\\u0C4DΣ\\u0DCA\\u06B0\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:787\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{0C4D}σ\x{0DCA}\x{06B0}", %p)},	undef,	"to_ascii\(\'\\u0C4Dσ\\u0DCA\\u06B0\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:788\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("3\x{1EA3B}\x{0623}\x{0DD6}\x{10E7B}-。\x{10E78}\x{10E7C}\x{094D}۶-\x{10990}", %p)},	undef,	"to_ascii\(\'3\\uD83A\\uDE3B\\u0623\\u0DD6\\uD803\\uDE7B\-。\\uD803\\uDE78\\uD803\\uDE7C\\u094D۶\-\\uD802\\uDD90\'\)\ throws\ error\ P1\ V3\ V6\ B1\ \[data\/IdnaTest\.txt\:789\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{0770}\x{10E78}\x{200C}\x{200C}\x{200C}", %p)},	undef,	"to_ascii\(\'\\u0770\\uD803\\uDE78\\u200C\\u200C\\u200C\'\)\ throws\ error\ B3\ C1\ \[data\/IdnaTest\.txt\:791\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("xn--0pb6875k", %p)},	"xn--0pb6875k",	"to_ascii\(\'xn\-\-0pb6875k\'\)\ \[data\/IdnaTest\.txt\:792\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("XN--0PB6875K", %p)},	"xn--0pb6875k",	"to_ascii\(\'XN\-\-0PB6875K\'\)\ \[data\/IdnaTest\.txt\:793\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("Xn--0Pb6875k", %p)},	"xn--0pb6875k",	"to_ascii\(\'Xn\-\-0Pb6875k\'\)\ \[data\/IdnaTest\.txt\:794\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{0770}\x{10E78}", %p)},	"xn--0pb6875k",	"to_ascii\(\'\\u0770\\uD803\\uDE78\'\)\ \[data\/IdnaTest\.txt\:795\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0717}\x{10A0C}.\x{10E7D}\x{067C}\x{0311}\x{A9B8}．\x{E0ADD}\x{06C5}\x{10ED7}", %p)},	undef,	"to_ascii\(\'\\u0717\\uD802\\uDE0C\.\\uD803\\uDE7D\\u067C\\u0311\\uA9B8．\\uDB42\\uDEDD\\u06C5\\uD803\\uDED7\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:796\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{10E78}。\x{10EA9}\x{094D}", %p)},	undef,	"to_ascii\(\'\\uD803\\uDE78。\\uD803\\uDEA9\\u094D\'\)\ throws\ error\ P1\ V6\ B1\ \[data\/IdnaTest\.txt\:797\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{10D6F5}\x{A806}\x{53887}ς\x{200D}\x{E01A7}", %p)},	undef,	"to_ascii\(\'\\uDBF5\\uDEF5\\uA806\\uD90E\\uDC87ς\\u200D\\uDB40\\uDDA7\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:799\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{10D6F5}\x{A806}\x{53887}Σ\x{200D}\x{E01A7}", %p)},	undef,	"to_ascii\(\'\\uDBF5\\uDEF5\\uA806\\uD90E\\uDC87Σ\\u200D\\uDB40\\uDDA7\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:801\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{10D6F5}\x{A806}\x{53887}σ\x{200D}\x{E01A7}", %p)},	undef,	"to_ascii\(\'\\uDBF5\\uDEF5\\uA806\\uD90E\\uDC87σ\\u200D\\uDB40\\uDDA7\'\)\ throws\ error\ P1\ V6\ C2\ \[data\/IdnaTest\.txt\:803\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("ß\x{0687}\x{07DE}\x{06A2}.\x{109F1}\x{06AC}-\x{200C}ß\x{CEBAE}𝟺", %p)},	undef,	"to_ascii\(\'ß\\u0687\\u07DE\\u06A2\.\\uD802\\uDDF1\\u06AC\-\\u200Cß\\uDAFA\\uDFAE𝟺\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ C1\ \[data\/IdnaTest\.txt\:805\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("SS\x{0687}\x{07DE}\x{06A2}.\x{109F1}\x{06AC}-\x{200C}SS\x{CEBAE}𝟺", %p)},	undef,	"to_ascii\(\'SS\\u0687\\u07DE\\u06A2\.\\uD802\\uDDF1\\u06AC\-\\u200CSS\\uDAFA\\uDFAE𝟺\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ C1\ \[data\/IdnaTest\.txt\:807\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("ss\x{0687}\x{07DE}\x{06A2}.\x{109F1}\x{06AC}-\x{200C}ss\x{CEBAE}𝟺", %p)},	undef,	"to_ascii\(\'ss\\u0687\\u07DE\\u06A2\.\\uD802\\uDDF1\\u06AC\-\\u200Css\\uDAFA\\uDFAE𝟺\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ C1\ \[data\/IdnaTest\.txt\:809\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("Ss\x{0687}\x{07DE}\x{06A2}.\x{109F1}\x{06AC}-\x{200C}Ss\x{CEBAE}𝟺", %p)},	undef,	"to_ascii\(\'Ss\\u0687\\u07DE\\u06A2\.\\uD802\\uDDF1\\u06AC\-\\u200CSs\\uDAFA\\uDFAE𝟺\'\)\ throws\ error\ P1\ V6\ B5\ B6\ B2\ C1\ \[data\/IdnaTest\.txt\:811\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{10E7A}\x{0F84}\x{3B8CA}\x{200D}∤\x{200C}-", %p)},	undef,	"to_ascii\(\'\\uD803\\uDE7A\\u0F84\\uD8AE\\uDCCA\\u200D∤\\u200C\-\'\)\ throws\ error\ P1\ V3\ V6\ B1\ C2\ C1\ \[data\/IdnaTest\.txt\:813\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("ß\x{E005B}\x{1EAC7}\x{063A}", %p)},	undef,	"to_ascii\(\'ß\\uDB40\\uDC5B\\uD83A\\uDEC7\\u063A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:815\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("SS\x{E005B}\x{1EAC7}\x{063A}", %p)},	undef,	"to_ascii\(\'SS\\uDB40\\uDC5B\\uD83A\\uDEC7\\u063A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:816\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("ss\x{E005B}\x{1EAC7}\x{063A}", %p)},	undef,	"to_ascii\(\'ss\\uDB40\\uDC5B\\uD83A\\uDEC7\\u063A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:817\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("Ss\x{E005B}\x{1EAC7}\x{063A}", %p)},	undef,	"to_ascii\(\'Ss\\uDB40\\uDC5B\\uD83A\\uDEC7\\u063A\'\)\ throws\ error\ P1\ V6\ B5\ B6\ \[data\/IdnaTest\.txt\:818\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{E0064}\x{1039}\x{0B4D}-", %p)},	undef,	"to_ascii\(\'\\uDB40\\uDC64\\u1039\\u0B4D\-\'\)\ throws\ error\ P1\ V3\ V6\ \[data\/IdnaTest\.txt\:819\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{0954}\x{10E68}☞", %p)},	undef,	"to_ascii\(\'\\u0954\\uD803\\uDE68☞\'\)\ throws\ error\ V5\ B1\ \[data\/IdnaTest\.txt\:820\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{17B5}ς", %p)},	undef,	"to_ascii\(\'\\u17B5ς\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:822\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17B5}Σ", %p)},	undef,	"to_ascii\(\'\\u17B5Σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:823\]") or ($@ and diag($@));
is(eval{uts46_to_ascii("\x{17B5}σ", %p)},	undef,	"to_ascii\(\'\\u17B5σ\'\)\ throws\ error\ P1\ V6\ \[data\/IdnaTest\.txt\:824\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{10CC8}\x{07BE}.ς\x{200D}\x{032F}.\x{0E48}\x{7D7CB}ς-", %p)},	undef,	"to_ascii\(\'\\uD803\\uDCC8\\u07BE\.ς\\u200D\\u032F\.\\u0E48\\uD9B5\\uDFCBς\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:826\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{10CC8}\x{07BE}.Σ\x{200D}\x{032F}.\x{0E48}\x{7D7CB}Σ-", %p)},	undef,	"to_ascii\(\'\\uD803\\uDCC8\\u07BE\.Σ\\u200D\\u032F\.\\u0E48\\uD9B5\\uDFCBΣ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:828\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{10CC8}\x{07BE}.σ\x{200D}\x{032F}.\x{0E48}\x{7D7CB}σ-", %p)},	undef,	"to_ascii\(\'\\uD803\\uDCC8\\u07BE\.σ\\u200D\\u032F\.\\u0E48\\uD9B5\\uDFCBσ\-\'\)\ throws\ error\ P1\ V6\ V3\ V5\ B6\ B1\ C2\ \[data\/IdnaTest\.txt\:830\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{1E946}\x{0315}ß\x{200C}⓽-\x{1EF9E}", %p)},	undef,	"to_ascii\(\'\\uD83A\\uDD46\\u0315ß\\u200C⓽\-\\uD83B\\uDF9E\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:832\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{1E946}\x{0315}SS\x{200C}⓽-\x{1EF9E}", %p)},	undef,	"to_ascii\(\'\\uD83A\\uDD46\\u0315SS\\u200C⓽\-\\uD83B\\uDF9E\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:834\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{1E946}\x{0315}ss\x{200C}⓽-\x{1EF9E}", %p)},	undef,	"to_ascii\(\'\\uD83A\\uDD46\\u0315ss\\u200C⓽\-\\uD83B\\uDF9E\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:836\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{1E946}\x{0315}Ss\x{200C}⓽-\x{1EF9E}", %p)},	undef,	"to_ascii\(\'\\uD83A\\uDD46\\u0315Ss\\u200C⓽\-\\uD83B\\uDF9E\'\)\ throws\ error\ P1\ V6\ B2\ C1\ \[data\/IdnaTest\.txt\:838\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0666}", %p)},	undef,	"to_ascii\(\'\\u0666\'\)\ throws\ error\ B1\ \[data\/IdnaTest\.txt\:839\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{06A3}ς\x{07E4}。۹\x{10E73}\x{110B9}１\x{200D}", %p)},	undef,	"to_ascii\(\'\\u06A3ς\\u07E4。۹\\uD803\\uDE73\\uD804\\uDCB9１\\u200D\'\)\ throws\ error\ B2\ B1\ C2\ \[data\/IdnaTest\.txt\:841\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{06A3}Σ\x{07E4}。۹\x{10E73}\x{110B9}１\x{200D}", %p)},	undef,	"to_ascii\(\'\\u06A3Σ\\u07E4。۹\\uD803\\uDE73\\uD804\\uDCB9１\\u200D\'\)\ throws\ error\ B2\ B1\ C2\ \[data\/IdnaTest\.txt\:843\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.012, this is only perl $]", 1 if $] < 5.012; is(eval{uts46_to_ascii("\x{06A3}σ\x{07E4}。۹\x{10E73}\x{110B9}１\x{200D}", %p)},	undef,	"to_ascii\(\'\\u06A3σ\\u07E4。۹\\uD803\\uDE73\\uD804\\uDCB9１\\u200D\'\)\ throws\ error\ B2\ B1\ C2\ \[data\/IdnaTest\.txt\:845\]") or ($@ and diag($@)); }
is(eval{uts46_to_ascii("\x{0342}.\x{0663}", %p)},	undef,	"to_ascii\(\'\\u0342\.\\u0663\'\)\ throws\ error\ V5\ B1\ B3\ B6\ \[data\/IdnaTest\.txt\:846\]") or ($@ and diag($@));
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{0D4D}\x{200C}\x{200D}\x{3A373}.\x{E0144}\x{0764}\x{10E66}\x{3B44A}\x{1EBAE}𥐿.-🄇\x{10E62}\x{200D}", %p)},	undef,	"to_ascii\(\'\\u0D4D\\u200C\\u200D\\uD8A8\\uDF73\.\\uDB40\\uDD44\\u0764\\uD803\\uDE66\\uD8AD\\uDC4A\\uD83A\\uDFAE𥐿\.\-🄇\\uD803\\uDE62\\u200D\'\)\ throws\ error\ P1\ V5\ V6\ V3\ B1\ B2\ B3\ C2\ \[data\/IdnaTest\.txt\:848\]") or ($@ and diag($@)); }
SKIP: { skip "requires perl 5.014, this is only perl $]", 1 if $] < 5.014; is(eval{uts46_to_ascii("\x{200C}\x{10E7A}｡\x{0660}²\x{1D174}\x{C425E}\x{10E79}。\x{200D}\x{0661}９", %p)},	undef,	"to_ascii\(\'\\u200C\\uD803\\uDE7A｡\\u0660²\\uD834\\uDD74\\uDAD0\\uDE5E\\uD803\\uDE79。\\u200D\\u0661９\'\)\ throws\ error\ P1\ V6\ B1\ C1\ C2\ \[data\/IdnaTest\.txt\:850\]") or ($@ and diag($@)); }


exit(0);
