# $Id: Makefile.PL 88 2009-12-11 00:09:48Z cfaerber $

use 5.006;

use utf8;
use ExtUtils::MakeMaker;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
	'NAME'		=> 'Authen::SASL::SASLprep',
	'ABSTRACT'	=> 'SASLprep profile (RFC 4013)',
	'VERSION_FROM'	=> 'lib/Authen/SASL/SASLprep.pm', # finds $VERSION
	'PREREQ_PM'	=> {
		'Unicode::Stringprep'	=> 1.00,
	    },
	'AUTHOR'	=> 'Claus Faerber <CFAERBER@cpan.org>',
	'LICENSE'	=> 'perl',

$ExtUtils::MakeMaker::VERSION < 6.18 ? () : (
	'SIGN'		=> 1,
    ),

$ExtUtils::MakeMaker::VERSION < 6.45 ? () : (
	'META_MERGE'	=> { 
		'requires'	=> {
			'perl'	=> 5.006,
		    },

		'recommends'	=> {
			'perl'	=> 5.008003,
		    },

		'build_requires' => {
			'Test::More' => 0, 
			'Test::NoWarnings' => 0,
		    },
	    },
    ),
);

sub MY::postamble {
return <<EOF
release: release-cpan

release-cpan:
	cpan-upload \$(DISTVNAME).tar\$(SUFFIX)
EOF
}
