; $Id: binary_primitives.t 24569 2008-01-05 21:21:55Z bernhard $

(load "tests-driver.scm")
(load "compiler.scm")

(add-tests-with-string-output "binary primitives"      
  [(fx+ 1 13)                                   => "14\n" ]
  [(fx+ 1 (fx+ 7 6))                            => "14\n" ]
  [(fx+ 1 (fx+ 7 (fxadd1 5)))                   => "14\n" ]
  [(fx+ 1 (fx+ (fxsub1 8) (fxadd1 5)))          => "14\n" ]
  [(fx+ 1 (fx+ (fx+ 4 3) 6))                    => "14\n" ]
  [(fx+ 1 (fx+ (fx+ 4 3) (fx+ 3 3)))            => "14\n" ]
  [(fx+ (fx+ -10 11) (fx+ (fx+ 4 3) (fx+ 3 3))) => "14\n" ]

  [(fx- 1 13)                                   => "-12\n" ]
  [(fx- 1 (fx- 7 6))                            => "0\n" ]
  [(fx- 1 (fx- 7 (fxadd1 5)))                   => "0\n" ]
  [(fx- 1 (fx- (fxsub1 8) (fxadd1 5)))          => "0\n" ]
  [(fx- 1 (fx- (fx- 4 3) 6))                    => "6\n" ]
  [(fx- 1 (fx- (fx- 4 3) (fx- 3 3)))            => "0\n" ]
  [(fx- (fx- -10 11) (fx- (fx- 4 3) (fx- 3 3))) => "-22\n" ]

  [(fx- 1 (fx+ 7 6))                            => "-12\n" ]
  [(fx- 1 (fx+ 7 (fxadd1 5)))                   => "-12\n" ]
  [(fx+ 1 (fx- (fxsub1 8) (fxadd1 5)))          => "2\n" ]
  [(fx- 1 (fx+ (fx- 4 3) 6))                    => "-6\n" ]
  [(fx+ 1 (fx- (fx- 4 3) (fx+ 3 3)))            => "-4\n" ]
  [(fx- (fx+ -10 11) (fx+ (fx+ 4 3) (fx- 3 3))) => "-6\n" ]

  [(fxlogand 0 0)                               => "0\n" ]
  [(fxlogand 0 1)                               => "0\n" ]
  [(fxlogand 1 0)                               => "0\n" ]
  [(fxlogand 1 1)                               => "1\n" ]
  [(fxlogand (fx+ 2 1) 0)                       => "0\n" ]
  [(fxlogand (fx+ 2 1) 1)                       => "1\n" ]
  [(fxlogand (fx+ 2 1) 2)                       => "2\n" ]
  [(fxlogand (fx+ 2 1) 4)                       => "0\n" ]
  [(fxlogand (fx+ 4 1) 0)                       => "0\n" ]
  [(fxlogand (fx+ 4 1) 1)                       => "1\n" ]
  [(fxlogand (fx+ 4 1) 2)                       => "0\n" ]
  [(fxlogand (fx+ 4 1) 4)                       => "4\n" ]

  [(fxlogor 0 0)                                => "0\n" ]
  [(fxlogor 0 1)                                => "1\n" ]
  [(fxlogor 1 0)                                => "1\n" ]
  [(fxlogor 1 1)                                => "1\n" ]
  [(fxlogor (fx+ 2 1) 0)                        => "3\n" ]
  [(fxlogor (fx+ 2 1) 1)                        => "3\n" ]
  [(fxlogor (fx+ 2 1) 2)                        => "3\n" ]
  [(fxlogor (fx+ 2 1) 4)                        => "7\n" ]
  [(fxlogor (fx+ 4 1) 0)                        => "5\n" ]
  [(fxlogor (fx+ 4 1) 1)                        => "5\n" ]
  [(fxlogor (fx+ 4 1) 2)                        => "7\n" ]
  [(fxlogor (fx+ 4 1) 4)                        => "5\n" ]

  [(fx< 0 0 )                                   => "#f\n" ]
  [(fx< -0 0 )                                  => "#f\n" ]
  [(fx< 0 -0 )                                  => "#f\n" ]
  [(fx< 1 1 )                                   => "#f\n" ]
  [(fx< -1 1 )                                  => "#t\n" ]
  [(fx< 1 -1 )                                  => "#f\n" ]
  [(fx< 123456789 123456789 )                   => "#f\n" ]
  [(fx< -123456789 123456789 )                  => "#t\n" ]
  [(fx< 123456789 -123456789 )                  => "#f\n" ]
  [(fx< 123456789 (fxadd1 123456789))           => "#t\n" ]
  [(fx< -123456789 (fxadd1 -123456790))         => "#f\n" ]
  [(fx< -123456789 (fx+ -123456791 2))          => "#f\n" ]

  [(fx<= 0 0 )                                   => "#t\n" ]
  [(fx<= -0 0 )                                  => "#t\n" ]
  [(fx<= 0 -0 )                                  => "#t\n" ]
  [(fx<= 1 1 )                                   => "#t\n" ]
  [(fx<= -1 1 )                                  => "#t\n" ]
  [(fx<= 1 -1 )                                  => "#f\n" ]
  [(fx<= 123456789 123456789 )                   => "#t\n" ]
  [(fx<= -123456789 123456789 )                  => "#t\n" ]
  [(fx<= 123456789 -123456789 )                  => "#f\n" ]
  [(fx<= 123456789 (fxadd1 123456789))           => "#t\n" ]
  [(fx<= -123456789 (fxadd1 -123456790))         => "#t\n" ]
  [(fx<= -123456789 (fx+ -123456791 2))          => "#t\n" ]

  [(fx= 0 0 )                                   => "#t\n" ]
  [(fx= -0 0 )                                  => "#t\n" ]
  [(fx= 0 -0 )                                  => "#t\n" ]
  [(fx= 1 1 )                                   => "#t\n" ]
  [(fx= -1 1 )                                  => "#f\n" ]
  [(fx= 1 -1 )                                  => "#f\n" ]
  [(fx= 123456789 123456789 )                   => "#t\n" ]
  [(fx= -123456789 123456789 )                  => "#f\n" ]
  [(fx= 123456789 -123456789 )                  => "#f\n" ]
  [(fx= 123456789 (fxadd1 123456789))           => "#f\n" ]
  [(fx= -123456789 (fxadd1 -123456790))         => "#t\n" ]
  [(fx= -123456789 (fx+ -123456791 2))          => "#t\n" ]

  [(fx>= 0 0 )                                  => "#t\n" ]
  [(fx>= -0 0 )                                 => "#t\n" ]
  [(fx>= 0 -0 )                                 => "#t\n" ]
  [(fx>= 1 1 )                                  => "#t\n" ]
  [(fx>= -1 1 )                                 => "#f\n" ]
  [(fx>= 1 -1 )                                 => "#t\n" ]
  [(fx>= 123456789 123456789 )                  => "#t\n" ]
  [(fx>= -123456789 123456789 )                 => "#f\n" ]
  [(fx>= 123456789 -123456789 )                 => "#t\n" ]
  [(fx>= 123456789 (fxadd1 123456789))          => "#f\n" ]
  [(fx>= -123456789 (fxadd1 -123456790))        => "#t\n" ]
  [(fx>= -123456789 (fx+ -123456791 2))         => "#t\n" ]

  [(fx> 0 0 )                                    => "#f\n" ]
  [(fx> -0 0 )                                   => "#f\n" ]
  [(fx> 0 -0 )                                   => "#f\n" ]
  [(fx> 1 1 )                                    => "#f\n" ]
  [(fx> -1 1 )                                   => "#f\n" ]
  [(fx> 1 -1 )                                   => "#t\n" ]
  [(fx> 123456789 123456789 )                    => "#f\n" ]
  [(fx> -123456789 123456789 )                   => "#f\n" ]
  [(fx> 123456789 -123456789 )                   => "#t\n" ]
  [(fx> 123456789 (fxadd1 123456789))            => "#f\n" ]
  [(fx> -123456789 (fxadd1 -123456790))          => "#f\n" ]
  [(fx> -123456789 (fx+ -123456791 2))           => "#f\n" ]

  [(char< #\A #\A)                               => "#f\n" ]
  [(char< #\A #\B)                               => "#t\n" ]
  [(char< #\A #\a)                               => "#t\n" ]
  [(char< #\A #\b)                               => "#t\n" ]
  [(char< #\B #\A)                               => "#f\n" ]
  [(char< #\B #\B)                               => "#f\n" ]
  [(char< #\B #\a)                               => "#t\n" ]
  [(char< #\B #\b)                               => "#t\n" ]
  [(char< #\a #\A)                               => "#f\n" ]
  [(char< #\a #\B)                               => "#f\n" ]
  [(char< #\a #\a)                               => "#f\n" ]
  [(char< #\a #\b)                               => "#t\n" ]
  [(char< #\b #\A)                               => "#f\n" ]
  [(char< #\b #\B)                               => "#f\n" ]
  [(char< #\b #\a)                               => "#f\n" ]
  [(char< #\b #\b)                               => "#f\n" ]

  [(char<= #\A #\A)                               => "#t\n" ]
  [(char<= #\A #\B)                               => "#t\n" ]
  [(char<= #\A #\a)                               => "#t\n" ]
  [(char<= #\A #\b)                               => "#t\n" ]
  [(char<= #\B #\A)                               => "#f\n" ]
  [(char<= #\B #\B)                               => "#t\n" ]
  [(char<= #\B #\a)                               => "#t\n" ]
  [(char<= #\B #\b)                               => "#t\n" ]
  [(char<= #\a #\A)                               => "#f\n" ]
  [(char<= #\a #\B)                               => "#f\n" ]
  [(char<= #\a #\a)                               => "#t\n" ]
  [(char<= #\a #\b)                               => "#t\n" ]
  [(char<= #\b #\A)                               => "#f\n" ]
  [(char<= #\b #\B)                               => "#f\n" ]
  [(char<= #\b #\a)                               => "#f\n" ]
  [(char<= #\b #\b)                               => "#t\n" ]

  [(char= #\A #\A)                               => "#t\n" ]
  [(char= #\A #\B)                               => "#f\n" ]
  [(char= #\A #\a)                               => "#f\n" ]
  [(char= #\A #\b)                               => "#f\n" ]
  [(char= #\B #\A)                               => "#f\n" ]
  [(char= #\B #\B)                               => "#t\n" ]
  [(char= #\B #\a)                               => "#f\n" ]
  [(char= #\B #\b)                               => "#f\n" ]
  [(char= #\a #\A)                               => "#f\n" ]
  [(char= #\a #\B)                               => "#f\n" ]
  [(char= #\a #\a)                               => "#t\n" ]
  [(char= #\a #\b)                               => "#f\n" ]
  [(char= #\b #\A)                               => "#f\n" ]
  [(char= #\b #\B)                               => "#f\n" ]
  [(char= #\b #\a)                               => "#f\n" ]
  [(char= #\b #\b)                               => "#t\n" ]

  [(char>= #\A #\A)                               => "#t\n" ]
  [(char>= #\A #\B)                               => "#f\n" ]
  [(char>= #\A #\a)                               => "#f\n" ]
  [(char>= #\A #\b)                               => "#f\n" ]
  [(char>= #\B #\A)                               => "#t\n" ]
  [(char>= #\B #\B)                               => "#t\n" ]
  [(char>= #\B #\a)                               => "#f\n" ]
  [(char>= #\B #\b)                               => "#f\n" ]
  [(char>= #\a #\A)                               => "#t\n" ]
  [(char>= #\a #\B)                               => "#t\n" ]
  [(char>= #\a #\a)                               => "#t\n" ]
  [(char>= #\a #\b)                               => "#f\n" ]
  [(char>= #\b #\A)                               => "#t\n" ]
  [(char>= #\b #\B)                               => "#t\n" ]
  [(char>= #\b #\a)                               => "#t\n" ]
  [(char>= #\b #\b)                               => "#t\n" ]

  [(char> #\A #\A)                               => "#f\n" ]
  [(char> #\A #\B)                               => "#f\n" ]
  [(char> #\A #\a)                               => "#f\n" ]
  [(char> #\A #\b)                               => "#f\n" ]
  [(char> #\B #\A)                               => "#t\n" ]
  [(char> #\B #\B)                               => "#f\n" ]
  [(char> #\B #\a)                               => "#f\n" ]
  [(char> #\B #\b)                               => "#f\n" ]
  [(char> #\a #\A)                               => "#t\n" ]
  [(char> #\a #\B)                               => "#t\n" ]
  [(char> #\a #\a)                               => "#f\n" ]
  [(char> #\a #\b)                               => "#f\n" ]
  [(char> #\b #\A)                               => "#t\n" ]
  [(char> #\b #\B)                               => "#t\n" ]
  [(char> #\b #\a)                               => "#t\n" ]
  [(char> #\b #\b)                               => "#f\n" ]
)

(test-all)
