#!C://DevTools//Perl//bin//perl.exe

use strict;
use warnings;
use Getopt::Long;
use Audio::Beep;
use FindBin;
use lib "$FindBin::Bin/../lib";
require Amibroker::AFL::Backtester;

=head1 NAME

Ami-optimizer.pl - Auto Optimizer Script that uses Amibroker::AFL::Optimizer framework to run optimization.

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';

=head1 SYNOPSIS

    Ami-optimizer.pl -destination C:/finalreports/today
                     -source C:/finalreports/today
                     -dbpath C:/amibroker/dbpath
                     -timframe 20-minute
                     -symbol IBM
=cut

my $periodFile = "$FindBin::Bin/rules/PeriodList.txt";
my $MarginFile = "$FindBin::Bin/rules/ScriptDetails.txt";

my $periodFile  = "$FindBin::Bin/Rules/Periodicity.txt";
my $DatesFile   = "$FindBin::Bin/Rules/Dates.txt";
my $MarginFile  = "$FindBin::Bin/Rules/MarginDetails.txt";

my ( $PARAMS, $PERIOD_LIST, $DATES_LIST, $MARGINS_LIST );
#
# Main programs starts here
#
sub main() {

    GetOptions(
        "source=s"      => \( my $DEFAULT_SOURCE       = $SandBox ),
        "destination=s" => \( my $DEFAULT_DESTINATION  = $SandBox ),
        "database=s"    => \( my $DEFAULT_DATABASE     = $SandBox ),
        "timeframe=s"   => \( my $TIMEFRAME            = '' ),
        "outofsample=s" => \( my $OUT_OF_SAMPLE_MONTHS = '6-Months' ),
        "help"          => \&help
    ) or die "Error in command line arguments";
    print "\nArguments passed\n---------------------------\n";
    print "SOURCE        = $DEFAULT_SOURCE\n";
    print "DESTINATION   = $DEFAULT_DESTINATION\n";
    print "DATABASE      = $DEFAULT_DATABASE\n";
    print "TIMEFRAME     = $TIMEFRAME\n";
    print "OUTSAMPLE MNT = $OUT_OF_SAMPLE_MONTHS\n";
    print "---------------------------\n";
    Utils::clean_old_logs($LogPath);
    $PERIOD_LIST  = Utils::read_configuration_file($periodFile);
    $DATES_LIST   = Utils::read_configuration_file($DatesFile);
    $MARGINS_LIST = Utils::read_configuration_file($MarginFile);

    my $period = Utils::get_backtest_periodicity( $TIMEFRAME, $PERIOD_LIST );
    print "Amibroker Periodicity = $period\n";
    if ( $period == 111 ) {
        print
"WARN: No such period exists for \"$TIMEFRAME\" and unknown time format\n";
        print "WARN: Seems like no options are passed to this program\n\n";
        help();
        return;
    }
    my $dirList = Utils::list_directories_in_dir($DEFAULT_SOURCE);
    if ( scalar @$dirList ) {
        foreach my $newSrcDirPath (@$dirList) {
            my $newDestDirPath =
                $DEFAULT_SOURCE eq $DEFAULT_DESTINATION
              ? $newSrcDirPath
              : $DEFAULT_DESTINATION;
            my $Obj = BT->new(
                $TIMEFRAME,     $PERIOD_LIST,    $timestamp,
                $LogPath,       $SandBox,        $apxTemplate,
                $newSrcDirPath, $newDestDirPath, $DEFAULT_DATABASE,
                $period,        $DATES_LIST,     $MARGINS_LIST,
                $OUT_OF_SAMPLE_MONTHS
            );
            $Obj->start_recursive_backtest();
        }
    }
    else {
        print "FYI -- Only one folder present\n";
        my $Obj = BT->new(
            $TIMEFRAME,        $PERIOD_LIST,
            $timestamp,        $LogPath,
            $SandBox,          $apxTemplate,
            $DEFAULT_SOURCE,   $DEFAULT_DESTINATION,
            $DEFAULT_DATABASE, $period,
            $DATES_LIST,       $MARGINS_LIST,
            $OUT_OF_SAMPLE_MONTHS
        );
        $Obj->start_recursive_backtest();
    }
    print "\n\n****************************************\n";
    print "\n      ---       COMPLETED       ---     \n";
    print "\n****************************************\n";
    my $beeper = Audio::Beep->new();
    my $music  = "g' f bes' c8 f d4 c8 f d4 bes c g f2";
    $beeper->play($music);
    return 1;
}
#
# Helper function
#
main();
1;
