use ExtUtils::MakeMaker;

WriteMakefile (
    NAME => 'Geo::Postcodes::JP',
    VERSION => '0.005',
    ABSTRACT => 'handle the Japan Post Office postal code data',
    AUTHOR => 'Ben Bullock <bkb@cpan.org>',
    LICENSE => 'perl',
    PREREQ_PM => {
        # The ":all" is not defined in old versions so need recent
        # one.
        'Lingua::JA::Moji' => '0.11',
        'DBI' => 0,
        'DBD::SQLite' => 0,
        'LWP::UserAgent' => 0,
    },
    META_MERGE => {
        resources => {
            repository => 'https://github.com/benkasminbullock/Geo-Postcodes-JP',
            homepage => 'http://prepan.org/module/3Yz7PYrBQM',
            bugtracker => 'https://github.com/benkasminbullock/Geo-Postcodes-JP/issues',
        },
        no_index => {
            directory => [
                'tmpl' 
            ],
        }
    },
);

# Local variables:
# mode: perl
# End:

