package App::ppll::Worker;     ## no critic [NamingConventions::Capitalization]

=encoding utf8

=head1 NAME

App::ppll::Worker

=head1 VERSION

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut

use autodie;
use strict;
use utf8::all;
use v5.20;
use warnings;

use IPC::Run qw( harness new_chunker );

use experimental qw( signatures );
use overload '""' => 'str';

=head1 SUBROUTINES/METHODS

=head2 new

Constructor.

Named parameters:

=over

=item argv

=item prefix

=back

=cut

sub new ( $class, %self ) {
  $self{harness} = harness( $self{argv}, '>', new_chunker, $self{out},
    '2>', new_chunker, $self{err}, );

  return bless \%self, $class;
}

=head2 result

=cut

sub result( $self ) {
  if ( $self->{harness}->pumpable ) {
    $self->{harness}->pump_nb;
    return;
  }

  $self->{harness}->finish;
  $self->{finished} = 1;
  my $result = $self->{harness}->result;

  return $result;
}

=head2 start

=cut

sub start( $self ) {
  $self->{harness}->start;
  return;
}

=head2 stop

=cut

sub stop( $self ) {
  $self->{harness}->kill_kill;
  $self->{harness}->finish;
  $self->{finished} = 1;
  return;
}

=head2 str

=cut

sub str ( $self, @ ) {
  return $self->{parameter};
}

=head1 DIAGNOSTICS

=head1 CONFIGURATION AND ENVIRONMENT

=head1 DEPENDENCIES

=head1 INCOMPATIBILITIES

=head1 BUGS AND LIMITATIONS

=head1 AUTHOR

=head1 LICENSE AND COPYRIGHT

=cut

1;
