% RT-Extension-StallFutureTicket - Stall a new ticket automatically when start time is set to a future date


This RT Extension allows to automatically stall created tickets with a start time in the future.


# Installation

Before you can install this RT Extension you must install the perl module `Date::Manip` first. The easiest way is to use CPAN:

~~~~~~~ {.bash}
cpan -i Date::Manip
~~~~~~~

To install this extension, run the following commands:

~~~~~~~ {.bash}
perl Makefile.PL
make
make test
make install
~~~~~~~


# Configuration

To make this extension active register it to in RT site configuration file located in `RT_HOME/etc/RT_SiteConfig.pm` where `RT_HOME` is the path to your RT installation.

~~~~~~~ {.perl}
Set(@Plugins,qw(RT::Extension::StallFutureTicket));
~~~~~~~

You must allow to set new tickets to 'stalled':

~~~~~~~ {.perl}
Set(%Lifecycles,
    default => {

        [...]

        transitions => {
            ''       => [qw(new open resolved stalled)],
            [...]
        }
        [...]
    }
);
~~~~~~~

This is just an abbreviation taken from RT's main configuration file under `RT_HOME`/etc/RT_Config.pm`. Note the added 'stalled'.

To overwrite `Date::Manip`'s default configuration you may set the following:

~~~~~~~ {.perl}
Set(%DateManipConfig, (
    'WorkDayBeg', '9:00',
    'WorkDayEnd', '17:00', 
    #'WorkDay24Hr', '0',
    #'WorkWeekBeg', '1',
    #'WorkWeekEnd', '7'
));
~~~~~~~

You can find more information about the configurable parameters under <http://search.cpan.org/~sbeck/Date-Manip-6.25/lib/Date/Manip/Config.pod#BUSINESS_CONFIGURATION_VARIABLES>.

After all your new configuration will take effect after restarting your RT environment:

~~~~~~~ {.bash}
rm -rf RT_HOME/var/mason_data/obj/* && service apache2 restart
~~~~~~~

This is an example for deleting the mason cache and restarting the Apache HTTP web server on a Debian based operating system.


# Author

Benjamin Heisig, <bheisig@synetics.de>


# Support and Documentation

You can find documentation for this module with the `perldoc` command.

~~~~~~~ {.bash}
perldoc RT::Extension::StallFutureTicket
~~~~~~~


# Bugs

Please report any bugs or feature requests to the [author](#author).


# Acknowledgements

Special thanks to the *synetics GmbH*, <http://i-doit.org/> for initiating and supporting this project!


# Copyright and License

Copyright (C) 2011 Benjamin Heisig, <bheisig@synetics.de>

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

Request Tracker (RT) is Copyright Best Practical Solutions, LLC.

