use strict;
use warnings;

use Test::More;
use Test::Exception;

BEGIN { use_ok 'TextFileParser'; }

my $pars = new TextFileParser;
throws_ok { $pars->filename('text-simple.txt') } 'TextFileParser::Exception',
    'No file by this name';
throws_ok { $pars->read('text-simple.txt'); } 'TextFileParser::Exception',
    'Throws exception for non-existent file';

lives_ok { $pars->read(); } 'TextFileParser::Exception';
lives_ok { $pars->read('t/text-simple.txt'); }
'reads the contents of a file without dying';

my $content = "This is a file with one line\n";
is( $pars->last_record,  $content, 'Last record is correct' );
is( $pars->lines_parsed, 1,        'Read only one line' );
is_deeply( [ $pars->get_records ], [$content], 'Got correct file content' );

my $add = "This record is added";
lives_ok { $pars->save_record($add); } 'Add another record';
is( $pars->lines_parsed, 1,    'Still only 1 line parsed' );
is( $pars->last_record,  $add, 'Last added record' );
is_deeply(
    [ $pars->get_records ],
    [ $content, $add ],
    'But will contain two elements'
);

done_testing;
