/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumn;
import com.gargoylesoftware.htmlunit.html.HtmlTableColumnGroup;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableComponent;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClasses={HtmlTableColumn.class, HtmlTableColumnGroup.class})
public class HTMLTableColElement
extends HTMLTableComponent {
    @JsxGetter
    public int getSpan() {
        int i;
        String span = this.getDomNodeOrDie().getAttribute("span");
        try {
            i = Integer.parseInt(span);
            if (i < 1) {
                i = 1;
            }
        }
        catch (NumberFormatException e) {
            i = 1;
        }
        return i;
    }

    @JsxSetter
    public void setSpan(Object span) {
        double d = Context.toNumber((Object)span);
        int i = (int)d;
        if (i < 1) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TABLE_COLUMN_SPAN_THROWS_EXCEPTION_IF_LESS_THAN_ONE)) {
                Exception e = new Exception("Cannot set the span property to invalid value: " + span);
                Context.throwAsScriptRuntimeEx((Throwable)e);
            } else {
                i = 1;
            }
        }
        this.getDomNodeOrDie().setAttribute("span", Integer.toString(i));
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TABLE_COLUMN_WIDTH_DOES_NOT_RETURN_NEGATIVE_VALUES);
        Boolean returnNegativeValues = ie ? Boolean.FALSE : null;
        return this.getWidthOrHeight("width", returnNegativeValues);
    }

    @JsxSetter
    public void setWidth(Object width) {
        this.setWidthOrHeight("width", width == null ? "" : Context.toString((Object)width), Boolean.FALSE);
    }
}

