/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnly;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnlyStatus;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.KeyboardEvent;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.MutationEvent;
import com.gargoylesoftware.htmlunit.javascript.host.NamespaceCollection;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.NodeFilter;
import com.gargoylesoftware.htmlunit.javascript.host.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.Range;
import com.gargoylesoftware.htmlunit.javascript.host.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.StaticNodeList;
import com.gargoylesoftware.htmlunit.javascript.host.TreeWalker;
import com.gargoylesoftware.htmlunit.javascript.host.UIEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollectionTags;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.Cookie;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.UniqueTag;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.DOMException;

@JsxClass
public class HTMLDocument
extends Document
implements ScriptableWithFallbackGetter {
    private static final Log LOG = LogFactory.getLog(HTMLDocument.class);
    public static final String EMPTY_COOKIE_NAME = "HTMLUNIT_EMPTY_COOKIE";
    private static final String LAST_MODIFIED_DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private static final Pattern FIRST_TAG_PATTERN = Pattern.compile("<(\\w+)(\\s+[^>]*)?>");
    private static final Pattern ATTRIBUTES_PATTERN = Pattern.compile("(\\w+)\\s*=\\s*['\"]([^'\"]*)['\"]");
    private static final Map<String, Class<? extends Event>> SUPPORTED_EVENT_TYPE_MAP;
    private static final List<String> EXECUTE_CMDS_IE;
    private static final List<String> EXECUTE_CMDS_FF;
    private static int UniqueID_Counter_;
    private HTMLCollection all_;
    private HTMLCollection forms_;
    private HTMLCollection links_;
    private HTMLCollection images_;
    private HTMLCollection scripts_;
    private HTMLCollection anchors_;
    private HTMLCollection applets_;
    private StyleSheetList styleSheets_;
    private NamespaceCollection namespaces_;
    private HTMLElement activeElement_;
    private final StringBuilder writeBuffer_ = new StringBuilder();
    private boolean writeInCurrentDocument_ = true;
    private String domain_;
    private String uniqueID_;
    private String lastModified_;
    private boolean closePostponedAction_;

    @Override
    public <N extends DomNode> N getDomNodeOrDie() throws IllegalStateException {
        try {
            return super.getDomNodeOrDie();
        }
        catch (IllegalStateException e) {
            DomNode node = this.getDomNodeOrNullFromRealDocument();
            if (node != null) {
                return (N)node;
            }
            throw Context.reportRuntimeError((String)"No node attached to this object");
        }
    }

    public DomNode getDomNodeOrNull() {
        Object node = super.getDomNodeOrNull();
        if (node == null) {
            node = this.getDomNodeOrNullFromRealDocument();
        }
        return node;
    }

    private DomNode getDomNodeOrNullFromRealDocument() {
        Window w;
        Document realDocument;
        Scriptable scope;
        DomNode node = null;
        boolean ie = this.getWindow().getWebWindow().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_51);
        if (ie && (scope = this.getParentScope()) instanceof Window && (realDocument = (w = (Window)scope).getDocument()) != this) {
            node = (DomNode)realDocument.getDomNodeOrDie();
        }
        return node;
    }

    public HtmlPage getHtmlPage() {
        return (HtmlPage)this.getDomNodeOrDie();
    }

    public HtmlPage getHtmlPageOrNull() {
        return (HtmlPage)this.getDomNodeOrNull();
    }

    @JsxGetter
    public Object getForms() {
        if (this.forms_ == null) {
            HtmlPage page = this.getHtmlPage();
            final boolean allowFunctionCall = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_FORMS_FUNCTION_SUPPORTED);
            this.forms_ = new HTMLCollection(page, false, "HTMLDocument.forms"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return node instanceof HtmlForm;
                }

                @Override
                public final Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    if (allowFunctionCall) {
                        return super.call(cx, scope, thisObj, args);
                    }
                    throw Context.reportRuntimeError((String)"TypeError: document.forms is not a function");
                }
            };
        }
        return this.forms_;
    }

    @JsxGetter
    public Object getLinks() {
        if (this.links_ == null) {
            this.links_ = new HTMLCollection((DomNode)this.getDomNodeOrDie(), true, "HTMLDocument.links"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return (node instanceof HtmlAnchor || node instanceof HtmlArea) && ((HtmlElement)node).hasAttribute("href");
                }

                @Override
                protected NodeList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                    HtmlElement node = event.getHtmlElement();
                    if ((node instanceof HtmlAnchor || node instanceof HtmlArea) && "href".equals(event.getName())) {
                        return NodeList.EffectOnCache.RESET;
                    }
                    return NodeList.EffectOnCache.NONE;
                }
            };
        }
        return this.links_;
    }

    @JsxGetter
    public String getLastModified() {
        if (this.lastModified_ == null) {
            WebResponse webResponse = this.getPage().getWebResponse();
            String stringDate = webResponse.getResponseHeaderValue("Last-Modified");
            if (stringDate == null) {
                stringDate = webResponse.getResponseHeaderValue("Date");
            }
            Date lastModified = HTMLDocument.parseDateOrNow(stringDate);
            this.lastModified_ = new SimpleDateFormat(LAST_MODIFIED_DATE_FORMAT).format(lastModified);
        }
        return this.lastModified_;
    }

    private static Date parseDateOrNow(String stringDate) {
        Date date = com.gargoylesoftware.htmlunit.util.StringUtils.parseHttpDate(stringDate);
        if (date == null) {
            return new Date();
        }
        return date;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getNamespaces() {
        if (this.namespaces_ == null) {
            this.namespaces_ = new NamespaceCollection(this);
        }
        return this.namespaces_;
    }

    @JsxGetter
    public Object getAnchors() {
        if (this.anchors_ == null) {
            final boolean checkId = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ANCHORS_REQUIRES_NAME_OR_ID);
            this.anchors_ = new HTMLCollection((DomNode)this.getDomNodeOrDie(), true, "HTMLDocument.anchors"){

                @Override
                protected boolean isMatching(DomNode node) {
                    if (!(node instanceof HtmlAnchor)) {
                        return false;
                    }
                    HtmlAnchor anchor = (HtmlAnchor)node;
                    if (checkId) {
                        return anchor.hasAttribute("name") || anchor.hasAttribute("id");
                    }
                    return anchor.hasAttribute("name");
                }

                @Override
                protected NodeList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                    HtmlElement node = event.getHtmlElement();
                    if (!(node instanceof HtmlAnchor)) {
                        return NodeList.EffectOnCache.NONE;
                    }
                    if ("name".equals(event.getName()) || "id".equals(event.getName())) {
                        return NodeList.EffectOnCache.RESET;
                    }
                    return NodeList.EffectOnCache.NONE;
                }
            };
        }
        return this.anchors_;
    }

    @JsxGetter
    public Object getApplets() {
        if (this.applets_ == null) {
            this.applets_ = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, "HTMLDocument.applets"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return node instanceof HtmlApplet;
                }
            };
        }
        return this.applets_;
    }

    @JsxFunction
    public static void write(Context context, Scriptable thisObj, Object[] args, Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args));
    }

    private static String concatArgsAsString(Object[] args) {
        StringBuilder buffer = new StringBuilder();
        for (Object arg : args) {
            buffer.append(Context.toString((Object)arg));
        }
        return buffer.toString();
    }

    @JsxFunction
    public static void writeln(Context context, Scriptable thisObj, Object[] args, Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args) + "\n");
    }

    private static HTMLDocument getDocument(Scriptable thisObj) {
        if (thisObj instanceof HTMLDocument && thisObj.getPrototype() instanceof HTMLDocument) {
            return (HTMLDocument)thisObj;
        }
        if (thisObj instanceof DocumentProxy && thisObj.getPrototype() instanceof HTMLDocument) {
            return (HTMLDocument)((DocumentProxy)thisObj).getDelegee();
        }
        Window window = HTMLDocument.getWindow(thisObj);
        BrowserVersion browser = window.getWebWindow().getWebClient().getBrowserVersion();
        if (browser.hasFeature(BrowserVersionFeatures.GENERATED_53)) {
            return (HTMLDocument)window.getDocument();
        }
        throw Context.reportRuntimeError((String)"Function can't be used detached from document");
    }

    protected void write(String content) {
        HtmlPage page;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("write: " + content));
        }
        if (!(page = (HtmlPage)this.getDomNodeOrDie()).isBeingParsed()) {
            this.writeInCurrentDocument_ = false;
        }
        this.writeBuffer_.append(content);
        if (!this.writeInCurrentDocument_) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"wrote content to buffer");
            }
            this.scheduleImplicitClose();
            return;
        }
        String bufferedContent = this.writeBuffer_.toString();
        if (!HTMLDocument.canAlreadyBeParsed(bufferedContent)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"write: not enough content to parse it now");
            }
            return;
        }
        this.writeBuffer_.setLength(0);
        page.writeInParsedStream(bufferedContent);
    }

    private void scheduleImplicitClose() {
        if (!this.closePostponedAction_) {
            this.closePostponedAction_ = true;
            HtmlPage page = (HtmlPage)this.getDomNodeOrDie();
            page.getWebClient().getJavaScriptEngine().addPostponedAction(new PostponedAction(page){

                @Override
                public void execute() throws Exception {
                    if (HTMLDocument.this.writeBuffer_.length() > 0) {
                        HTMLDocument.this.close();
                    }
                    HTMLDocument.this.closePostponedAction_ = false;
                }
            });
        }
    }

    static boolean canAlreadyBeParsed(String content) {
        PARSING_STATUS tagState = PARSING_STATUS.OUTSIDE;
        int tagNameBeginIndex = 0;
        int scriptTagCount = 0;
        boolean tagIsOpen = true;
        char stringBoundary = '\u0000';
        boolean stringSkipNextChar = false;
        int index = 0;
        char openingQuote = '\u0000';
        for (char currentChar : content.toCharArray()) {
            switch (tagState) {
                case OUTSIDE: {
                    if (currentChar == '<') {
                        tagState = PARSING_STATUS.START;
                        tagIsOpen = true;
                        break;
                    }
                    if (scriptTagCount <= 0 || currentChar != '\'' && currentChar != '\"') break;
                    tagState = PARSING_STATUS.IN_STRING;
                    stringBoundary = currentChar;
                    stringSkipNextChar = false;
                    break;
                }
                case START: {
                    if (currentChar == '/') {
                        tagIsOpen = false;
                        tagNameBeginIndex = index + 1;
                    } else {
                        tagNameBeginIndex = index;
                    }
                    tagState = PARSING_STATUS.IN_NAME;
                    break;
                }
                case IN_NAME: {
                    if (Character.isWhitespace(currentChar) || currentChar == '>') {
                        String tagName = content.substring(tagNameBeginIndex, index);
                        if ("script".equalsIgnoreCase(tagName)) {
                            if (tagIsOpen) {
                                ++scriptTagCount;
                            } else if (scriptTagCount > 0) {
                                --scriptTagCount;
                            }
                        }
                        if (currentChar == '>') {
                            tagState = PARSING_STATUS.OUTSIDE;
                            break;
                        }
                        tagState = PARSING_STATUS.INSIDE;
                        break;
                    }
                    if (Character.isLetter(currentChar)) break;
                    tagState = PARSING_STATUS.OUTSIDE;
                    break;
                }
                case INSIDE: {
                    if (currentChar == openingQuote) {
                        openingQuote = '\u0000';
                        break;
                    }
                    if (openingQuote != '\u0000') break;
                    if (currentChar == '\'' || currentChar == '\"') {
                        openingQuote = currentChar;
                        break;
                    }
                    if (currentChar != '>' || openingQuote != '\u0000') break;
                    tagState = PARSING_STATUS.OUTSIDE;
                    break;
                }
                case IN_STRING: {
                    if (stringSkipNextChar) {
                        stringSkipNextChar = false;
                        break;
                    }
                    if (currentChar == stringBoundary) {
                        tagState = PARSING_STATUS.OUTSIDE;
                        break;
                    }
                    if (currentChar != '\\') break;
                    stringSkipNextChar = true;
                    break;
                }
            }
            ++index;
        }
        return scriptTagCount <= 0 && tagState == PARSING_STATUS.OUTSIDE;
    }

    HtmlElement getLastHtmlElement(HtmlElement node) {
        DomNode lastChild = node.getLastChild();
        if (lastChild == null || !(lastChild instanceof HtmlElement) || lastChild instanceof HtmlScript) {
            return node;
        }
        return this.getLastHtmlElement((HtmlElement)lastChild);
    }

    @JsxGetter
    public String getCookie() {
        HtmlPage page = this.getHtmlPage();
        URL url = page.getUrl();
        url = HTMLDocument.replaceForCookieIfNecessary(url);
        StringBuilder buffer = new StringBuilder();
        Set<Cookie> cookies = page.getWebClient().getCookieManager().getCookies(url);
        for (Cookie cookie : cookies) {
            if (cookie.isHttpOnly()) continue;
            if (buffer.length() != 0) {
                buffer.append("; ");
            }
            if (!EMPTY_COOKIE_NAME.equals(cookie.getName())) {
                buffer.append(cookie.getName());
                buffer.append("=");
            }
            buffer.append(cookie.getValue());
        }
        return buffer.toString();
    }

    @JsxGetter
    public String getCompatMode() {
        return this.getHtmlPage().isQuirksMode() ? "BackCompat" : "CSS1Compat";
    }

    @JsxSetter
    public void setCookie(String newCookie) {
        CookieManager cookieManager = this.getHtmlPage().getWebClient().getCookieManager();
        if (cookieManager.isCookiesEnabled()) {
            URL url = this.getHtmlPage().getUrl();
            url = HTMLDocument.replaceForCookieIfNecessary(url);
            Cookie cookie = HTMLDocument.buildCookie(newCookie, url);
            cookieManager.addCookie(cookie);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added cookie: " + cookie));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Skipped adding cookie: " + newCookie));
        }
    }

    private static URL replaceForCookieIfNecessary(URL url) {
        String protocol = url.getProtocol();
        boolean file = "file".equals(protocol);
        if (file) {
            try {
                url = UrlUtils.getUrlWithNewPort(UrlUtils.getUrlWithNewHost(url, "LOCAL_FILESYSTEM"), 0);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    public static Cookie buildCookie(String newCookie, URL currentURL) {
        String value;
        String name;
        StringTokenizer st = new StringTokenizer(newCookie, ";");
        if (newCookie.contains("=")) {
            String nameAndValue = st.nextToken();
            name = StringUtils.substringBefore((String)nameAndValue, (String)"=").trim();
            value = StringUtils.substringAfter((String)nameAndValue, (String)"=").trim();
        } else {
            name = EMPTY_COOKIE_NAME;
            value = newCookie;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.put("domain", currentURL.getHost());
        atts.put("path", "");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int indexEqual = token.indexOf(61);
            if (indexEqual > -1) {
                atts.put(token.substring(0, indexEqual).toLowerCase().trim(), token.substring(indexEqual + 1).trim());
                continue;
            }
            atts.put(token.toLowerCase().trim(), Boolean.TRUE);
        }
        String date = (String)atts.get("expires");
        Date expires = com.gargoylesoftware.htmlunit.util.StringUtils.parseHttpDate(date);
        String domain = (String)atts.get("domain");
        String path = (String)atts.get("path");
        boolean secure = atts.get("secure") != null;
        Cookie cookie = new Cookie(domain, name, value, path, expires, secure);
        return cookie;
    }

    @JsxGetter
    public Object getImages() {
        if (this.images_ == null) {
            this.images_ = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, "HTMLDocument.images"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return node instanceof HtmlImage;
                }
            };
        }
        return this.images_;
    }

    @JsxGetter(propertyName="URL")
    public String getURL() {
        return this.getHtmlPage().getUrl().toExternalForm();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getUniqueID() {
        if (this.uniqueID_ == null) {
            this.uniqueID_ = "ms__id" + UniqueID_Counter_++;
        }
        return this.uniqueID_;
    }

    @JsxGetter
    public HTMLCollection getAll() {
        if (this.all_ == null) {
            this.all_ = new HTMLCollectionTags((DomNode)this.getDomNodeOrDie(), "HTMLDocument.all"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return true;
                }
            };
            this.all_.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
        }
        return this.all_;
    }

    @JsxFunction
    public Object open(String url, Object name, Object features, Object replace) {
        HtmlPage page = this.getHtmlPage();
        if (page.isBeingParsed()) {
            LOG.warn((Object)"Ignoring call to open() during the parsing stage.");
            return null;
        }
        if (!this.writeInCurrentDocument_) {
            LOG.warn((Object)"Function open() called when document is already open.");
        }
        this.writeInCurrentDocument_ = false;
        return null;
    }

    @JsxFunction
    public void close() throws IOException {
        if (this.writeInCurrentDocument_) {
            LOG.warn((Object)"close() called when document is not open.");
        } else {
            HtmlPage page = this.getHtmlPage();
            URL url = page.getUrl();
            StringWebResponse webResponse = new StringWebResponse(this.writeBuffer_.toString(), url);
            webResponse.setFromJavascript(true);
            this.writeInCurrentDocument_ = true;
            this.writeBuffer_.setLength(0);
            WebClient webClient = page.getWebClient();
            WebWindow window = page.getEnclosingWindow();
            webClient.loadWebResponseInto(webResponse, window);
        }
    }

    private void implicitCloseIfNecessary() {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_55);
        if (!this.writeInCurrentDocument_ && ie) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getParentWindow() {
        return this.getWindow();
    }

    @Override
    public Object appendChild(Object childObject) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_APPEND_CHILD_SUPPORTED)) {
            return super.appendChild(childObject);
        }
        throw Context.reportRuntimeError((String)"Node cannot be inserted at the specified point in the hierarchy.");
    }

    @Override
    public Object createElement(String tagName) {
        Object result = NOT_FOUND;
        if (tagName.startsWith("<") && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_57)) {
            Matcher m = FIRST_TAG_PATTERN.matcher(tagName);
            if (m.find()) {
                tagName = m.group(1);
                result = super.createElement(tagName);
                if (result == NOT_FOUND || m.group(2) == null) {
                    return result;
                }
                HTMLElement elt = (HTMLElement)result;
                String attributes = m.group(2);
                Matcher mAttribute = ATTRIBUTES_PATTERN.matcher(attributes);
                while (mAttribute.find()) {
                    String attrName = mAttribute.group(1);
                    String attrValue = mAttribute.group(2);
                    elt.setAttribute(attrName, attrValue);
                }
            }
        } else {
            return super.createElement(tagName);
        }
        return result;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public CSSStyleSheet createStyleSheet(String url, int index) {
        CSSStyleSheet stylesheet = new CSSStyleSheet();
        stylesheet.setPrototype(this.getPrototype(CSSStyleSheet.class));
        stylesheet.setParentScope(this.getWindow());
        return stylesheet;
    }

    @JsxFunction
    public Object getElementById(String id) {
        Object result;
        block7: {
            this.implicitCloseIfNecessary();
            result = null;
            try {
                boolean caseSensitive = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_ELEMENT_BY_ID_CASE_SENSITIVE);
                Object htmlElement = this.getHtmlPage().getElementById(id, caseSensitive);
                SimpleScriptable jsElement = this.getScriptableFor(htmlElement);
                if (jsElement == NOT_FOUND) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("getElementById(" + id + ") cannot return a result as there isn't a JavaScript object for the HTML element " + htmlElement.getClass().getName()));
                    }
                } else {
                    result = jsElement;
                }
            }
            catch (ElementNotFoundException e) {
                BrowserVersion browser = this.getBrowserVersion();
                if (browser.hasFeature(BrowserVersionFeatures.JS_GET_ELEMENT_BY_ID_ALSO_BY_NAME_IN_QUICKS_MODE) && this.getHtmlPage().isQuirksMode()) {
                    HTMLCollection elements = this.getElementsByName(id);
                    result = elements.get(0, (Scriptable)elements);
                    if (result instanceof UniqueTag) {
                        return null;
                    }
                    LOG.warn((Object)("getElementById(" + id + ") did a getElementByName for Internet Explorer"));
                    return result;
                }
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)("getElementById(" + id + "): no DOM node found with this id"));
            }
        }
        return result;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public HTMLCollection getElementsByClassName(String className) {
        return ((HTMLElement)this.getDocumentElement()).getElementsByClassName(className);
    }

    @JsxFunction
    public HTMLCollection getElementsByName(String elementName) {
        this.implicitCloseIfNecessary();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_59) && (StringUtils.isEmpty((CharSequence)elementName) || "null".equals(elementName))) {
            return HTMLCollection.emptyCollection(this.getWindow());
        }
        final String expElementName = "null".equals(elementName) ? "" : elementName;
        final HtmlPage page = (HtmlPage)this.getPage();
        String description = "HTMLDocument.getElementsByName('" + elementName + "')";
        HTMLCollection collection = new HTMLCollection(page, true, description){

            @Override
            protected List<Object> computeElements() {
                return new ArrayList<Object>(page.getElementsByName(expElementName));
            }

            @Override
            protected NodeList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                if ("name".equals(event.getName())) {
                    return NodeList.EffectOnCache.RESET;
                }
                return NodeList.EffectOnCache.NONE;
            }
        };
        return collection;
    }

    @Override
    protected Object getWithPreemption(String name) {
        HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        if (page == null || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_160)) {
            return NOT_FOUND;
        }
        return this.getIt(name);
    }

    private Object getIt(final String name) {
        final HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        final boolean isIE = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_60);
        HTMLCollection collection = new HTMLCollection(page, true, "HTMLDocument." + name){

            @Override
            protected List<Object> computeElements() {
                List<DomElement> elements = isIE ? page.getElementsByIdAndOrName(name) : page.getElementsByName(name);
                ArrayList<Object> matchingElements = new ArrayList<Object>();
                for (DomElement elt : elements) {
                    if (!(elt instanceof HtmlForm) && !(elt instanceof HtmlImage) && !(elt instanceof HtmlApplet) && (!isIE || !(elt instanceof BaseFrameElement))) continue;
                    matchingElements.add(elt);
                }
                return matchingElements;
            }

            @Override
            protected NodeList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                String attributeName = event.getName();
                if ("name".equals(attributeName)) {
                    return NodeList.EffectOnCache.RESET;
                }
                if (isIE && "id".equals(attributeName)) {
                    return NodeList.EffectOnCache.RESET;
                }
                return NodeList.EffectOnCache.NONE;
            }

            @Override
            protected SimpleScriptable getScriptableFor(Object object) {
                if (isIE && object instanceof BaseFrameElement) {
                    return (SimpleScriptable)((BaseFrameElement)object).getEnclosedWindow().getScriptObject();
                }
                return super.getScriptableFor(object);
            }
        };
        int length = collection.getLength();
        if (length == 0) {
            return NOT_FOUND;
        }
        if (length == 1) {
            return collection.item((Object)0);
        }
        return collection;
    }

    @Override
    public Object getWithFallback(String name) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_161)) {
            return this.getIt(name);
        }
        return NOT_FOUND;
    }

    @JsxGetter
    @CanSetReadOnly(value=CanSetReadOnlyStatus.EXCEPTION)
    public HTMLElement getBody() {
        HtmlElement body;
        HtmlPage page = this.getHtmlPage();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_61) && page.getEnclosingWindow() instanceof FrameWindow) {
            HtmlPage enclosingPage = (HtmlPage)page.getEnclosingWindow().getParentWindow().getEnclosedPage();
            if (WebClient.URL_ABOUT_BLANK.equals(page.getUrl()) && enclosingPage.getReadyState() != "complete") {
                return null;
            }
        }
        if ((body = page.getBody()) != null) {
            return (HTMLElement)body.getScriptObject();
        }
        return null;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, minVersion=10.0f)})
    public HTMLElement getHead() {
        HtmlElement head = this.getHtmlPage().getHead();
        if (head != null) {
            return (HTMLElement)head.getScriptObject();
        }
        return null;
    }

    @JsxGetter
    public String getTitle() {
        return this.getHtmlPage().getTitleText();
    }

    @JsxSetter
    public void setTitle(String title) {
        this.getHtmlPage().setTitleText(title);
    }

    @JsxGetter
    public String getBgColor() {
        String color = this.getHtmlPage().getBody().getAttribute("bgColor");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#ffffff";
        }
        return color;
    }

    @JsxSetter
    public void setBgColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getHtmlPage().getBody().getScriptObject();
        body.setBgColor(color);
    }

    @JsxGetter
    public String getAlinkColor() {
        String color = this.getHtmlPage().getBody().getAttribute("aLink");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#0000ff";
        }
        return color;
    }

    @JsxSetter
    public void setAlinkColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getHtmlPage().getBody().getScriptObject();
        body.setALink(color);
    }

    @JsxGetter
    public String getLinkColor() {
        String color = this.getHtmlPage().getBody().getAttribute("link");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#0000ff";
        }
        return color;
    }

    @JsxSetter
    public void setLinkColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getHtmlPage().getBody().getScriptObject();
        body.setLink(color);
    }

    @JsxGetter
    public String getVlinkColor() {
        String color = this.getHtmlPage().getBody().getAttribute("vLink");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#800080";
        }
        return color;
    }

    @JsxSetter
    public void setVlinkColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getHtmlPage().getBody().getScriptObject();
        body.setVLink(color);
    }

    @JsxGetter
    public String getFgColor() {
        String color = this.getHtmlPage().getBody().getAttribute("text");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#000000";
        }
        return color;
    }

    @JsxSetter
    public void setFgColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getHtmlPage().getBody().getScriptObject();
        body.setText(color);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public String getReadyState() {
        Object node = this.getDomNodeOrDie();
        return ((DomNode)node).getReadyState();
    }

    @JsxGetter
    public String getDomain() {
        if (this.domain_ == null) {
            URL url = this.getHtmlPage().getUrl();
            if (url == WebClient.URL_ABOUT_BLANK) {
                WebWindow w = this.getWindow().getWebWindow();
                if (w instanceof FrameWindow) {
                    url = ((FrameWindow)w).getEnclosingPage().getUrl();
                } else {
                    return null;
                }
            }
            this.domain_ = url.getHost();
            BrowserVersion browser = this.getBrowserVersion();
            if (browser.hasFeature(BrowserVersionFeatures.JS_DOCUMENT_DOMAIN_IS_LOWERCASE)) {
                this.domain_ = this.domain_.toLowerCase();
            }
        }
        return this.domain_;
    }

    @JsxSetter
    public void setDomain(String newDomain) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (WebClient.URL_ABOUT_BLANK == this.getPage().getUrl() && browserVersion.hasFeature(BrowserVersionFeatures.JS_DOCUMENT_SETTING_DOMAIN_THROWS_FOR_ABOUT_BLANK)) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from \"" + WebClient.URL_ABOUT_BLANK + "\" to: \"" + newDomain + "\"."));
        }
        String currentDomain = this.getDomain();
        if (currentDomain.equalsIgnoreCase(newDomain)) {
            return;
        }
        if (newDomain.indexOf(46) == -1) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\" (new domain has to contain a dot)."));
        }
        if (currentDomain.indexOf(46) > -1 && !currentDomain.toLowerCase().endsWith("." + newDomain.toLowerCase())) {
            throw Context.reportRuntimeError((String)("Illegal domain value, cannot set domain from: \"" + currentDomain + "\" to: \"" + newDomain + "\""));
        }
        this.domain_ = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_DOMAIN_IS_LOWERCASE) ? newDomain.toLowerCase() : newDomain;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=10.0f)})
    public Object getScripts() {
        if (this.scripts_ == null) {
            this.scripts_ = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, "HTMLDocument.scripts"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return node instanceof HtmlScript;
                }
            };
        }
        return this.scripts_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)}, propertyName="selection")
    public Selection getSelection_js() {
        return this.getWindow().getSelectionImpl();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getFrames() {
        return this.getWindow().getFrames_js();
    }

    @JsxGetter
    public StyleSheetList getStyleSheets() {
        if (this.styleSheets_ == null) {
            this.styleSheets_ = new StyleSheetList(this);
        }
        return this.styleSheets_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public Event createEvent(String eventType) throws DOMException {
        Class<? extends Event> clazz = SUPPORTED_EVENT_TYPE_MAP.get(eventType);
        if (clazz == null) {
            Context.throwAsScriptRuntimeEx((Throwable)new DOMException(9, "Event Type is not supported: " + eventType));
            return null;
        }
        try {
            Event event = clazz.newInstance();
            event.setEventType(eventType);
            event.setParentScope(this.getWindow());
            event.setPrototype(this.getPrototype(clazz));
            return event;
        }
        catch (InstantiationException e) {
            throw Context.reportRuntimeError((String)("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            throw Context.reportRuntimeError((String)("Failed to instantiate event: class ='" + clazz.getName() + "' for event type of '" + eventType + "': " + e.getMessage()));
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Event createEventObject() {
        MouseEvent event = new MouseEvent();
        event.setParentScope(this.getWindow());
        event.setPrototype(this.getPrototype(event.getClass()));
        return event;
    }

    @JsxFunction
    public Object elementFromPoint(int x, int y) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_164) && (x <= 0 || y <= 0)) {
            return null;
        }
        return this.getBody();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public Range createRange() {
        Range r = new Range(this);
        r.setParentScope(this.getWindow());
        r.setPrototype(this.getPrototype(Range.class));
        return r;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public Object createTreeWalker(Node root, double whatToShow, final Scriptable filter, boolean expandEntityReferences) throws DOMException {
        long whatToShowL = Double.valueOf(whatToShow).longValue();
        NodeFilter filterWrapper = null;
        if (filter != null) {
            filterWrapper = new NodeFilter(){

                @Override
                public short acceptNode(Node n) {
                    Object[] args = new Object[]{n};
                    Object response = filter instanceof Callable ? ((Callable)filter).call(Context.getCurrentContext(), filter, filter, args) : ScriptableObject.callMethod((Scriptable)filter, (String)"acceptNode", (Object[])args);
                    return (short)Context.toNumber((Object)response);
                }
            };
        }
        TreeWalker t = new TreeWalker(root, whatToShowL, filterWrapper, expandEntityReferences);
        t.setParentScope(HTMLDocument.getWindow(this));
        t.setPrototype(HTMLDocument.staticGetPrototype(HTMLDocument.getWindow(this), TreeWalker.class));
        return t;
    }

    private static Scriptable staticGetPrototype(Window window, Class<? extends SimpleScriptable> javaScriptClass) {
        Scriptable prototype = window.getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != SimpleScriptable.class) {
            return HTMLDocument.staticGetPrototype(window, javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    @JsxFunction
    public boolean queryCommandSupported(String cmd) {
        boolean ff = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_165);
        String mode = this.getDesignMode();
        if (!ff) {
            return com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_IE, cmd);
        }
        if (!"on".equals(mode)) {
            String msg = "queryCommandSupported() called while document.designMode='" + mode + "'.";
            throw Context.reportRuntimeError((String)msg);
        }
        return com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_FF, cmd);
    }

    @JsxFunction
    public boolean queryCommandEnabled(String cmd) {
        boolean ff = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_165);
        String mode = this.getDesignMode();
        if (!ff) {
            return com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_IE, cmd);
        }
        if (!"on".equals(mode)) {
            String msg = "queryCommandEnabled() called while document.designMode='" + mode + "'.";
            throw Context.reportRuntimeError((String)msg);
        }
        return com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_FF, cmd);
    }

    @JsxFunction
    public boolean execCommand(String cmd, boolean userInterface, Object value) {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_63);
        if (ie && !com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_IE, cmd) || !ie && !com.gargoylesoftware.htmlunit.util.StringUtils.containsCaseInsensitive(EXECUTE_CMDS_FF, cmd)) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EXECCOMMAND_THROWS_ON_WRONG_COMMAND)) {
                throw Context.reportRuntimeError((String)("document.execCommand(): invalid command '" + cmd + "'"));
            }
            return false;
        }
        LOG.warn((Object)("Nothing done for execCommand(" + cmd + ", ...) (feature not implemented)"));
        return true;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public Object getActiveElement() {
        HtmlElement body;
        if (this.activeElement_ == null && (body = this.getHtmlPage().getBody()) != null) {
            this.activeElement_ = (HTMLElement)this.getScriptableFor(body);
        }
        return this.activeElement_;
    }

    public void setActiveElement(HTMLElement element) {
        this.activeElement_ = element;
    }

    @Override
    public SimpleScriptable getDoctype() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_DOCTYPE_NULL)) {
            return null;
        }
        return super.getDoctype();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        ScriptResult result = this.fireEvent(event);
        return !event.isAborted(result);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public StaticNodeList querySelectorAll(String selectors) {
        try {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (DomNode domNode : this.getHtmlPage().querySelectorAll(selectors)) {
                nodes.add((Node)domNode.getScriptObject());
            }
            return new StaticNodeList(nodes, this);
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public Node querySelector(String selectors) {
        try {
            DomNode node = this.getHtmlPage().querySelector(selectors);
            if (node != null) {
                return (Node)node.getScriptObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object response = super.get(name, start);
        if (response instanceof FunctionObject && ("querySelectorAll".equals(name) || "querySelector".equals(name)) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS) && this.getHtmlPage().isQuirksMode()) {
            return NOT_FOUND;
        }
        return response;
    }

    @JsxFunction
    public void clear() {
    }

    @Override
    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        if (domNode instanceof DomDocumentType && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.DOCTYPE_IS_COMMENT)) {
            DomDocumentType docType = (DomDocumentType)domNode;
            DomComment comment = new DomComment(this.getHtmlPage(), "DOCTYPE " + docType.getName() + " PUBLIC \"" + docType.getPublicId() + "\"      \"" + docType.getSystemId() + '\"');
            return super.makeScriptableFor(comment);
        }
        return super.makeScriptableFor(domNode);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF, minVersion=10.0f)})
    public void setHead(ScriptableObject head) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public Selection getSelection() {
        return this.getWindow().getSelectionImpl();
    }

    static {
        EXECUTE_CMDS_IE = Arrays.asList("2D-Position", "AbsolutePosition", "BackColor", "BackgroundImageCache", "BlockDirLTR", "BlockDirRTL", "Bold", "BrowseMode", "ClearAuthenticationCache", "Copy", "CreateBookmark", "CreateLink", "Cut", "Delete", "DirLTR", "DirRTL", "EditMode", "FontName", "FontSize", "ForeColor", "FormatBlock", "Indent", "InlineDirLTR", "InlineDirRTL", "InsertButton", "InsertFieldset", "InsertHorizontalRule", "InsertIFrame", "InsertImage", "InsertInputButton", "InsertInputCheckbox", "InsertInputFileUpload", "InsertInputHidden", "InsertInputImage", "InsertInputPassword", "InsertInputRadio", "InsertInputReset", "InsertInputSubmit", "InsertInputText", "InsertMarquee", "InsertOrderedList", "InsertParagraph", "InsertSelectDropdown", "InsertSelectListbox", "InsertTextArea", "InsertUnorderedList", "Italic", "JustifyCenter", "JustifyFull", "JustifyLeft", "JustifyNone", "JustifyRight", "LiveResize", "MultipleSelection", "Open", "Outdent", "OverWrite", "Paste", "PlayImage", "Print", "Redo", "Refresh", "RemoveFormat", "RemoveParaFormat", "SaveAs", "SelectAll", "SizeToControl", "SizeToControlHeight", "SizeToControlWidth", "Stop", "StopImage", "StrikeThrough", "Subscript", "Superscript", "UnBookmark", "Underline", "Undo", "Unlink", "Unselect");
        EXECUTE_CMDS_FF = Arrays.asList("backColor", "bold", "contentReadOnly", "copy", "createLink", "cut", "decreaseFontSize", "delete", "fontName", "fontSize", "foreColor", "formatBlock", "heading", "hiliteColor", "increaseFontSize", "indent", "insertHorizontalRule", "insertHTML", "insertImage", "insertOrderedList", "insertUnorderedList", "insertParagraph", "italic", "justifyCenter", "justifyLeft", "justifyRight", "outdent", "paste", "redo", "removeFormat", "selectAll", "strikeThrough", "subscript", "superscript", "underline", "undo", "unlink", "useCSS", "styleWithCSS");
        UniqueID_Counter_ = 1;
        HashMap<String, Class<UIEvent>> eventMap = new HashMap<String, Class<UIEvent>>();
        eventMap.put("Event", Event.class);
        eventMap.put("Events", Event.class);
        eventMap.put("KeyboardEvent", KeyboardEvent.class);
        eventMap.put("KeyEvents", KeyboardEvent.class);
        eventMap.put("HTMLEvents", Event.class);
        eventMap.put("MouseEvent", MouseEvent.class);
        eventMap.put("MouseEvents", MouseEvent.class);
        eventMap.put("MutationEvent", MutationEvent.class);
        eventMap.put("MutationEvents", MutationEvent.class);
        eventMap.put("UIEvent", UIEvent.class);
        eventMap.put("UIEvents", UIEvent.class);
        SUPPORTED_EVENT_TYPE_MAP = Collections.unmodifiableMap(eventMap);
    }

    private static enum PARSING_STATUS {
        OUTSIDE,
        START,
        IN_NAME,
        INSIDE,
        IN_STRING;

    }
}

