/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.host.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.BoxObject;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.StaticNodeList;
import com.gargoylesoftware.htmlunit.javascript.host.TextRange;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.css.sac.CSSException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class HTMLElement
extends Element
implements ScriptableWithFallbackGetter {
    private static final Pattern PERCENT_VALUE = Pattern.compile("\\d+%");
    private static final Log LOG = LogFactory.getLog(HTMLElement.class);
    private static final int BEHAVIOR_ID_UNKNOWN = -1;
    public static final int BEHAVIOR_ID_CLIENT_CAPS = 0;
    public static final int BEHAVIOR_ID_HOMEPAGE = 1;
    public static final int BEHAVIOR_ID_DOWNLOAD = 2;
    private static final String BEHAVIOR_CLIENT_CAPS = "#default#clientCaps";
    private static final String BEHAVIOR_HOMEPAGE = "#default#homePage";
    private static final String BEHAVIOR_DOWNLOAD = "#default#download";
    private static final Pattern CLASS_NAMES_SPLIT_PATTERN = Pattern.compile("\\s");
    private static final Pattern PRINT_NODE_PATTERN = Pattern.compile("  ");
    private static final Pattern PRINT_NODE_QUOTE_PATTERN = Pattern.compile("\"");
    static final String POSITION_BEFORE_BEGIN = "beforeBegin";
    static final String POSITION_AFTER_BEGIN = "afterBegin";
    static final String POSITION_BEFORE_END = "beforeEnd";
    static final String POSITION_AFTER_END = "afterEnd";
    private static int UniqueID_Counter_ = 1;
    private final Set<String> behaviors_ = new HashSet<String>();
    private BoxObject boxObject_;
    private HTMLCollection all_;
    private int scrollLeft_;
    private int scrollTop_;
    private String uniqueID_;
    private String ch_ = "";
    private String chOff_ = "";
    private static final List<String> INNER_HTML_READONLY_IN_IE = Arrays.asList("col", "colgroup", "frameset", "head", "html", "style", "table", "tbody", "tfoot", "thead", "title", "tr");
    private static final List<String> INNER_TEXT_READONLY = Arrays.asList("html", "table", "tbody", "tfoot", "thead", "tr");
    private static final List<String> OUTER_HTML_READONLY = Arrays.asList("caption", "col", "colgroup", "frameset", "html", "tbody", "td", "tfoot", "th", "thead", "tr");

    public HTMLCollection jsxGet_all() {
        if (this.all_ == null) {
            this.all_ = new HTMLCollection(this.getDomNodeOrDie(), false, "HTMLElement.all"){

                protected boolean isMatching(DomNode node) {
                    return true;
                }
            };
        }
        return this.all_;
    }

    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        HtmlElement htmlElt = (HtmlElement)domNode;
        for (DomAttr attr : htmlElt.getAttributesMap().values()) {
            String eventName = attr.getName();
            if (!eventName.startsWith("on")) continue;
            this.createEventHandler(eventName, attr.getValue());
        }
    }

    protected void createEventHandler(String eventName, String attrValue) {
        HtmlElement htmlElt = this.getDomNodeOrDie();
        EventHandler eventHandler = new EventHandler(htmlElt, eventName, attrValue);
        this.setEventHandler(eventName, (Function)eventHandler);
        if (htmlElt instanceof HtmlBody || htmlElt instanceof HtmlFrameSet) {
            this.getWindow().getEventListenersContainer().setEventHandlerProp(eventName.substring(2), (Object)eventHandler);
        }
    }

    public String jsxGet_id() {
        return this.getDomNodeOrDie().getId();
    }

    public void jsxSet_id(String newId) {
        this.getDomNodeOrDie().setId(newId);
    }

    public String jsxGet_title() {
        return this.getDomNodeOrDie().getAttribute("title");
    }

    public void jsxSet_title(String newTitle) {
        this.getDomNodeOrDie().setAttribute("title", newTitle);
    }

    public boolean jsxGet_disabled() {
        return this.getDomNodeOrDie().hasAttribute("disabled");
    }

    public DocumentProxy jsxGet_document() {
        return this.getWindow().jsxGet_document();
    }

    public void jsxSet_disabled(boolean disabled) {
        HtmlElement element = this.getDomNodeOrDie();
        if (disabled) {
            element.setAttribute("disabled", "disabled");
        } else {
            element.removeAttribute("disabled");
        }
    }

    public String jsxGet_namespaceURI() {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_65)) {
            return domNode.getNamespaceURI();
        }
        if (domNode.getPage() instanceof HtmlPage) {
            return null;
        }
        return domNode.getNamespaceURI();
    }

    public String jsxGet_localName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (domNode.getPage() instanceof HtmlPage) {
            StringBuilder localName = new StringBuilder();
            String prefix = ((DomNode)domNode).getPrefix();
            if (prefix != null) {
                localName.append(prefix);
                localName.append(':');
            }
            localName.append(((DomNode)domNode).getLocalName());
            return localName.toString().toUpperCase();
        }
        return ((DomNode)domNode).getLocalName();
    }

    public Object getWithFallback(String name) {
        String value;
        HtmlElement htmlElement;
        if (!"class".equals(name) && (htmlElement = this.getDomNodeOrNull()) != null && this.isAttributeName(name) && DomElement.ATTRIBUTE_NOT_DEFINED != (value = htmlElement.getAttribute(name))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found attribute for evaluation of property \"" + name + "\" for of " + this));
            }
            return value;
        }
        return NOT_FOUND;
    }

    protected boolean isAttributeName(String name) {
        return name.toLowerCase().equals(name);
    }

    protected String fixAttributeName(String attributeName) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_66)) {
            if ("className".equals(attributeName)) {
                return "class";
            }
            if ("class".equals(attributeName)) {
                return "_class";
            }
        }
        return attributeName;
    }

    public void jsxFunction_clearAttributes() {
        HtmlElement node = this.getDomNodeOrDie();
        ArrayList<String> removals = new ArrayList<String>();
        for (String attributeName : node.getAttributesMap().keySet()) {
            if (ScriptableObject.hasProperty((Scriptable)this.getPrototype(), (String)attributeName)) continue;
            removals.add(attributeName);
        }
        for (String attributeName : removals) {
            node.removeAttribute(attributeName);
        }
        for (Object id : this.getAllIds()) {
            if (id instanceof Integer) {
                int i = (Integer)id;
                this.delete(i);
                continue;
            }
            if (!(id instanceof String)) continue;
            this.delete((String)id);
        }
    }

    public void jsxFunction_mergeAttributes(HTMLElement source, Object preserveIdentity) {
        HtmlElement src = source.getDomNodeOrDie();
        HtmlElement target = this.getDomNodeOrDie();
        for (Map.Entry<String, DomAttr> attribute : src.getAttributesMap().entrySet()) {
            String attributeName = attribute.getKey();
            if (ScriptableObject.hasProperty((Scriptable)this.getPrototype(), (String)attributeName)) continue;
            String attributeValue = attribute.getValue().getNodeValue();
            target.setAttribute(attributeName, attributeValue);
        }
        for (Object id : source.getAllIds()) {
            if (id instanceof Integer) {
                int i = (Integer)id;
                this.put(i, this, source.get(i, source));
                continue;
            }
            if (!(id instanceof String)) continue;
            String s = (String)id;
            this.put(s, this, source.get(s, source));
        }
        if (preserveIdentity instanceof Boolean && !((Boolean)preserveIdentity).booleanValue()) {
            target.setId(src.getId());
            target.setAttribute("name", src.getAttribute("name"));
        }
    }

    public Object jsxFunction_getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().getAttributeNodeNS(namespaceURI, localName).getScriptObject();
    }

    public String jsxFunction_getAttributeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().getAttributeNS(namespaceURI, localName);
    }

    public boolean jsxFunction_hasAttributeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().hasAttributeNS(namespaceURI, localName);
    }

    public void jsxFunction_setAttribute(String name, String value) {
        name = this.fixAttributeName(name);
        this.getDomNodeOrDie().setAttribute(name, value);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_167)) {
            try {
                Method method = this.getClass().getMethod("jsxSet_" + name, Object.class);
                String source = "function(){" + value + "}";
                method.invoke((Object)this, Context.getCurrentContext().compileFunction((Scriptable)this.getWindow(), source, "", 0, null));
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public void jsxFunction_setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        this.getDomNodeOrDie().setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public void jsxFunction_removeAttributeNS(String namespaceURI, String localName) {
        this.getDomNodeOrDie().removeAttributeNS(namespaceURI, localName);
    }

    public void jsxFunction_removeAttributeNode(Attr attribute) {
        String name = attribute.jsxGet_name();
        String namespaceUri = attribute.jsxGet_namespaceURI();
        this.jsxFunction_removeAttributeNS(namespaceUri, name);
    }

    public HTMLElement jsxFunction_removeNode(boolean removeChildren) {
        HTMLElement parent = this.jsxGet_parentElement();
        if (parent != null) {
            parent.jsxFunction_removeChild(this);
            if (!removeChildren) {
                HTMLCollection collection = this.jsxGet_childNodes();
                int length = collection.jsxGet_length();
                for (int i = 0; i < length; ++i) {
                    Node object = (Node)collection.jsxFunction_item(0);
                    parent.jsxFunction_appendChild(object);
                }
            }
        }
        return this;
    }

    public Object jsxFunction_getAttributeNode(String attributeName) {
        return ((NamedNodeMap)this.jsxGet_attributes()).jsxFunction_getNamedItem(attributeName);
    }

    public Attr jsxFunction_setAttributeNode(Attr newAtt) {
        DomAttr newDomAttr;
        Attr replacedAtt;
        String name = newAtt.jsxGet_name();
        boolean undefForClass = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SET_ATTRIBUTE_CONSIDERS_ATTR_FOR_CLASS_AS_REAL);
        if (undefForClass) {
            replacedAtt = (Attr)this.jsxFunction_getAttributeNode(name);
        } else {
            NamedNodeMap nodes = (NamedNodeMap)this.jsxGet_attributes();
            replacedAtt = (Attr)nodes.getNamedItemWithoutSytheticClassAttr(name);
        }
        if (replacedAtt != null) {
            replacedAtt.detachFromParent();
        }
        if (null == (newDomAttr = newAtt.getDomNodeOrDie())) {
            String value = newAtt.jsxGet_value();
            this.getDomNodeOrDie().setAttribute(name, value);
            return replacedAtt;
        }
        this.getDomNodeOrDie().setAttributeNode(newDomAttr);
        return replacedAtt;
    }

    public HTMLCollection jsxFunction_getElementsByClassName(String className) {
        HtmlElement elt = this.getDomNodeOrDie();
        String description = "HTMLElement.getElementsByClassName('" + className + "')";
        final String[] classNames = CLASS_NAMES_SPLIT_PATTERN.split(className, 0);
        HTMLCollection collection = new HTMLCollection(elt, true, description){

            protected boolean isMatching(DomNode node) {
                if (!(node instanceof HtmlElement)) {
                    return false;
                }
                HtmlElement elt = (HtmlElement)node;
                String classAttribute = elt.getAttribute("class");
                if (classAttribute == DomElement.ATTRIBUTE_NOT_DEFINED) {
                    return false;
                }
                classAttribute = " " + classAttribute + " ";
                for (String aClassName : classNames) {
                    if (classAttribute.contains(" " + aClassName + " ")) continue;
                    return false;
                }
                return true;
            }
        };
        return collection;
    }

    public Object jsxGet_className() {
        return this.getDomNodeOrDie().getAttribute("class");
    }

    public int jsxGet_clientHeight() {
        boolean includePadding = !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_EXTENT_WITHOUT_PADDING);
        ComputedCSSStyleDeclaration style = this.getWindow().jsxFunction_getComputedStyle(this, null);
        return style.getCalculatedHeight(false, includePadding);
    }

    public int jsxGet_clientWidth() {
        boolean includePadding = !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_EXTENT_WITHOUT_PADDING);
        ComputedCSSStyleDeclaration style = this.getWindow().jsxFunction_getComputedStyle(this, null);
        return style.getCalculatedWidth(false, includePadding);
    }

    public void jsxSet_className(String className) {
        this.getDomNodeOrDie().setAttribute("class", className);
    }

    public String jsxGet_innerHTML() {
        StringBuilder buf = new StringBuilder();
        this.printChildren(buf, this.getDomNodeOrDie(), !"SCRIPT".equals(this.jsxGet_tagName()));
        return buf.toString();
    }

    public String jsxGet_innerText() {
        StringBuilder buf = new StringBuilder();
        this.printChildren(buf, this.getDomNodeOrDie(), false);
        return buf.toString();
    }

    public String jsxGet_outerHTML() {
        StringBuilder buf = new StringBuilder();
        this.printNode(buf, this.getDomNodeOrDie(), true);
        return buf.toString();
    }

    private void printChildren(StringBuilder buffer, DomNode node, boolean html) {
        for (DomNode child : node.getChildren()) {
            this.printNode(buffer, child, html);
        }
    }

    private void printNode(StringBuilder buffer, DomNode node, boolean html) {
        if (node instanceof DomComment) {
            if (html) {
                String s = PRINT_NODE_PATTERN.matcher(node.getNodeValue()).replaceAll(" ");
                buffer.append("<!--").append(s).append("-->");
            }
        } else if (node instanceof DomCharacterData) {
            String s = node.getNodeValue();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_REDUCE_WHITESPACES)) {
                s = PRINT_NODE_PATTERN.matcher(s).replaceAll(" ");
            }
            if (html) {
                s = StringUtils.escapeXmlChars(s);
            }
            buffer.append(s);
        } else if (html) {
            HtmlElement element = (HtmlElement)node;
            boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_69);
            String tag = element.getTagName();
            if (ie) {
                tag = tag.toUpperCase();
            }
            buffer.append("<").append(tag);
            for (DomAttr attr : element.getAttributesMap().values()) {
                String name = attr.getName();
                String value = PRINT_NODE_QUOTE_PATTERN.matcher(attr.getValue()).replaceAll("&quot;");
                boolean quote = !ie || StringUtils.containsWhitespace(value) || value.length() == 0 || element instanceof HtmlAnchor && "href".equals(name);
                buffer.append(' ').append(name).append("=");
                if (quote) {
                    buffer.append("\"");
                }
                buffer.append(value);
                if (!quote) continue;
                buffer.append("\"");
            }
            buffer.append(">");
            this.printChildren(buffer, node, html);
            buffer.append("</").append(tag).append(">");
        } else {
            HtmlElement element = (HtmlElement)node;
            if ("p".equals(element.getTagName())) {
                buffer.append("\r\n");
            }
            if (!"script".equals(element.getTagName())) {
                this.printChildren(buffer, node, html);
            }
        }
    }

    public void jsxSet_innerHTML(Object value) {
        HtmlElement domNode = this.getDomNodeOrDie();
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_70);
        if (ie && INNER_HTML_READONLY_IN_IE.contains(((DomNode)domNode).getNodeName())) {
            throw Context.reportRuntimeError((String)("innerHTML is read-only for tag " + ((DomNode)domNode).getNodeName()));
        }
        domNode.removeAllChildren();
        if (value == null && ie || value != null && !"".equals(value)) {
            String valueAsString = Context.toString((Object)value);
            HTMLElement.parseHtmlSnippet(domNode, true, valueAsString);
            if (domNode.getParentNode() == null && ie) {
                DomDocumentFragment fragment = ((HtmlPage)domNode.getPage()).createDomDocumentFragment();
                fragment.appendChild(domNode);
            }
        }
    }

    public void jsxSet_innerText(String value) {
        this.setInnerText(Context.toString((Object)value));
    }

    private void setInnerText(String value) {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (INNER_TEXT_READONLY.contains(((DomNode)domNode).getNodeName())) {
            throw Context.reportRuntimeError((String)("innerText is read-only for tag " + ((DomNode)domNode).getNodeName()));
        }
        domNode.removeAllChildren();
        if (value != null && value.length() != 0) {
            domNode.appendChild(new DomText(domNode.getPage(), Context.toString((Object)value)));
        }
        if (domNode.getParentNode() == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_71)) {
            DomDocumentFragment fragment = ((HtmlPage)domNode.getPage()).createDomDocumentFragment();
            fragment.appendChild(domNode);
        }
    }

    public void jsxSet_textContent(Object value) {
        this.setInnerText(value == null ? null : Context.toString((Object)value));
    }

    public void jsxSet_outerHTML(String value) {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (OUTER_HTML_READONLY.contains(((DomNode)domNode).getNodeName())) {
            throw Context.reportRuntimeError((String)("outerHTML is read-only for tag " + ((DomNode)domNode).getNodeName()));
        }
        ProxyDomNode proxyNode = new ProxyDomNode(domNode.getPage(), domNode, false);
        HTMLElement.parseHtmlSnippet(proxyNode, false, value);
        domNode.remove();
    }

    public static void parseHtmlSnippet(DomNode target, boolean append, String source) {
        try {
            HTMLParser.parseFragment(target, source);
        }
        catch (IOException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
        }
        catch (SAXException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
        }
    }

    protected AttributesImpl readAttributes(HtmlElement element) {
        AttributesImpl attributes = new AttributesImpl();
        for (DomAttr entry : element.getAttributesMap().values()) {
            String name = entry.getName();
            String value = entry.getValue();
            attributes.addAttribute(null, name, name, null, value);
        }
        return attributes;
    }

    public void jsxFunction_insertAdjacentHTML(String where, String text) {
        Object[] values = this.getInsertAdjacentLocation(where);
        DomNode node = (DomNode)values[0];
        boolean append = (Boolean)values[1];
        ProxyDomNode proxyNode = new ProxyDomNode(node.getPage(), node, append);
        HTMLElement.parseHtmlSnippet(proxyNode, append, text);
    }

    public Object jsxFunction_insertAdjacentElement(String where, Object object) {
        if (object instanceof Node) {
            Object childNode = ((Node)object).getDomNodeOrDie();
            Object[] values = this.getInsertAdjacentLocation(where);
            DomNode node = (DomNode)values[0];
            boolean append = (Boolean)values[1];
            if (append) {
                node.appendChild((org.w3c.dom.Node)childNode);
            } else {
                node.insertBefore((DomNode)childNode);
            }
            return object;
        }
        throw Context.reportRuntimeError((String)("Passed object is not an element: " + object));
    }

    private Object[] getInsertAdjacentLocation(String where) {
        boolean append;
        DomNode node;
        HtmlElement currentNode = this.getDomNodeOrDie();
        if (POSITION_AFTER_BEGIN.equalsIgnoreCase(where)) {
            if (currentNode.getFirstChild() == null) {
                node = currentNode;
                append = true;
            } else {
                node = currentNode.getFirstChild();
                append = false;
            }
        } else if (POSITION_BEFORE_BEGIN.equalsIgnoreCase(where)) {
            node = currentNode;
            append = false;
        } else if (POSITION_BEFORE_END.equalsIgnoreCase(where)) {
            node = currentNode;
            append = true;
        } else if (POSITION_AFTER_END.equalsIgnoreCase(where)) {
            if (currentNode.getNextSibling() == null) {
                node = currentNode.getParentNode();
                append = true;
            } else {
                node = currentNode.getNextSibling();
                append = false;
            }
        } else {
            throw Context.reportRuntimeError((String)("Illegal position value: \"" + where + "\""));
        }
        if (append) {
            return new Object[]{node, Boolean.TRUE};
        }
        return new Object[]{node, Boolean.FALSE};
    }

    public int jsxFunction_addBehavior(String behavior) {
        if (this.behaviors_.contains(behavior)) {
            return 0;
        }
        Class<?> c = this.getClass();
        if (BEHAVIOR_CLIENT_CAPS.equalsIgnoreCase(behavior)) {
            this.defineProperty("availHeight", c, 0);
            this.defineProperty("availWidth", c, 0);
            this.defineProperty("bufferDepth", c, 0);
            this.defineProperty("colorDepth", c, 0);
            this.defineProperty("connectionType", c, 0);
            this.defineProperty("cookieEnabled", c, 0);
            this.defineProperty("cpuClass", c, 0);
            this.defineProperty("height", c, 0);
            this.defineProperty("javaEnabled", c, 0);
            this.defineProperty("platform", c, 0);
            this.defineProperty("systemLanguage", c, 0);
            this.defineProperty("userLanguage", c, 0);
            this.defineProperty("width", c, 0);
            this.defineFunctionProperties(new String[]{"addComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"clearComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"compareVersions"}, c, 0);
            this.defineFunctionProperties(new String[]{"doComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"getComponentVersion"}, c, 0);
            this.defineFunctionProperties(new String[]{"isComponentInstalled"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 0;
        }
        if (BEHAVIOR_HOMEPAGE.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"isHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"setHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"navigateHomePage"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 1;
        }
        if (BEHAVIOR_DOWNLOAD.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"startDownload"}, c, 0);
            this.behaviors_.add(BEHAVIOR_DOWNLOAD);
            return 2;
        }
        LOG.warn((Object)("Unimplemented behavior: " + behavior));
        return -1;
    }

    public void jsxFunction_removeBehavior(int id) {
        switch (id) {
            case 0: {
                this.delete("availHeight");
                this.delete("availWidth");
                this.delete("bufferDepth");
                this.delete("colorDepth");
                this.delete("connectionType");
                this.delete("cookieEnabled");
                this.delete("cpuClass");
                this.delete("height");
                this.delete("javaEnabled");
                this.delete("platform");
                this.delete("systemLanguage");
                this.delete("userLanguage");
                this.delete("width");
                this.delete("addComponentRequest");
                this.delete("clearComponentRequest");
                this.delete("compareVersions");
                this.delete("doComponentRequest");
                this.delete("getComponentVersion");
                this.delete("isComponentInstalled");
                this.behaviors_.remove(BEHAVIOR_CLIENT_CAPS);
                break;
            }
            case 1: {
                this.delete("isHomePage");
                this.delete("setHomePage");
                this.delete("navigateHomePage");
                this.behaviors_.remove(BEHAVIOR_HOMEPAGE);
                break;
            }
            case 2: {
                this.delete("startDownload");
                this.behaviors_.remove(BEHAVIOR_DOWNLOAD);
                break;
            }
            default: {
                LOG.warn((Object)("Unexpected behavior id: " + id + ". Ignoring."));
            }
        }
    }

    public int getAvailHeight() {
        return this.getWindow().jsxGet_screen().jsxGet_availHeight();
    }

    public int getAvailWidth() {
        return this.getWindow().jsxGet_screen().jsxGet_availWidth();
    }

    public int getBufferDepth() {
        return this.getWindow().jsxGet_screen().jsxGet_bufferDepth();
    }

    public BoxObject getBoxObject() {
        if (this.boxObject_ == null) {
            this.boxObject_ = new BoxObject(this);
            this.boxObject_.setParentScope(this.getWindow());
            this.boxObject_.setPrototype(this.getPrototype(this.boxObject_.getClass()));
        }
        return this.boxObject_;
    }

    public int getColorDepth() {
        return this.getWindow().jsxGet_screen().jsxGet_colorDepth();
    }

    public String getConnectionType() {
        return "modem";
    }

    public boolean getCookieEnabled() {
        return this.getWindow().jsxGet_navigator().jsxGet_cookieEnabled();
    }

    public String getCpuClass() {
        return this.getWindow().jsxGet_navigator().jsxGet_cpuClass();
    }

    public int getHeight() {
        return this.getWindow().jsxGet_screen().jsxGet_height();
    }

    public boolean getJavaEnabled() {
        return this.getWindow().jsxGet_navigator().jsxFunction_javaEnabled();
    }

    public String getPlatform() {
        return this.getWindow().jsxGet_navigator().jsxGet_platform();
    }

    public String getSystemLanguage() {
        return this.getWindow().jsxGet_navigator().jsxGet_systemLanguage();
    }

    public String getUserLanguage() {
        return this.getWindow().jsxGet_navigator().jsxGet_userLanguage();
    }

    public int getWidth() {
        return this.getWindow().jsxGet_screen().jsxGet_width();
    }

    public void addComponentRequest(String id, String idType, String minVersion) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Call to addComponentRequest(" + id + ", " + idType + ", " + minVersion + ") ignored."));
        }
    }

    public void clearComponentRequest() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Call to clearComponentRequest() ignored.");
        }
    }

    public int compareVersions(String v1, String v2) {
        int i = v1.compareTo(v2);
        if (i == 0) {
            return 0;
        }
        if (i < 0) {
            return -1;
        }
        return 1;
    }

    public boolean doComponentRequest() {
        return false;
    }

    public String getComponentVersion(String id, String idType) {
        if ("{E5D12C4E-7B4F-11D3-B5C9-0050045C3C96}".equals(id)) {
            return "";
        }
        return "1.0";
    }

    public boolean isComponentInstalled(String id, String idType, String minVersion) {
        return false;
    }

    public void startDownload(String uri, Function callback) throws MalformedURLException {
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        URL url = page.getFullyQualifiedUrl(uri);
        if (!page.getWebResponse().getWebRequest().getUrl().getHost().equals(url.getHost())) {
            throw Context.reportRuntimeError((String)("Not authorized url: " + url));
        }
        JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createDownloadBehaviorJob(url, callback, this.getWindow().getWebWindow().getWebClient());
        page.getEnclosingWindow().getJobManager().addJob(job, page);
    }

    public boolean isHomePage(String url) {
        try {
            URL newUrl = new URL(url);
            URL currentUrl = this.getDomNodeOrDie().getPage().getWebResponse().getWebRequest().getUrl();
            String home = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().getHomePage();
            boolean sameDomains = newUrl.getHost().equalsIgnoreCase(currentUrl.getHost());
            boolean isHomePage = home != null && home.equals(url);
            return sameDomains && isHomePage;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void setHomePage(String url) {
        this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().setHomePage(url);
    }

    public void navigateHomePage() throws IOException {
        WebClient webClient = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient();
        webClient.getPage(webClient.getHomePage());
    }

    public HTMLCollection jsxGet_children() {
        final HtmlElement node = this.getDomNodeOrDie();
        HTMLCollection collection = new HTMLCollection(node, false, "HTMLElement.children"){

            @Override
            protected List<Object> computeElements() {
                return new ArrayList<Object>((Collection<Object>)((Object)node.getChildNodes()));
            }
        };
        return collection;
    }

    public int jsxGet_offsetHeight() {
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.jsxGet_clientY() - this.getPosY() + 50;
        }
        return this.jsxGet_currentStyle().getCalculatedHeight(true, true);
    }

    public int jsxGet_offsetWidth() {
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.jsxGet_clientX() - this.getPosX() + 50;
        }
        return this.jsxGet_currentStyle().getCalculatedWidth(true, true);
    }

    protected boolean isAncestorOfEventTarget(MouseEvent event) {
        if (event == null) {
            return false;
        }
        if (!(event.jsxGet_srcElement() instanceof HTMLElement)) {
            return false;
        }
        HTMLElement srcElement = (HTMLElement)event.jsxGet_srcElement();
        return this.getDomNodeOrDie().isAncestorOf(srcElement.getDomNodeOrDie());
    }

    public String toString() {
        return "HTMLElement for " + this.getDomNodeOrNull();
    }

    public int jsxGet_scrollTop() {
        if (this.scrollTop_ < 0) {
            this.scrollTop_ = 0;
        } else if (this.scrollTop_ > 0 && !this.jsxGet_currentStyle().isScrollable(false)) {
            this.scrollTop_ = 0;
        }
        return this.scrollTop_;
    }

    public void jsxSet_scrollTop(int scroll) {
        this.scrollTop_ = scroll;
    }

    public int jsxGet_scrollLeft() {
        if (this.scrollLeft_ < 0) {
            this.scrollLeft_ = 0;
        } else if (this.scrollLeft_ > 0 && !this.jsxGet_currentStyle().isScrollable(true)) {
            this.scrollLeft_ = 0;
        }
        return this.scrollLeft_;
    }

    public void jsxSet_scrollLeft(int scroll) {
        this.scrollLeft_ = scroll;
    }

    public int jsxGet_scrollHeight() {
        return 10;
    }

    public int jsxGet_scrollWidth() {
        return 10;
    }

    public String jsxGet_scopeName() {
        String prefix = this.getDomNodeOrDie().getPrefix();
        return prefix != null ? prefix : "HTML";
    }

    public String jsxGet_tagUrn() {
        String urn = this.getDomNodeOrDie().getNamespaceURI();
        return urn != null ? urn : "";
    }

    public void jsxSet_tagUrn(String tagUrn) {
        throw Context.reportRuntimeError((String)("Error trying to set tagUrn to '" + tagUrn + "'."));
    }

    public HTMLElement jsxGet_parentElement() {
        Node parent = this.getParent();
        if (!(parent instanceof HTMLElement)) {
            return null;
        }
        return (HTMLElement)parent;
    }

    public HTMLElement getParentHTMLElement() {
        Node parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof HTMLElement); parent = parent.getParent()) {
        }
        return (HTMLElement)parent;
    }

    public void jsxFunction_scrollIntoView() {
    }

    public Object jsxFunction_getClientRects() {
        return new NativeArray(0L);
    }

    public void jsxFunction_setExpression(String propertyName, String expression, String language) {
    }

    public boolean jsxFunction_removeExpression(String propertyName) {
        return true;
    }

    public String jsxGet_uniqueID() {
        if (this.uniqueID_ == null) {
            this.uniqueID_ = "ms__id" + UniqueID_Counter_++;
        }
        return this.uniqueID_;
    }

    public boolean jsxFunction_dispatchEvent(Event event) {
        event.setTarget(this);
        HtmlElement element = this.getDomNodeOrDie();
        ScriptResult result = null;
        if (event.jsxGet_type().equals("click")) {
            try {
                element.click(event);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("Error calling click(): " + e.getMessage()));
            }
        } else {
            result = this.fireEvent(event);
        }
        return !event.isAborted(result);
    }

    public final HtmlElement getDomNodeOrDie() {
        return (HtmlElement)super.getDomNodeOrDie();
    }

    public HtmlElement getDomNodeOrNull() {
        return (HtmlElement)super.getDomNodeOrNull();
    }

    public void jsxFunction_blur() {
        this.getDomNodeOrDie().blur();
    }

    public Object jsxFunction_createTextRange() {
        TextRange range = new TextRange(this);
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype(range.getClass()));
        return range;
    }

    public boolean jsxFunction_contains(HTMLElement element) {
        for (HTMLElement parent = element; parent != null; parent = parent.jsxGet_parentElement()) {
            if (this != parent) continue;
            return true;
        }
        return false;
    }

    public void jsxFunction_focus() {
        this.getDomNodeOrDie().focus();
    }

    public void jsxFunction_setActive() {
        Window window = this.getWindow();
        HTMLDocument document = (HTMLDocument)window.getDocument();
        document.setActiveElement(this);
        if (window.getWebWindow() == window.getWebWindow().getWebClient().getCurrentWindow()) {
            HtmlElement element = this.getDomNodeOrDie();
            ((HtmlPage)element.getPage()).setFocusedElement(element);
        }
    }

    public StaticNodeList jsxFunction_querySelectorAll(String selectors) {
        try {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (DomNode domNode : this.getDomNodeOrDie().querySelectorAll(selectors)) {
                nodes.add((Node)domNode.getScriptObject());
            }
            return new StaticNodeList(nodes, this);
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)"An invalid or illegal string was specified");
        }
    }

    public Node jsxFunction_querySelector(String selectors) {
        try {
            DomNode node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)node.getScriptObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)"An invalid or illegal string was specified");
        }
    }

    public Object get(String name, Scriptable start) {
        Object response = super.get(name, start);
        if (response instanceof FunctionObject && ("querySelectorAll".equals(name) || "querySelector".equals(name)) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS)) {
            HtmlElement domNode = this.getDomNodeOrNull();
            if (null == domNode) {
                return response;
            }
            SgmlPage sgmlPage = domNode.getPage();
            if (sgmlPage instanceof HtmlPage && ((HtmlPage)sgmlPage).isQuirksMode()) {
                return NOT_FOUND;
            }
        }
        return response;
    }

    public String jsxGet_nodeName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        String nodeName = ((DomNode)domNode).getNodeName();
        if (domNode.getPage() instanceof HtmlPage) {
            nodeName = nodeName.toUpperCase();
        }
        return nodeName;
    }

    public String jsxGet_prefix() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_73)) {
            return "";
        }
        return null;
    }

    public Object jsxGet_filters() {
        return this;
    }

    public void jsxFunction_click() throws IOException {
        this.getDomNodeOrDie().click();
    }

    public boolean jsxGet_spellcheck() {
        return Context.toBoolean((Object)this.getDomNodeOrDie().getAttribute("spellcheck"));
    }

    public void jsxSet_spellcheck(boolean spellcheck) {
        this.getDomNodeOrDie().setAttribute("spellcheck", Boolean.toString(spellcheck));
    }

    public String jsxGet_lang() {
        return this.getDomNodeOrDie().getAttribute("lang");
    }

    public void jsxSet_lang(String lang) {
        this.getDomNodeOrDie().setAttribute("lang", lang);
    }

    public String jsxGet_language() {
        return this.getDomNodeOrDie().getAttribute("language");
    }

    public void jsxSet_language(String language) {
        this.getDomNodeOrDie().setAttribute("language", language);
    }

    public String jsxGet_dir() {
        return this.getDomNodeOrDie().getAttribute("dir");
    }

    public void jsxSet_dir(String dir) {
        this.getDomNodeOrDie().setAttribute("dir", dir);
    }

    public int jsxGet_tabIndex() {
        return (int)Context.toNumber((Object)this.getDomNodeOrDie().getAttribute("tabindex"));
    }

    public void jsxSet_tabIndex(int tabIndex) {
        this.getDomNodeOrDie().setAttribute("tabindex", Integer.toString(tabIndex));
    }

    public void jsxFunction_doScroll(String scrollAction) {
        if (((HtmlPage)this.getDomNodeOrDie().getPage()).isBeingParsed()) {
            throw Context.reportRuntimeError((String)"The data necessary to complete this operation is not yet available.");
        }
    }

    public String jsxGet_accessKey() {
        return this.getDomNodeOrDie().getAttribute("accesskey");
    }

    public void jsxSet_accessKey(String accessKey) {
        this.getDomNodeOrDie().setAttribute("accesskey", accessKey);
    }

    protected String getWidthOrHeight(String attributeName, Boolean returnNegativeValues) {
        String s;
        block3: {
            s = this.getDomNodeOrDie().getAttribute(attributeName);
            if (!PERCENT_VALUE.matcher(s).matches()) {
                try {
                    Float f = Float.valueOf(s);
                    int i = f.intValue();
                    s = i < 0 ? (returnNegativeValues == null ? "0" : (!returnNegativeValues.booleanValue() ? "" : Integer.toString(i))) : Integer.toString(i);
                }
                catch (NumberFormatException e) {
                    if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_74)) break block3;
                    s = "";
                }
            }
        }
        return s;
    }

    protected void setWidthOrHeight(String attributeName, String value, Boolean allowNegativeValues) {
        if (value.endsWith("px")) {
            value = value.substring(0, value.length() - 2);
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_75) && value.length() > 0) {
            boolean error = false;
            if (!PERCENT_VALUE.matcher(value).matches()) {
                try {
                    Float f = Float.valueOf(value);
                    int i = f.intValue();
                    if (i < 0) {
                        if (allowNegativeValues == null) {
                            value = "0";
                        } else if (!allowNegativeValues.booleanValue()) {
                            error = true;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    error = true;
                }
            }
            if (error) {
                Exception e = new Exception("Cannot set the width property to invalid value: " + value);
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        this.getDomNodeOrDie().setAttribute(attributeName, value);
    }

    protected void setColorAttribute(String name, String value) {
        String s = StringUtils.isColorHexadecimal(value) ? value : "#000000";
        this.getDomNodeOrDie().setAttribute(name, s);
    }

    protected String getAlign(boolean returnInvalidValues) {
        String align = this.getDomNodeOrDie().getAttribute("align");
        if ("center".equals(align) || "justify".equals(align) || "left".equals(align) || "right".equals(align) || returnInvalidValues) {
            return align;
        }
        return "";
    }

    protected void setAlign(String align, boolean ignoreIfNoError) {
        align = align.toLowerCase();
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        if (acceptArbitraryValues || "center".equals(align) || "justify".equals(align) || "left".equals(align) || "right".equals(align)) {
            if (!ignoreIfNoError) {
                this.getDomNodeOrDie().setAttribute("align", align);
            }
            return;
        }
        throw Context.reportRuntimeError((String)("Cannot set the align property to invalid value: '" + align + "'"));
    }

    protected String getVAlign(String[] valid, String defaultValue) {
        String valign = this.getDomNodeOrDie().getAttribute("valign");
        if (valid == null || ArrayUtils.contains((Object[])valid, (Object)valign)) {
            return valign;
        }
        return defaultValue;
    }

    protected void setVAlign(Object vAlign, String[] valid) {
        String s = Context.toString((Object)vAlign).toLowerCase();
        if (valid != null && !ArrayUtils.contains((Object[])valid, (Object)s)) {
            throw Context.reportRuntimeError((String)("Cannot set the vAlign property to invalid value: " + vAlign));
        }
        this.getDomNodeOrDie().setAttribute("valign", s);
    }

    protected String getCh() {
        boolean emulated = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_EMULATED);
        if (emulated) {
            return this.ch_;
        }
        String ch = this.getDomNodeOrDie().getAttribute("char");
        if (ch == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_UNDEFINED_DOT)) {
            return ".";
        }
        return ch;
    }

    protected void setCh(String ch) {
        boolean emulated = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_EMULATED);
        if (emulated) {
            this.ch_ = ch;
        } else {
            this.getDomNodeOrDie().setAttribute("char", ch);
        }
    }

    protected String getChOff() {
        boolean emulated = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_OFF_EMULATED);
        if (emulated) {
            return this.chOff_;
        }
        return this.getDomNodeOrDie().getAttribute("charOff");
    }

    protected void setChOff(String chOff) {
        boolean emulated = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_OFF_EMULATED);
        if (emulated) {
            this.chOff_ = chOff;
            return;
        }
        try {
            int i;
            float f = Float.parseFloat(chOff);
            chOff = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_OFF_INTEGER) ? (f < 0.0f ? "0" : Integer.toString((int)f)) : ((float)(i = (int)f) == f ? Integer.toString(i) : Float.toString(f));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.getDomNodeOrDie().setAttribute("charOff", chOff);
    }

    public static class ProxyDomNode
    extends HtmlDivision {
        private final DomNode target_;
        private final boolean append_;

        public ProxyDomNode(SgmlPage page, DomNode target, boolean append) {
            super(null, "div", page, null);
            this.target_ = target;
            this.append_ = append;
        }

        public DomNode appendChild(org.w3c.dom.Node node) {
            DomNode domNode = (DomNode)node;
            if (this.append_) {
                return this.target_.appendChild(domNode);
            }
            this.target_.insertBefore(domNode);
            return domNode;
        }

        public DomNode getDomNode() {
            return this.target_;
        }

        public boolean isAppend() {
            return this.append_;
        }
    }
}

