/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePathComparator;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BrowserCompatSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlUnitBrowserCompatCookieSpec
extends BrowserCompatSpec {
    private static final Comparator<Cookie> COOKIE_COMPARATOR = new CookiePathComparator();

    HtmlUnitBrowserCompatCookieSpec(final IncorrectnessListener incorrectnessListener) {
        BasicPathHandler pathHandler = new BasicPathHandler(){

            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            }
        };
        this.registerAttribHandler("path", (CookieAttributeHandler)pathHandler);
        final CookieAttributeHandler original = this.getAttribHandler("expires");
        CookieAttributeHandler wrapper = new CookieAttributeHandler(){

            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                original.validate(cookie, origin);
            }

            public void parse(SetCookie cookie, String value) throws MalformedCookieException {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                try {
                    original.parse(cookie, value);
                }
                catch (MalformedCookieException e) {
                    incorrectnessListener.notify("Incorrect cookie expiration time: " + value, this);
                }
            }

            public boolean match(Cookie cookie, CookieOrigin origin) {
                return original.match(cookie, origin);
            }
        };
        this.registerAttribHandler("expires", wrapper);
        CookieAttributeHandler httpOnlyHandler = new CookieAttributeHandler(){

            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            }

            public void parse(SetCookie cookie, String value) throws MalformedCookieException {
                ((BasicClientCookie)cookie).setAttribute("httponly", "true");
            }

            public boolean match(Cookie cookie, CookieOrigin origin) {
                return true;
            }
        };
        this.registerAttribHandler("httponly", httpOnlyHandler);
    }

    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        List cookies = super.parse(header, origin);
        for (Cookie c : cookies) {
            if (!header.getValue().contains(c.getName() + "=\"" + c.getValue())) continue;
            ((BasicClientCookie)c).setValue('\"' + c.getValue() + '\"');
        }
        return cookies;
    }

    public List<Header> formatCookies(List<Cookie> cookies) {
        Collections.sort(cookies, COOKIE_COMPARATOR);
        return super.formatCookies(cookies);
    }
}

