/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HtmlUnitBrowserCompatCookieSpec;
import com.gargoylesoftware.htmlunit.HtmlUnitCookieStore;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.HttpWebConnectionInsecureSSL;
import com.gargoylesoftware.htmlunit.SocksSocketFactory;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpWebConnection
implements WebConnection {
    private static final String HACKED_COOKIE_POLICY = "mine";
    private AbstractHttpClient httpClient_;
    private final WebClient webClient_;
    private String virtualHost_;
    private final CookieSpecFactory htmlUnitCookieSpecFactory_ = new CookieSpecFactory(){

        public CookieSpec newInstance(HttpParams params) {
            return new HtmlUnitBrowserCompatCookieSpec();
        }
    };
    private static final long MAX_IN_MEMORY = 512000L;

    public HttpWebConnection(WebClient webClient) {
        this.webClient_ = webClient;
    }

    @Override
    public WebResponse getResponse(WebRequest request) throws IOException {
        URL url = request.getUrl();
        AbstractHttpClient httpClient = this.getHttpClient();
        this.webClient_.getCookieManager().updateState(httpClient.getCookieStore());
        HttpUriRequest httpMethod = null;
        try {
            httpMethod = this.makeHttpMethod(request);
            HttpHost hostConfiguration = HttpWebConnection.getHostConfiguration(request);
            HttpWebConnection.setProxy((HttpClient)httpClient, request);
            long startTime = System.currentTimeMillis();
            HttpResponse httpResponse = httpClient.execute(hostConfiguration, (HttpRequest)httpMethod);
            DownloadedContent downloadedBody = this.downloadResponseBody(httpResponse);
            long endTime = System.currentTimeMillis();
            this.webClient_.getCookieManager().updateFromState(httpClient.getCookieStore());
            WebResponse webResponse = this.makeWebResponse(httpResponse, request, downloadedBody, endTime - startTime);
            return webResponse;
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to create URI from URL: " + url.toExternalForm() + " (reason: " + e.getMessage() + ")");
        }
        finally {
            if (httpMethod != null) {
                this.onResponseGenerated(httpMethod);
            }
        }
    }

    protected void onResponseGenerated(HttpUriRequest httpMethod) {
    }

    private static HttpHost getHostConfiguration(WebRequest webRequest) throws IOException {
        URL url = webRequest.getUrl();
        HttpHost hostConfiguration = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        return hostConfiguration;
    }

    private static void setProxy(HttpClient httpClient, WebRequest webRequest) {
        if (webRequest.getProxyHost() != null) {
            String proxyHost = webRequest.getProxyHost();
            int proxyPort = webRequest.getProxyPort();
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            if (webRequest.isSocksProxy()) {
                SocksSocketFactory factory = (SocksSocketFactory)httpClient.getConnectionManager().getSchemeRegistry().getScheme("http").getSchemeSocketFactory();
                factory.setSocksProxy(proxy);
            } else {
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
        }
    }

    private HttpUriRequest makeHttpMethod(WebRequest webRequest) throws IOException, URISyntaxException {
        Credentials requestCredentials;
        URL url = UrlUtils.encodeUrl(webRequest.getUrl(), false);
        String charset = webRequest.getCharset();
        URI uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)url.getQuery(), null);
        HttpRequestBase httpMethod = HttpWebConnection.buildHttpMethod(webRequest.getHttpMethod(), uri);
        if (!(httpMethod instanceof HttpEntityEnclosingRequest)) {
            if (!webRequest.getRequestParameters().isEmpty()) {
                List<NameValuePair> pairs = webRequest.getRequestParameters();
                org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (String)charset);
                uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)query, null);
                httpMethod.setURI(uri);
            }
        } else {
            HttpEntityEnclosingRequest method = (HttpEntityEnclosingRequest)httpMethod;
            if (webRequest.getEncodingType() == FormEncodingType.URL_ENCODED && method instanceof HttpPost) {
                HttpPost postMethod = (HttpPost)method;
                if (webRequest.getRequestBody() == null) {
                    List<NameValuePair> pairs = webRequest.getRequestParameters();
                    org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                    String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (String)charset);
                    StringEntity urlEncodedEntity = new StringEntity(query, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity((HttpEntity)urlEncodedEntity);
                } else {
                    String body = StringUtils.defaultString((String)webRequest.getRequestBody());
                    StringEntity urlEncodedEntity = new StringEntity(body, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity((HttpEntity)urlEncodedEntity);
                }
            } else if (FormEncodingType.MULTIPART == webRequest.getEncodingType()) {
                StringBuilder boundary = new StringBuilder();
                boundary.append("---------------------------");
                Random rand = new Random();
                char[] chars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
                for (int i = 0; i < 14; ++i) {
                    boundary.append(chars[rand.nextInt(chars.length)]);
                }
                Charset c = this.getCharset(charset, webRequest.getRequestParameters());
                MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, boundary.toString(), c);
                for (NameValuePair pair : webRequest.getRequestParameters()) {
                    if (pair instanceof KeyDataPair) {
                        KeyDataPair pairWithFile = (KeyDataPair)pair;
                        ContentBody contentBody = this.buildFilePart(pairWithFile);
                        multipartEntity.addPart(pair.getName(), contentBody);
                        continue;
                    }
                    StringBody stringBody = new StringBody(pair.getValue(), Charset.forName(webRequest.getCharset()));
                    multipartEntity.addPart(pair.getName(), (ContentBody)stringBody);
                }
                method.setEntity((HttpEntity)multipartEntity);
            } else {
                String body = webRequest.getRequestBody();
                if (body != null) {
                    method.setEntity((HttpEntity)new StringEntity(body, charset));
                }
            }
        }
        if (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTTP_HEADER_HOST_FIRST)) {
            int port = webRequest.getUrl().getPort();
            StringBuilder host = new StringBuilder(webRequest.getUrl().getHost());
            if (port != 80 && port > 0) {
                host.append(':');
                host.append(Integer.toString(port));
            }
            httpMethod.setHeader((Header)new BasicHeader("Host", host.toString()));
        }
        httpMethod.setHeader((Header)new BasicHeader("User-Agent", this.webClient_.getBrowserVersion().getUserAgent()));
        HttpWebConnection.writeRequestHeadersToHttpMethod((HttpUriRequest)httpMethod, webRequest.getAdditionalHeaders());
        AbstractHttpClient httpClient = this.getHttpClient();
        CredentialsProvider credentialsProvider = this.webClient_.getCredentialsProvider();
        Credentials requestUrlCredentials = webRequest.getUrlCredentials();
        if (null != requestUrlCredentials && this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_AUTH_CREDENTIALS)) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestUrlCredentials);
        }
        if (null != (requestCredentials = webRequest.getCredentials())) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestCredentials);
        }
        httpClient.setCredentialsProvider(credentialsProvider);
        if (this.webClient_.getCookieManager().isCookiesEnabled()) {
            httpClient.getParams().setParameter("http.protocol.single-cookie-header", (Object)Boolean.TRUE);
            httpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)HACKED_COOKIE_POLICY);
        } else {
            httpClient.setCookieStore(new CookieStore(){

                public void addCookie(Cookie cookie) {
                }

                public void clear() {
                }

                public boolean clearExpired(Date date) {
                    return false;
                }

                public List<Cookie> getCookies() {
                    return Collections.EMPTY_LIST;
                }
            });
        }
        return httpMethod;
    }

    private Charset getCharset(String charset, List<NameValuePair> pairs) {
        for (NameValuePair pair : pairs) {
            KeyDataPair pairWithFile;
            if (!(pair instanceof KeyDataPair) || (pairWithFile = (KeyDataPair)pair).getData() != null || pairWithFile.getFile() == null) continue;
            String fileName = pairWithFile.getFile().getName();
            for (int i = 0; i < fileName.length(); ++i) {
                if (fileName.codePointAt(i) <= 127) continue;
                return Charset.forName(charset);
            }
        }
        return null;
    }

    ContentBody buildFilePart(final KeyDataPair pairWithFile) {
        String contentType = pairWithFile.getContentType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        File file = pairWithFile.getFile();
        if (pairWithFile.getData() != null) {
            if (file == null) {
                return new InputStreamBody((InputStream)new ByteArrayInputStream(pairWithFile.getData()), contentType, pairWithFile.getValue());
            }
            if (this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HEADER_CONTENT_DISPOSITION_ABSOLUTE_PATH)) {
                return new InputStreamBody((InputStream)new ByteArrayInputStream(pairWithFile.getData()), contentType, file.getAbsolutePath());
            }
            return new InputStreamBody((InputStream)new ByteArrayInputStream(pairWithFile.getData()), contentType, file.getName());
        }
        if (file == null) {
            return new InputStreamBody(new ByteArrayInputStream(new byte[0]), contentType, pairWithFile.getValue()){

                public long getContentLength() {
                    return 0L;
                }
            };
        }
        return new FileBody(pairWithFile.getFile(), contentType){

            public String getFilename() {
                if (this.getFile() == null) {
                    return pairWithFile.getValue();
                }
                if (HttpWebConnection.this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.HEADER_CONTENT_DISPOSITION_ABSOLUTE_PATH)) {
                    return this.getFile().getAbsolutePath();
                }
                return super.getFilename();
            }
        };
    }

    private static HttpRequestBase buildHttpMethod(HttpMethod submitMethod, URI uri) {
        HttpGet method;
        switch (submitMethod) {
            case GET: {
                method = new HttpGet(uri);
                break;
            }
            case POST: {
                method = new HttpPost(uri);
                break;
            }
            case PUT: {
                method = new HttpPut(uri);
                break;
            }
            case DELETE: {
                method = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                method = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                method = new HttpHead(uri);
                break;
            }
            case TRACE: {
                method = new HttpTrace(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Submit method not yet supported: " + (Object)((Object)submitMethod));
            }
        }
        return method;
    }

    protected synchronized AbstractHttpClient getHttpClient() {
        if (this.httpClient_ == null) {
            this.httpClient_ = this.createHttpClient();
            this.httpClient_.getCookieSpecs().register(HACKED_COOKIE_POLICY, this.htmlUnitCookieSpecFactory_);
        }
        return this.httpClient_;
    }

    protected int getTimeout() {
        return this.webClient_.getTimeout();
    }

    protected AbstractHttpClient createHttpClient() {
        BasicHttpParams httpsParams = new BasicHttpParams();
        HttpClientParams.setRedirecting((HttpParams)httpsParams, (boolean)false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(schemeRegistry);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpsParams);
        httpClient.setCookieStore((CookieStore)new HtmlUnitCookieStore());
        httpClient.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return super.isRedirected(request, response, context) && response.getFirstHeader("location") != null;
            }
        });
        if (this.getVirtualHost() != null) {
            httpClient.getParams().setParameter("http.virtual-host", (Object)this.virtualHost_);
        }
        Scheme httpScheme = new Scheme("http", 80, (SchemeSocketFactory)new SocksSocketFactory());
        httpClient.getConnectionManager().getSchemeRegistry().register(httpScheme);
        httpClient.getParams().setParameter("http.socket.timeout", (Object)this.webClient_.getTimeout());
        httpClient.getParams().setParameter("http.connection.timeout", (Object)this.webClient_.getTimeout());
        return httpClient;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost_ = virtualHost;
        if (this.virtualHost_ != null) {
            this.getHttpClient().getParams().setParameter("http.virtual-host", (Object)this.virtualHost_);
        }
    }

    public String getVirtualHost() {
        return this.virtualHost_;
    }

    private WebResponse makeWebResponse(HttpResponse httpResponse, WebRequest request, DownloadedContent responseBody, long loadTime) throws IOException {
        String statusMessage = httpResponse.getStatusLine().getReasonPhrase();
        if (statusMessage == null) {
            statusMessage = "Unknown status message";
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        for (Header header : httpResponse.getAllHeaders()) {
            headers.add(new NameValuePair(header.getName(), header.getValue()));
        }
        WebResponseData responseData = new WebResponseData(responseBody, statusCode, statusMessage, headers);
        return this.newWebResponseInstance(responseData, loadTime, request);
    }

    protected DownloadedContent downloadResponseBody(HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        return HttpWebConnection.downloadContent(httpEntity.getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadedContent downloadContent(InputStream is) throws IOException {
        if (is == null) {
            return new DownloadedContent.InMemory(new byte[0]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int nbRead;
            while ((nbRead = is.read(buffer)) != -1) {
                bos.write(buffer, 0, nbRead);
                if ((long)bos.size() <= 512000L) continue;
                File file = File.createTempFile("htmlunit", ".tmp");
                file.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(file);
                bos.writeTo(fos);
                IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
                fos.close();
                DownloadedContent.OnFile onFile = new DownloadedContent.OnFile(file);
                return onFile;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return new DownloadedContent.InMemory(bos.toByteArray());
    }

    protected WebResponse newWebResponseInstance(WebResponseData responseData, long loadTime, WebRequest request) {
        return new WebResponse(responseData, request, loadTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRequestHeadersToHttpMethod(HttpUriRequest httpMethod, Map<String, String> requestHeaders) {
        Map<String, String> map = requestHeaders;
        synchronized (map) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setUseInsecureSSL(boolean useInsecureSSL) throws GeneralSecurityException {
        HttpWebConnectionInsecureSSL.setUseInsecureSSL(this.getHttpClient(), useInsecureSSL);
    }

    public synchronized void shutdown() {
        if (this.httpClient_ != null) {
            this.httpClient_.getConnectionManager().shutdown();
            this.httpClient_ = null;
        }
    }
}

