/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class TextRange
extends SimpleScriptable {
    private static final long serialVersionUID = -3763822832184277966L;
    private static final Log LOG = LogFactory.getLog(TextRange.class);
    private Range range_;

    public TextRange() {
    }

    public TextRange(HTMLElement elt) {
        this.range_ = new SimpleRange(elt.getDomNodeOrDie());
    }

    public TextRange(Range range) {
        this.range_ = range.cloneRange();
    }

    public String jsxGet_text() {
        return ((Object)this.range_).toString();
    }

    public void jsxSet_text(String text) {
        if (this.range_.getStartContainer() == this.range_.getEndContainer() && this.range_.getStartContainer() instanceof SelectableTextInput) {
            SelectableTextInput input = (SelectableTextInput)this.range_.getStartContainer();
            String oldValue = input.getText();
            input.setText(oldValue.substring(0, input.getSelectionStart()) + text + oldValue.substring(input.getSelectionEnd()));
        }
    }

    public String jsxGet_htmlText() {
        Node node = this.range_.getCommonAncestorContainer();
        HTMLElement element = (HTMLElement)this.getScriptableFor(node);
        return element.jsxGet_outerHTML();
    }

    public Object jsxFunction_duplicate() {
        TextRange range = new TextRange(this.range_.cloneRange());
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype());
        return range;
    }

    public Object jsxFunction_parentElement() {
        Node parent = this.range_.getCommonAncestorContainer();
        return this.getScriptableFor(parent);
    }

    public void jsxFunction_collapse(boolean toStart) {
        this.range_.collapse(toStart);
    }

    public void jsxFunction_select() {
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        page.setSelectionRange(this.range_);
    }

    public int jsxFunction_moveStart(String unit, Object count) {
        if (!"character".equals(unit)) {
            LOG.warn((Object)("moveStart('" + unit + "') is not yet supported"));
            return 0;
        }
        int c = 1;
        if (count != Undefined.instance) {
            c = (int)Context.toNumber((Object)count);
        }
        if (this.range_.getStartContainer() == this.range_.getEndContainer() && this.range_.getStartContainer() instanceof SelectableTextInput) {
            SelectableTextInput input = (SelectableTextInput)this.range_.getStartContainer();
            this.range_.setStart(input, this.range_.getStartOffset() + c);
        }
        return c;
    }

    public int jsxFunction_moveEnd(String unit, Object count) {
        if (!"character".equals(unit)) {
            LOG.warn((Object)("moveEnd('" + unit + "') is not yet supported"));
            return 0;
        }
        int c = 1;
        if (count != Undefined.instance) {
            c = (int)Context.toNumber((Object)count);
        }
        if (this.range_.getStartContainer() == this.range_.getEndContainer() && this.range_.getStartContainer() instanceof SelectableTextInput) {
            SelectableTextInput input = (SelectableTextInput)this.range_.getStartContainer();
            this.range_.setEnd(input, this.range_.getEndOffset() + c);
        }
        return c;
    }

    public void jsxFunction_moveToElementText(HTMLElement element) {
        this.range_.selectNode(element.getDomNodeOrDie());
    }

    public boolean jsxFunction_inRange(TextRange other) {
        boolean startNodeBefore;
        Range otherRange = other.range_;
        Node start = this.range_.getStartContainer();
        Node otherStart = otherRange.getStartContainer();
        if (otherStart == null) {
            return false;
        }
        short startComparison = start.compareDocumentPosition(otherStart);
        boolean bl = startNodeBefore = startComparison == 0 || (startComparison & 8) != 0 || (startComparison & 2) != 0;
        if (startNodeBefore && (start != otherStart || this.range_.getStartOffset() <= otherRange.getStartOffset())) {
            boolean endNodeAfter;
            Node otherEnd;
            Node end = this.range_.getEndContainer();
            short endComparison = end.compareDocumentPosition(otherEnd = otherRange.getEndContainer());
            boolean bl2 = endNodeAfter = endComparison == 0 || (endComparison & 8) != 0 || (endComparison & 4) != 0;
            if (endNodeAfter && (end != otherEnd || this.range_.getEndOffset() >= otherRange.getEndOffset())) {
                return true;
            }
        }
        return false;
    }

    public void jsxFunction_setEndPoint(String type, TextRange other) {
        int offset;
        Node target;
        Range otherRange = other.range_;
        if (type.endsWith("ToStart")) {
            target = otherRange.getStartContainer();
            offset = otherRange.getStartOffset();
        } else {
            target = otherRange.getEndContainer();
            offset = otherRange.getEndOffset();
        }
        if (type.startsWith("Start")) {
            this.range_.setStart(target, offset);
        } else {
            this.range_.setEnd(target, offset);
        }
    }
}

