/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.corejs.javascript.ast;

import net.sourceforge.htmlunit.corejs.javascript.ast.InfixExpression;

public class ObjectProperty
extends InfixExpression {
    public void setNodeType(int nodeType) {
        if (nodeType != 102 && nodeType != 150 && nodeType != 151) {
            throw new IllegalArgumentException("invalid node type: " + nodeType);
        }
        this.setType(nodeType);
    }

    public ObjectProperty() {
        this.type = 102;
    }

    public ObjectProperty(int pos) {
        super(pos);
        this.type = 102;
    }

    public ObjectProperty(int pos, int len) {
        super(pos, len);
        this.type = 102;
    }

    public void setIsGetter() {
        this.type = 150;
    }

    public boolean isGetter() {
        return this.type == 150;
    }

    public void setIsSetter() {
        this.type = 151;
    }

    public boolean isSetter() {
        return this.type == 151;
    }

    public String toSource(int depth) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.makeIndent(depth));
        if (this.isGetter()) {
            sb.append("get ");
        } else if (this.isSetter()) {
            sb.append("set ");
        }
        sb.append(this.left.toSource(0));
        if (this.type == 102) {
            sb.append(": ");
        }
        sb.append(this.right.toSource(0));
        return sb.toString();
    }
}

