use Test::More;

my $c = 'Data::Seek::Exception';
my @a = qw(file line message object package subroutine);
my @m = qw(new to_string);

eval "require $c";

ok !$@ or diag $@;
can_ok $c => ('new', @a, @m);

eval { $c->throw('WTF') };
my $o = $@;
isa_ok $o, $c;
is $o->message, "WTF";

my $exc;

eval { Data::Seek::Exception->throw };
$exc = $@;
is $exc->line, '19';
is $exc->package, 'main';
like $exc->file, qr/t\/data\/seek\/exception\.t/;
is $exc->subroutine, '(eval)';

eval { Data::Seek::Exception->throw(object => 12345) };
$exc = $@;
is $exc->line, '26';
is $exc->object, '12345';
is $exc->package, 'main';
like $exc->file, qr/t\/data\/seek\/exception\.t/;

ok 1 and done_testing;
