package Net::OpenVPN::Manager::Plugin::ChallengeRequire;

use namespace::autoclean;
use Moose;
use Net::OpenVPN::Manager::Plugin;

with 'Net::OpenVPN::Manager::Authenticable';

has '+order' => (
    default => 10,
);

sub authenticate {
    my ($self, $client) = @_;
    my ($password, $challenge) = $client->password;

    $self->log("No static challenge found", $client) unless $challenge;

    return $challenge ? PLUG_NOOP : PLUG_FATAL;
}

__PACKAGE__->meta->make_immutable;

1;

