#  Makefile.PL for WebDyne::State
#
package WebDyne::State;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;



#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				    =>  __PACKAGE__,
    VERSION_FROM			    =>  'VERSION.pm',
    PM					    =>  {
	'State.pm'			    =>  '$(INST_LIBDIR)/State.pm',
	'State_BerkeleyDB.pm'		    =>  '$(INST_LIBDIR)/State/BerkeleyDB.pm',
	'State_BerkeleyDB_Constant.pm'	    =>  '$(INST_LIBDIR)/State/BerkeleyDB/Constant.pm',
	'VERSION.pm'			    =>  '$(INST_LIBDIR)/State/VERSION.pm',
	'LICENSE'			    =>  '$(INST_LIBDIR)/State/LICENSE'
       },


    EXE_FILES                              =>  [

        'support/wdstatebdbdump',
       ],


    'dist'				    =>  {
	COMPRESS			    =>  'gzip -9f',
	SUFFIX				    =>  '.gz'
       },

    'depend'				    =>  {
	Makefile			    =>  '$(VERSION_FROM)'
       },

    'macro'				    =>  {
        COPYRIGHT			    =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				    =>  'GPL: GNU General Public License',
    	statl				    =>  'g',
    },

    ($] >=  5.005 ?
	 (AUTHOR			    => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
	),

);

