package main;
use Evo::Base -strict;
use Promises6 'deferred';
use Test::More 'skip_all';
use Promises6::Util ':const';

my $bldr     = Promises6::Builder->singleton;
my $deferred = $bldr->deferred;
my $F;

my $res;
$deferred->promise->then(sub { Thenable->new })
  ->then(sub { say "$_[0]"; $res = shift });

# already resolved with a promise, so bar is ignored
$deferred->resolve(Thenable->new);
$deferred->resolve('bar');
is $deferred->state, PENDING;
is $res, undef, 'already resolved, second call of resolve is ignored';

$F->('foo');
is $res, 'foo', 'already resolved';

$F->('baz');
is $res, 'foo', 'second call of resolved cb is ignored too';

done_testing;


# thenables thet eventually cause circular recursion
{

  package Thenable;
  use Evo::Base -base;
  sub then { $F = $_[1] }

}

