package main;
use Evo::Base -strict;
use Test::More tests => 1;
use Promises6 'deferred';
use Mojo::IOLoop;

# resolve
my ($count, $d, $err);
$count = 0;
$d     = deferred;
$d->promise->then(sub { ThenableCircularA->single })
  ->then(sub {fail}, sub($r) { $err = $r });

$d->resolve(undef);
like $err, qr/Circular thenable.+ThenableCircularA/, 'right error';

{

  package ThenableCircularA;
  use Mojo::IOLoop;
  sub single { state $o = bless {}, shift }

  sub then {
    $_[1]->(ThenableCircularB->single);
    die "recursion" if ++$count > 1;
  }

  package ThenableCircularB;
  sub single { state $o = bless {}, shift }

  sub then { $_[1]->(ThenableCircularA->single) }

}

