package Evo::Way;
use Evo::Base 'Railway::Way';

has curry => sub { Carp::croak 'build me using a manager and curry' };

sub add($self, $cb) { $self->SUPER::add($self->curry->($cb)) }

sub get($self, $index) {
  my $station = $self->SUPER::get($index);
  $self->stations->[$index] = undef;
  $station;
}

1;

# ABSTRACT: A way, a queue of stations

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Way - A way, a queue of stations

=head1 VERSION

version 0.0160

=head1 SYNOPSIS

  use Evo::Manager;
  my $mngr = Evo::Manager->new;

  my $way = $mngr->build_way;
  $way->add(sub { })->add(sub { });
  my $station = $way->get(0);

=head1 DESCRIPTION

C<Evo::Way> is a subclass of C<Railway::Way>

=head1 ATTRIBUTES

=head2 curry

A function that decorates a station

=head1 METHODS

=head2 get

Get a station and clean it to free a memory

=head2 add

Add a station, wrapped by the L</"curry">

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
