use Evo::Base -strict;
use Benchmark ':all';
use Evo::Guard;
use Test::More;

plan skip_all => 'set TEST_EVO_PERF env to enable this test'
  unless $ENV{TEST_EVO_PERF};

my $EXPECT = 400_000 * $ENV{TEST_EVO_PERF};
my $N      = 1000_000;

my $t = timeit(
  $N,
  sub {
    my $fired;
    my $guard = Evo::Guard->new(error => sub { $fired++ });
    undef $guard;
    die if $fired;
  }
);

diag timestr $t;
my $perf = $N / $t->cpu_a;
ok $perf > $EXPECT, "$perf > $EXPECT";


done_testing;
