package JavaScript::Minifier::XS;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);
our @EXPORT = qw(minify);

our $VERSION = '0.01';

require XSLoader;
XSLoader::load('JavaScript::Minifier::XS', $VERSION);

sub minify {
	my ($input) = @_;
	return minify_internal($input, length($input));
}

1;
__END__

=head1 NAME

JavaScript::Minifier::XS - C version of javascript minification.

=head1 SYNOPSIS

  use File::Slurp;
  use JavaScript::Minifier::XS qw(minify);
  my $javascript_contents = read_file("my-javascript-file.js");
  my $minified_contents = minify($javascript_contents);
  write_file("my-minified-javascript-file.min.js", $minified_contents);

=head1 DESCRIPTION

Minifies javascript. Code taken from here, originaly:
https://github.com/rf-/jsminc/blob/master/ext/jsminc/jsminc.c

Took way too long to minfify larger files with L<JavaScript::Minifier>;
so I decided to write my first perl XS module. This one seems to work
basically instantaneously.

=head1 SEE ALSO

The original L<JavaScript::Minifier>, which I used before this.

=head1 AUTHOR

Adam Harrison, E<lt>adam@eshopadmin.com<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2017 by Adam Harrison

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.0 or,
at your option, any later version of Perl 5 you may have available.


=cut
