package Task::WWW::Pastebin;

use warnings;
use strict;

our $VERSION = '0.002';


1;
__END__

=head1 NAME

Task::WWW::Pastebin - a bundle of WWW::Pastebin::* modules

=head1 BUNDLE CONTENTS

    'WWW::Pastebin::Bot::Pastebot::Create'      => 0.001,
    'WWW::Pastebin::Many::Retrieve'             => 0.002,
    'WWW::Pastebin::NoMorePastingCom::Retrieve' => 0.001,
    'WWW::Pastebin::NoPasteCom::Create'         => 0.0102,
    'WWW::Pastebin::PastebinCa::Create'         => 0.001,
    'WWW::Pastebin::PastebinCa::Retrieve'       => 0.003,
    'WWW::Pastebin::PastebinCom::Create'        => 0.003,
    'WWW::Pastebin::PastebinCom::Retrieve'      => 0.002,
    'WWW::Pastebin::PastieCabooSe::Retrieve'    => 0.001,
    'WWW::Pastebin::PhpfiCom::Create'           => 0.001,
    'WWW::Pastebin::PhpfiCom::Retrieve'         => 0.001,
    'WWW::Pastebin::RafbNet::Create'            => 0.001,
    'WWW::Pastebin::RafbNet::Retrieve'          => 0.001,
    'WWW::Pastebin::UbuntuNlOrg::Retrieve'      => 0.001,

=head1 AUTHOR

Zoffix Znet, C<< <zoffix at cpan.org> >>
(L<http://zoffix.com>, L<http://haslayout.net>,
L<http://mind-power-book.com>)

=head1 BUGS

Please report any bugs or feature requests to C<bug-task-www-pastebin at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-WWW-Pastebin>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Task::WWW::Pastebin

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-WWW-Pastebin>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Task-WWW-Pastebin>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Task-WWW-Pastebin>

=item * Search CPAN

L<http://search.cpan.org/dist/Task-WWW-Pastebin>

=back

=head1 COPYRIGHT & LICENSE

Copyright 2008 Zoffix Znet, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.


=cut

