package Algorithm::Easing::Bounce;

use Moo;

use Math::Trig qw(:pi);

use constant EPSILON => 0.000001;

extends 'Algorithm::Easing::Ease';

use namespace::clean;

sub ease_in  {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    return $c - $self->ease_out($d - $t, 0, $c, $d) + $b;
}

sub ease_out {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    if (($t /= $d) < (1 / 2.75)) {
        return $c * (7.5625 * $t * $t) + $b;
    } elsif ($t < (2 / 2.75)) {
        my $post_fix = $t-=(1.5 / 2.75);
        return $c * (7.5625 * ($post_fix) * $t + 0.75) + $b;
    } elsif ($t < (2.5/2.75)) {
        my $post_fix = $t -= (2.25 / 2.75);
        return $c * (7.5625 * ($post_fix) * $t + 0.9375) + $b;
    } else {
        my $post_fix = $t -= (2.625 / 2.75);
        return $c * (7.5625 * ($post_fix) * $t + 0.984375) + $b;
    }
}

sub ease_both {
    my $self = shift;
    my ($t,$b,$c,$d) = (shift,shift,shift,shift);

    return $b if ($t < EPSILON);
    return $c if ($d < EPSILON);

    if ($t < $d / 2) {
        return $self->ease_in($t * 2, 0, $c, $d) * 0.5 + $b;
    }
    else {
        return $self->ease_out($t * 2 - $d, 0, $c, $d) * 0.5 + $c * 0.5 + $b;
    }
}

1;

__END__
