package Pcore::JS::Generator::Base;

use Pcore -role;

requires qw[as_js];

has id => ( is => 'lazy', isa => Str, init_arg => undef );

sub _build_id {
    my $self = shift;

    state $c = 1;

    my $id = ++$c;

    return $id;
}

sub FREEZE {
    my $self = shift;

    $Pcore::JS::Generator::CACHE->{ $self->id } = $self;

    return $self->id;
}

sub generate_js ( $self, $data ) {
    my $js = P->data->to_json( $data, readable => $Pcore::JS::Generator::READABLE );

    $js->$* =~ s/[(]"Pcore::JS::Generator::[[:alpha:]]+"[)]\[(\d+)\]/$Pcore::JS::Generator::CACHE->{$1}->as_js/smge;

    return $js;
}

1;
__END__
=pod

=encoding utf8

=cut
