package P::Util::File::ChdirGuard;

use P qw(-class);

with qw(P::Core::Guard);

has dir => ( is => 'ro', isa => Str, required => 1 );

no P;

sub ON_DESTROY {
    my $self = shift;

    chdir $self->dir or die;

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    1 │ 31                   │ Documentation::RequirePackageMatchesPodName - Pod NAME on line 35 does not match the package declaration       │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
