package P::Core::Exporter;

# :DEFAULT tag is exported only if used explicitly, or if no other imports specified
# if first tag is negated (!tag) - :DEFAULT will be implied automatically

BEGIN {
    our %EXPORT_PRAGMAS = (
        level  => 1,    # export to specified caller level namespace
        caller => 1,    # export to specified namespace
    );
    our %EXPORT_TAGS = (    #
        DEFAULT => [qw(import)],
    );
}

use P;
use Exporter::Heavy();

sub import {
    my $self = shift;

    {
        no strict qw(refs);

        unless ( ${ $self . '::__EXPORT_CREATED' } ) {
            ${ $self . '::__EXPORT_CREATED' } = 1;

            @{ $self . '::EXPORT' }    = () unless defined *{ $self . '::EXPORT' }{ARRAY};
            @{ $self . '::EXPORT_OK' } = () unless defined *{ $self . '::EXPORT_OK' }{ARRAY};

            if ( *{ $self . '::EXPORT_TAGS' }{HASH} ) {
                push @{ $self . '::EXPORT' }, @{ ${ $self . '::EXPORT_TAGS' }{DEFAULT} } if ${ $self . '::EXPORT_TAGS' }{DEFAULT};

                for my $tag ( keys %{ $self . '::EXPORT_TAGS' } ) {
                    push @{ $self . '::EXPORT_OK' }, @{ ${ $self . '::EXPORT_TAGS' }{$tag} };
                }
            }
        }
    }

    # parse tags and pragmas
    my ( $tags, $pragma ) = P::Core::Exporter::Helper->parse_import( $self, @_ );

    # find caller
    my $caller = $pragma->{caller} // caller( $pragma->{level} // 0 );

    return if $self eq $caller;    # protection from re-export to myself

    Exporter::Heavy::heavy_export( $self, $caller, @{$tags} );

    return;
}

sub unimport {                     ## no critic qw(Subroutines::ProhibitBuiltinHomonyms)
    my $self = shift;

    # parse tags and pragmas
    my ( $tags, $pragma ) = P::Core::Exporter::Helper->parse_import( $self, @_ );

    # find caller
    my $caller = $pragma->{caller} // caller( $pragma->{level} // 0 );

    return if $self eq $caller;    # protection from unimport from mysqlf

    for ( @{ $self . '::EXPORT_OK' } ) {
        delete ${ $caller . '::' }{$_};
    }

    return;
}

package P::Core::Exporter::Helper;

sub parse_import {
    my $self   = shift;
    my $caller = shift;

    my $tags   = [];
    my $pragma = {};

    no strict qw(refs);    ## no critic qw(TestingAndDebugging::ProhibitProlongedStrictureOverride)

    # add default pragmas
    ${ $caller . '::EXPORT_PRAGMAS' }{level}  = 1;
    ${ $caller . '::EXPORT_PRAGMAS' }{caller} = 1;

    while ( my $arg = shift @_ ) {
        if ( $arg =~ /\A-(.+)\z/sm ) {
            die qq{Unknown exporter pragma found "$arg" while importing package "$caller"} if !exists ${ $caller . '::EXPORT_PRAGMAS' }{$1};
            $pragma->{$1} = ${ $caller . '::EXPORT_PRAGMAS' }{$1} ? shift : 1;
        }
        else {
            push @{$tags}, $arg;
        }
    }

    return $tags, $pragma;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    2 │ 66                   │ ValuesAndExpressions::ProhibitNoisyQuotes - Quotes used with a noisy string                                    │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=cut
