package Dist::Zilla::App::Command::cleanall;

use P;
use Dist::Zilla::App qw[-command];

sub abstract ($self) {
    return 'clean all garbage from dist';
}

sub opt_spec ( $self, $app ) {
    return;
}

sub validate_args ( $self, $opt, $args ) {

    # NOTE args is just raw array or params, that not described as options

    die 'no args expected' if $args->@*;

    return;
}

sub execute ( $self, $opt, $args ) {
    my $dirs = [

        # general build
        'blib',

        # Module::Build
        '_build',
    ];

    my $files = [

        # general build
        qw[META.yml MYMETA.json MYMETA.yml],

        # Module::Build
        qw[_build_params Build Build.bat],

        # MakeMaker
        qw[Makefile pm_to_blib],
    ];

    for my $dir ( $dirs->@* ) {
        P->file->rmtree($dir);
    }

    for my $file ( $files->@* ) {
        unlink $file or die qq[Can't unlink "$file"] if -f $file;
    }

    $self->zilla->clean;

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    3 │ 6                    │ NamingConventions::ProhibitAmbiguousNames - Ambiguously named subroutine "abstract"                            │
## ├──────┼──────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
## │    1 │ 1                    │ NamingConventions::Capitalization - Package "Dist::Zilla::App::Command::cleanall" does not start with a upper  │
## │      │                      │ case letter                                                                                                    │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=cut
