package Pcore::Handle::xmpp;

use Pcore -class;
use Net::XMPP;
use Mozilla::CA;

with qw[Pcore::Core::H::Role::Wrapper];

has addr => ( is => 'ro', isa => Str, required => 1 );    # file://<path>, memory:// and temp:// schemes allowed, memory:// and temp:// not shared between processes

sub h_connect ($self) {
    my $uri = P->uri( $self->addr );

    my $h = Net::XMPP::Client->new;

    my $host = exists $uri->query_params->{gtalk} || $uri->host->name eq 'gmail.com' ? 'talk.google.com' : $uri->host->name;

    my $status = $h->Connect(
        hostname       => $host,
        port           => $uri->port || 5222,
        componentname  => $uri->host->name,
        connectiontype => 'tcpip',
        tls            => 1,
        ssl_ca_path    => Mozilla::CA::SSL_ca_file(),
    );

    die 'XMPP connection error' unless $h->Connected;

    my $resource = $uri->username . q[@] . $uri->host->name . ' <' . $uri->username . q[@] . $uri->host->name . q[>];

    my @auth_res = $h->AuthSend(
        username => $uri->username,
        password => $uri->password,
        resource => $resource,
    );

    die 'XMPP authentication error' unless $auth_res[0] eq 'ok';

    return $h;
}

sub h_disconnect ($self) {
    $self->h->Disconnect if ${^GLOBAL_PHASE} ne 'DESTRUCT';

    return;
}

sub sendmsg ( $self, $to, $msg ) {
    $self->h->MessageSend( to => $to, body => $msg );

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    1 │ 1                    │ NamingConventions::Capitalization - Package "Pcore::Handle::xmpp" does not start with a upper case letter      │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Handle::xmpp

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
