package Pcore::WebDriver::Driver::Chrome;

use Pcore -class;

with qw[Pcore::WebDriver::Driver];

# https://sites.google.com/a/chromium.org/chromedriver/capabilities

sub _build_cmd ($self) {
    if ($MSWIN) {
        return [ $ENV->share->get( $MSWIN ? '/bin/webdriver/chromedriver.exe' : '/bin/webdriver/chromedriver-linux-x64' ), "--port=$self->{port}", '--silent' ];
    }
    else {

        # '-n', 20, '-s', q["-fp /usr/share/X11/fonts/misc -screen 0 1024x768x24"]

        return [ 'xvfb-run', '-l', $ENV->share->get('/bin/webdriver/chromedriver-linux-x64'), "--port=$self->{port}", '--silent' ];
    }
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::WebDriver::Driver::Chrome

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
