package Pcore::Handle::Sphinx;

use Pcore qw[-class];

extends qw[Pcore::Handle::MySQL];

has addr => ( is => 'ro', isa => Str, required => 1 );
has '+schema'   => ( required => 0 );
has '+username' => ( required => 0 );
has '+password' => ( required => 0 );

# DBD
sub _build__connection {
    my $self = shift;

    my $attr = P->hash->merge(
        $self->_default_attr,
        {   mysql_enable_utf8    => 1,
            mysql_auto_reconnect => 1
        }
    );

    return [ q[DBI:mysql:database=;host=] . P->uri( $self->addr )->host_port, $self->username, $self->password, $attr ];
}

1;
__END__
