package Pcore::Nginx v1.2.0;

use Pcore -dist, -class, -try;

has data_dir     => ( is => 'ro',   isa => Str, default => "$ENV->{DATA_DIR}" );
has nginx_bin    => ( is => 'lazy', isa => Str, default => 'nginx' );
has nginx_prefix => ( is => 'lazy', isa => Str, default => '/etc/nginx/' );

has conf_dir  => ( is => 'lazy', isa => Str,    init_arg => undef );
has vhost_dir => ( is => 'lazy', isa => Str,    init_arg => undef );
has proc      => ( is => 'ro',   isa => Object, init_arg => undef );

eval {
    require Pcore::GeoIP;
    Pcore::GeoIP->import;
};

sub _build_conf_dir ($self) {
    my $conf_dir = $self->data_dir . 'nginx/';

    P->file->mkpath($conf_dir);

    return $conf_dir;
}

sub _build_vhost_dir ($self) {
    my $vhost_dir = $self->conf_dir . 'vhost/';

    P->file->mkpath($vhost_dir);

    return $vhost_dir;
}

sub run ($self) {
    my $params = {
        pid                => $self->conf_dir . 'nginx.pid',
        mime_types         => $self->conf_dir . 'mime.types',
        error_log          => $self->data_dir . 'nginx-error.log',
        geoip_country_path => $ENV->share->get('/data/geoip_country.dat') // undef,
        geoip_city_path    => $ENV->share->get('/data/geoip_city.dat') // undef,
        vhost_dir          => $self->vhost_dir,
        ssl_dhparam        => $ENV->share->get('/data/nginx/dhparam-4096.pem'),
    };

    my $mime_types = P->cfg->load( $ENV->share->get('data/mime.json') )->{suffix};
    for my $suffix ( keys $mime_types->%* ) {
        $mime_types->{$suffix} = [ $mime_types->{$suffix} ] if ref $mime_types->{$suffix} ne 'ARRAY';
    }

    P->file->write_text( $self->conf_dir . 'mime.types', { mode => q[rw-r--r--] }, P->tmpl( type => 'text' )->render( 'nginx/mime.types', { mime_types => $mime_types } ) );

    P->file->write_text( $self->conf_dir . 'conf.nginx', { mode => q[rw-r--r--] }, P->tmpl( type => 'text' )->render( 'nginx/conf.nginx', $params ) );

    P->file->write_text( $self->conf_dir . 'ssl.nginx', { mode => q[rw-r--r--] }, P->tmpl( type => 'text' )->render( 'nginx/ssl.nginx', $params ) );

    P->pm->run_proc(
        [ $self->nginx_bin, '-c', $self->conf_dir . 'conf.nginx' ],
        on_ready => sub ($proc) {
            $self->{proc} = $proc;

            return;
        }
    );

    return;
}

sub add_vhost ( $self, $name, $cfg ) {
    P->file->write_bin( $self->vhost_dir . "$name.nginx", $cfg );

    return;
}

sub is_vhost_exists ( $self, $name ) {
    return -f $self->vhost_dir . "$name.nginx";
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    3 | 13                   | ErrorHandling::RequireCheckingReturnValueOfEval - Return value of eval not tested                              |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Nginx - Pcore nginx application

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 SEE ALSO

=head1 AUTHOR

zdm <zdm@cpan.org>

=head1 CONTRIBUTORS

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by zdm.

=cut
