Ext.define('Pcore.amcharts.Panel', {
    extend: 'Ext.panel.Panel',

    alias: 'widget.pcore-amchartspanel',

    title: 'AmCharts Panel',

    viewModel: {},

    model: null,
    chartConfig: null,

    defaultListenerScope: true,

    header: {
        items: [{
            xtype: 'tool',
            type: 'refresh',
            tooltip: 'Refresh',
            callback: 'onStoreRefresh',
        }]
    },

    initComponent: function () {
        this.callParent();

        this.getViewModel().setStores({
            store: {
                // autoLoad: true,
                model: Ext.create(this.model),
                listeners: {
                    scope: this,
                    load: 'onStoreLoad'
                }
            }
        });
    },

    onStoreRefresh: function () {
        var store = this.getViewModel().getStore('store');

        store.reload();
    },

    onStoreLoad: function () {
        if (this.chart) {
            var store = this.getViewModel().getStore('store');

            this.chart.dataProvider = Ext.pluck(store.data.items, 'data');

            this.chart.validateData();
        }
    },

    _attachCharts: function () {
        var me = this;

        var urls = [];
        var AmChartsUndefined;

        if (typeof (AmCharts) == 'undefined') {
            AmChartsUndefined = 1;
            AmCharts = {
                themes: {}
            };

            urls.push('/static/amcharts/amcharts.js');
        } else {
            AmChartsUndefined = 0;
        }

        if (this.chartConfig.type == 'serial' && typeof (AmCharts.AmSerialChart) == 'undefined') urls.push('/static/amcharts/serial.js');
        if (this.chartConfig.type == 'pie' && typeof (AmCharts.AmPieChart) == 'undefined') urls.push('/static/amcharts/pie.js');
        if (this.chartConfig.type == 'xy' && typeof (AmCharts.AmXYChart) == 'undefined') urls.push('/static/amcharts/xy.js');
        if (this.chartConfig.type == 'radar' && typeof (AmCharts.AmRadarChart) == 'undefined') urls.push('/static/amcharts/radar.js');
        if (this.chartConfig.type == 'funnel' && typeof (AmCharts.AmFunnelChart) == 'undefined') urls.push('/static/amcharts/funnel.js');
        if (this.chartConfig.type == 'gauge' && typeof (AmCharts.GaugeAxis) == 'undefined') urls.push('/static/amcharts/gauge.js');
        if (this.chartConfig.type == 'map' && typeof (AmCharts.AmMap) == 'undefined') urls.push('/static/ammap/ammap_amcharts_extension.js');
        if (this.chartConfig.type == 'stock' && typeof (AmCharts.AmStockChart) == 'undefined') urls.push('/static/amcharts/stock.js');

        if (this.chartConfig.theme == 'black' && typeof (AmCharts.themes.black) == 'undefined') urls.push('/static/amcharts/themes/black.js');
        if (this.chartConfig.theme == 'chalk' && typeof (AmCharts.themes.chalk) == 'undefined') urls.push('/static/amcharts/themes/chalk.js');
        if (this.chartConfig.theme == 'dark' && typeof (AmCharts.themes.dark) == 'undefined') urls.push('/static/amcharts/themes/dark.js');
        if (this.chartConfig.theme == 'light' && typeof (AmCharts.themes.light) == 'undefined') urls.push('/static/amcharts/themes/light.js');
        if (this.chartConfig.theme == 'patterns' && typeof (AmCharts.themes.patterns) == 'undefined') urls.push('/static/amcharts/themes/patterns.js');

        if (AmChartsUndefined) AmCharts = undefined;

        if (urls.length) {
            Ext.Loader.loadScripts({
                url: urls,
                cache: true,
                onLoad: function () {
                    AmCharts.AmChart.prototype.brr = function () {};

                    me._renderCharts();
                }
            });
        } else {
            this._renderCharts();
        }
    },

    _renderCharts: function () {
        this.chart = AmCharts.makeChart(this.getTargetEl().dom, this.chartConfig);

        this.chart.write(this.getTargetEl().dom);
    },

    listeners: {
        afterrender: function (me) {
            me._attachCharts();
        },
        resize: function () {
            if (this.chart) this.chart.invalidateSize();
        },
    }
});
