package Pcore::Ext::Class::Grid;

use Pcore;

our $EXT_MAP = {    #
    controller => 'Pcore::Ext::Class::Controller::controller',
};

sub EXT_controller ($ext) {
    return {
        createRecord => $ext->js_func(
            <<'JS'
                var model = this.getViewModel().getStore('store').createModel({});

                var formPanel = this._createFormPanel(this.getView().createFormPanelClass, model);

                formPanel.on('recordUpdated', function (record) {
                    var store = this.getViewModel().get('store');

                    store.addSorted(record);

                    store.commitChanges();

                    this.fireViewEvent('recordUpdated', this, record);
                }, this);

                formPanel.on('beforeDestroy', function () {
                    this.getView().setActiveItem('grid');

                    this.getViewModel().set('editModel', null);
                }, this);

                this.getView().setActiveItem(formPanel);
JS
        ),

        editRecord => $ext->js_func(
            ['model'], <<'JS'
                model.load({
                    scope: this,
                    success: function (record, operation) {
                        var formPanel = this._createFormPanel(this.getView().updateFormPanelClass, record);

                        formPanel.on('recordUpdated', function (record) {
                            this.fireViewEvent('recordUpdated', this, record);
                        }, this);

                        formPanel.on('beforeDestroy', function () {
                            this.getView().setActiveItem('grid');

                            this.getViewModel().set('editModel', null);
                        }, this);

                        this.getView().setActiveItem(formPanel);
                    },
                });
JS
        ),

        reloadStore => $ext->js_func(
            <<'JS'
                this.getViewModel().getStore('store').reload();
JS
        ),

        deleteRecords => $ext->js_func(
            ['records'], <<'JS'
                Ext.Msg.confirm('Confirm deletion', 'Are you sure to delete selected records?', function (result) {
                    if (result == 'yes') {
                        var store = this.getViewModel().getStore('store');

                        var operation = store.getModel().getProxy().createOperation('destroy', {
                            records: records,
                            callback: function (records, operation, success) {
                                if (success) {
                                    store.beginUpdate();

                                    store.remove(records);

                                    store.commitChanges();

                                    store.endUpdate();
                                }
                            }
                        });

                        operation.execute();
                    }
                }, this);
JS
        ),

        deleteSelectedRecords => $ext->js_func(
            <<'JS'
                var selectedRecords = this.getView().getLayout().getActiveItem().getSelection();

                this.deleteRecords(selectedRecords);
JS
        ),

        onRecordDblClick => $ext->js_func(
            [ 'grid', 'model', 'tr', 'rowIndex', 'e', 'eOpts' ], <<'JS'
                this.editRecord(model);
JS
        )
    };
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Ext::Class::Grid

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
