package Pcore::Ext v0.1.0;

use Pcore -dist;
use Pcore::Ext::Context;
use JavaScript::Packer;

our $SCANNED;

our $NS = 'Pcore.';

our $CFG = {
    app        => undef,
    class      => undef,
    perl_class => undef,
};

our $EXT = P->cfg->load( $ENV->share->get('/data/ext-v6.2.0.json') );

sub SCAN ( $self, $app, $framework ) {
    return if $SCANNED;

    $SCANNED = 1;

    my $namespaces;

    my $root_namespace = ref($app) . '::Ext';
    my $root_path      = $root_namespace =~ s[::][/]smgr;

    for my $path ( grep { !ref } @INC ) {

        # scan Pcore::Ext::Class::
        if ( -d "$path/Pcore/Ext/Class/" ) {
            P->file->find(
                "$path/Pcore/Ext/Class/",
                abs => 0,
                dir => 0,
                sub ($path) {
                    if ( $path->suffix eq 'pm' ) {
                        my $class_name = $path =~ s/[.]pm\z//smgr =~ s[/][::]smrg;

                        $namespaces->{"Pcore::Ext::Class\::$class_name"} = {
                            is_app   => 0,
                            app_name => undef,
                        };
                    }

                    return;
                }
            );
        }

        # scan root namespace
        if ( -d "$path/$root_path/" ) {
            P->file->find(
                "$path/$root_path/",
                abs => 0,
                dir => 0,
                sub ($path) {
                    if ( $path->suffix eq 'pm' ) {
                        my $class_name = $path =~ s/[.]pm\z//smgr =~ s[/][::]smrg;

                        # register Ext app
                        if ( $class_name !~ /::/sm ) {
                            $namespaces->{"$root_namespace\::$class_name"} = {
                                is_app   => 1,
                                app_name => $class_name,
                            };

                            $CFG->{app}->{$class_name} = { namespace => "$root_namespace\::$class_name" };
                        }

                        # register Ext class
                        else {
                            my $ext_app_name = $class_name =~ s/::.*//smr;

                            $namespaces->{"$root_namespace\::$class_name"} = {
                                is_app   => 0,
                                app_name => $ext_app_name,
                            };
                        }
                    }

                    return;
                }
            );
        }
    }

    for my $namespace ( keys $namespaces->%* ) {
        P->class->load($namespace);

        # get EXT MAP
        my ( $ext_map, $ext_api_ver ) = do {
            no strict qw[refs];

            ( ${"$namespace\::EXT_MAP"}, ${"$namespace\::EXT_API_VER"} );
        };

        die qq[\$EXT_MAP is not definde in "$namespace"] if !defined $ext_map;

        # configure namespace
        my $namespace_cfg = $namespaces->{$namespace};

        # this is Ext app namespace
        if ( $namespace_cfg->{is_app} ) {

            # store api_ver in app cfg
            $CFG->{app}->{ $namespace_cfg->{app_name} }->{api_ver} = $ext_api_ver;

            # check, that viewport defined for Ext app
            die qq[Ext app "$namespace" requires viewport to be defined] if !$ext_map->{viewport};

            # store vireport class
            $CFG->{app}->{ $namespace_cfg->{app_name} }->{viewport} = "${NS}${namespace}Viewport" =~ s/:://smgr;
        }
        else {

            # resolve app_namespace by app_name
            if ( $namespace_cfg->{app_name} ) {
                $namespace_cfg->{app_namespace} = $CFG->{app}->{ $namespace_cfg->{app_name} }->{namespace};

                undef $namespace_cfg->{app_name} if !$namespace_cfg->{app_namespace};
            }
        }

        for my $class ( keys $ext_map->%* ) {

            # check, that generator method is present
            my $method = 'EXT_' . $class;

            die qq[method "$method" is required but not defined in "$namespace"] if !$namespace->can($method);

            my $class_name = ucfirst $class;

            my $ext_class = "${NS}${namespace}${class_name}" =~ s/:://smgr;

            $CFG->{class}->{$ext_class} = {
                class         => $ext_class,
                namespace     => $namespace,
                api_ver       => $ext_api_ver,
                app_namespace => $namespace_cfg->{app_namespace},
                app_name      => $namespace_cfg->{app_name},
                generator     => $class,
                extend        => $ext_map->{$class},
            };

            $CFG->{perl_class}->{"$namespace::$class"} = $ext_class;
        }
    }

    # second pass, set app namespaces, set ext version, create aliases
    for my $class ( values $CFG->{class}->%* ) {

        # try to inherit api_ver from app
        if ( !$class->{api_ver} && $class->{app_name} ) {
            $class->{api_ver} = $CFG->{app}->{ $class->{app_name} }->{api_ver};
        }

        next if !$class->{extend};

        my $ctx = $self->_get_ctx( $class->{class}, $app, $framework );

        my $extend = $ctx->get_class( $class->{extend} );

        die qq[Can't resolve Ext extend "$class->{extend}" in "$class->{namespace}::$class->{generator}"] if !$extend;

        next if !$extend->{alias};

        # extract type from alias, alias_namespace.type
        $class->{alias_namespace} = $extend->{alias_namespace};

        $class->{type} = lc "${NS}$class->{namespace}.$class->{generator}" =~ s/([.]|::)/-/smgr;

        $class->{alias} = "$extend->{alias_namespace}.$class->{type}";
    }

    # generate content
    my $js_packer = JavaScript::Packer->init;

    for my $class ( values $CFG->{class}->%* ) {
        my $ctx = $self->_get_ctx( $class->{class}, $app, $framework );

        $ctx->to_js;

        $js_packer->minify( $ctx->{ctx}->{js}, { compress => 'obfuscate' } ) if !$app->{devel};    # clean
    }

    # build apps content
    if ( !$app->{devel} ) {
        for my $app ( values $CFG->{app}->%* ) {

            # TODO add requires, add app classes

            $app->{js} = \join ';', map { $_->{js}->$* } grep { $_->{app_namespace} // q[] eq $app->{namespace} } values $CFG->{class}->%*;
        }
    }

    return;
}

sub _get_ctx ( $self, $class, $app, $framework ) {
    my $ctx = $CFG->{class}->{$class};

    return if !$ctx;

    return bless { ctx => $ctx, framework => $framework, app => $app }, 'Pcore::Ext::Context';
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    3 | 19                   | Subroutines::ProhibitExcessComplexity - Subroutine "SCAN" with high complexity score (28)                      |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Ext

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
