package Pcore::API::Whois::Response;

use Pcore -class, -const, -export => { CONST => [qw[$WHOIS_FOUND $WHOIS_NOT_FOUND $WHOIS_NETWORK_ERROR $WHOIS_NO_CONTENT $WHOIS_BANNED $WHOIS_UNKNOWN $WHOIS_NOT_SUPPORTED]] };

extends qw[Pcore::API::Response];

has content => ( is => 'ro', isa => ScalarRef );

const our $WHOIS_FOUND         => 200;    # NOT available for registration
const our $WHOIS_NOT_FOUND     => 201;    # available for registration
const our $WHOIS_NETWORK_ERROR => 500;    # network error
const our $WHOIS_NO_CONTENT    => 501;    # no content
const our $WHOIS_BANNED        => 502;    # IP addr. is banned
const our $WHOIS_UNKNOWN       => 503;    # unknown response type
const our $WHOIS_NOT_SUPPORTED => 504;    # pub. suffix is not supported

# TODO status => resaon hash
# TODO stabdard API response status <=> reason resolver

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::API::Whois::Response

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
