package Pcore::API::Majestic v0.3.0;

use Pcore -dist, -class, -const, -export => { CONST => [qw[$MAJESTIC_INDEX_FRESH $MAJESTIC_INDEX_HISTORIC]] };
use Pcore::API::Response;

const our $MAJESTIC_INDEX_FRESH    => 1;
const our $MAJESTIC_INDEX_HISTORIC => 2;

has api_key              => ( is => 'ro', isa => Maybe [Str] );
has openapp_key          => ( is => 'ro', isa => Maybe [Str] );
has openapp_access_token => ( is => 'ro', isa => Maybe [Str] );
has bind_ip              => ( is => 'ro', isa => Maybe [Str] );

sub get_index_item_info ( $self, $domains, $datasource, $failover, $cb ) {
    die q[Maximum items number is 100] if $domains->@* > 100;

    my $url_params = {
        cmd                        => 'GetIndexItemInfo',
        datasource                 => $datasource == $MAJESTIC_INDEX_FRESH ? 'fresh' : 'historic',
        EnableResourceUnitFailover => $failover,
        items                      => scalar $domains->@*,
    };

    if ( $self->api_key ) {
        $url_params->{app_api_key} = $self->api_key;
    }
    elsif ( $self->openapp_key && $self->openapp_access_token ) {
        $url_params->{privatekey} = $self->openapp_key;

        $url_params->{accesstoken} = $self->openapp_access_token;
    }
    else {
        die q["app_api_key" or "openapp_key" and "openapp_access_token" are missed];
    }

    for my $i ( 0 .. $domains->$#* ) {
        $url_params->{ 'item' . $i } = $domains->[$i];
    }

    my $url = 'http://api.majestic.com/api/json?' . P->data->to_uri($url_params);

    P->http->get(
        $url,
        timeout   => 180,
        bind_ip   => $self->bind_ip,
        on_finish => sub ($res) {
            my $api_res;

            if ( $res->status != 200 ) {
                $api_res = Pcore::API::Response->new( { status => $res->status, reason => $res->reason } );
            }
            else {
                my $json = eval { P->data->from_json( $res->body->$* ); };

                if ($@) {
                    $api_res = Pcore::API::Response->new( { status => 999, reason => 'Invalid JSON body' } );
                }
                elsif ( $json->{Code} ne 'OK' ) {
                    $api_res = Pcore::API::Response->new( { status => 999, reason => $json->{ErrorMessage} } );
                }
                else {
                    $api_res = Pcore::API::Response->new( { status => 200 } );

                    for my $item ( $json->{DataTables}->{Results}->{Data}->@* ) {
                        $api_res->{result}->{ $domains->[ $item->{ItemNum} ] } = $item;
                    }
                }
            }

            $cb->($api_res);

            return;
        },
    );

    return;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::API::Majestic

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
