package WWW::Streamripper::WebUI;

use strict;


require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(install);


use IO::All;
use Archive::Tar;

sub tarball { '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' }

sub install {
    (my $cont = tarball) =~ s/(..)/chr hex($1)/eg;
    io("./webui.tar.gz")->print($cont);
    Archive::Tar->extract_archive("./webui.tar.gz");
    unlink "./webui.tar.gz";
    chmod 0777, qw(config mp3 mp3/incomplete run);
    chmod 0755, qw(bin/get_streams.pl);
    chmod 0666, qw(config/stream_schedule config/stream_source);
    print "WWW::Streamripper::WebUI is Installed.\n";
}




1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

WWW::Streamripper::WebUI - WWW interface for streamripper

=head1 INSTALLATION

 mkdir ~/htdocs/streamripper
 cd ~/htdocs/streamripper
 perl -MWWW::Streamripper::WebUI -e 'install'


=head1 SEE ALSO

L<http://streamripper.sourceforge.net/>. Please have it installed first.

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2004 by Yung-chung Lin (a.k.a. xern) <xern@cpan.org> This package is free software; you can redistribute it and/or modify it under the same terms as Perl itself

=cut
