package Lingua::StopWords::RU;

use strict;
use warnings;

use utf8;

use Encode qw(encode);

use Exporter;
our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw( getStopWords ) ] );
our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
our $VERSION = 0.10;

sub getStopWords {
    if ( @_ and $_[0] eq 'UTF-8' ) {
        my %stoplist = map { ( $_, 1 ) } _stopwords();
        return \%stoplist;
    }
    else {
        my %stoplist = map { ( encode("KOI8-R", $_), 1 ) } _stopwords();
        return \%stoplist;
    }
}

sub _stopwords {
    return qw(
            и в во не что он на я с со как а то все она так его но да ты к
            у же вы за бы по только ее мне было вот от меня еще нет о из
            ему теперь когда даже ну вдруг ли если уже или ни быть был него
            до вас нибудь опять уж вам сказал ведь там потом себя ничего ей
            может они тут где есть надо ней для мы тебя их чем была сам
            чтоб без будто человек чего раз тоже себе под жизнь будет ж
            тогда кто этот говорил того потому этого какой совсем ним здесь
            этом один почти мой тем чтобы нее кажется сейчас были куда
            зачем сказать всех никогда сегодня можно при наконец два об
            другой хоть после над больше тот через эти нас про всего них
            какая много разве сказала три эту моя впрочем хорошо свою этой
            перед иногда лучше чуть том нельзя такой им более всегда
            конечно всю между
    );
}

1;
