use v6;

use XML::Parser::Tiny;

subset TableTag of Str where 'Table';
subset IgnoredTag of Str where 'Head'|'Body'|'TD'|'TH'|'P';
subset Table of Str where 'Table';

multi sub grok(Str $_) { .trim }

multi sub grok(IgnoredTag :$name!, :@data!, :attr($)) {
    [ @data.map({grok(|$_)}) ];
}

sub elem(Str $tag, @data) {
    @data.map(*.{$tag}).grep: *.defined;
}

sub tidy($_) {
    .[0].Str.trim.subst("\n", ' ', :g).subst(/\s+/, ' ', :g)
}

multi sub grok(TableTag :$name!, :@data!, :attr($)) {
    my @content = @data.map({grok(|$_)});
    my $head = elem('THead', @content);
    my $body = elem('TBody', @content);
    my $caption = .[0] with elem('Caption', @content);

    my @rows = $body[0].map: *.<TR>;

    note "Building $*role-name";
    {
        say 'use v6;';
        say "# generated by: $*PROGRAM-NAME {@*ARGS}";
        say '';
        say "#| PDF 32000-1:2008 " ~ tidy($_) with $caption;
        say "role $*role-name \{";
        my @pod;
        for @rows {
            my $entry = .shift[0];
            next if $entry ~~ Pair;
            next if $entry ~~ /:i'other'|'any'/;
            my $type = .shift;
            $type = .shift if $type[0] ~~ Pair;
            $_ =  tidy($_) with $type;
            my @desc = .grep({.[0] !~~ Pair}).map({.Str.subst(/[\n|\s]+/, ' ', :g)
                              .subst(/«'shall be'»/, 'is', :g)
                             });
            $entry ~~ s:s/ '(' .* ')'//;
            @pod.push: %( :$entry, :$type, :@desc );

            if $entry ~~ /:s^ <ident> $/ {
                say "    method $entry \{...\};";
            }
            else {
                say "    \$?ROLE.^add_method({$entry.perl}, method \{...\});";
            }
        }

        # 2nd pass. output POD
        if @pod {
            say '';
            say '=begin pod';
            say '';
            say '=head1 Methods (Entries)';

            for @pod -> % ( :$entry!, :$type, :@desc ) {
                say '';
                my $para = @desc.join: "\n";
                say "=head2 $entry [$type]";
                say "- $para";
            }
            say '';
            say '=end pod';
        }
        say '}';
    }
}

multi sub grok(Str :$name!, :@data, :attr($)) {
    $name => [ @data.map: {|grok(|$_)} ];
}

# Build.pm can also be run standalone 
sub MAIN(IO() $html-table, Str :$*role-name!) {
    my XML::Parser::Tiny $parser .= new;
    my $ast = $parser.parse($html-table.slurp);
    grok( |$ast<body>);
}
