#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/TextTempalerTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Role-TextTemplater.
#
#   perl-Dist-Zilla-Role-TextTemplater is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the Free Software Foundation,
#   either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Role-TextTemplater is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
#   PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Role-TextTemplater. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package TextTemplaterTester;

#   The test is written using `Moose`-based `Test::Routine`. It is not big deal, because we are
#   testing plugin for `Dist::Zilla`, and `Dist-Zilla` is also `Moose`-based.

use autodie ':all';
use namespace::autoclean;

use Test::Routine;

with 'PluginTester';

use Test::More;
use Test::Deep qw{ cmp_deeply };

has text => (
    is          => 'ro',
    isa         => 'ArrayRef[Str]',
    default     => sub { [] },
);

has delimiters => (
    is          => 'ro',
    isa         => 'Str',
);

has package => (
    is          => 'ro',
    isa         => 'Str',
);

has prepend => (
    is          => 'ro',
    isa         => 'ArrayRef[Str]',
    default     => sub { [] },
);

has exp_text => (
    is          => 'ro',
    isa         => 'ArrayRef[Str]',
    default     => sub { [] },
);

sub build_plugin { '=TextTemplaterTestPlugin' };

sub build_ini_body {
    my ( $self ) = @_;
    return [
        'GatherDir',
        [ $self->plugin, {
            'text' => $self->text,
            $self->delimiters   ? ( delimiters => $self->delimiters ) : (),
            $self->package      ? ( package    => $self->package    ) : (),
            @{ $self->prepend } ? ( prepend    => $self->prepend    ) : (),
        } ]
    ];
};

before anno => sub {
    my ( $self ) = @_;
    my $in = $self->text;
    diag( "Template:\n" . join( "\n", @$in ) . "\n(end)" );
    if ( not $self->has_exception ) {
        my $out = $self->tzil->plugin_named( $self->plugin )->text;
        diag( "Output text:\n" . join( "\n", @$out ) . "\n(end)" );
    };
};

test 'check text' => sub {
    my ( $self ) = @_;
    if ( defined( $self->exp_exception ) ) {
        plan skip_all => 'build must fail — no need to check text';
    };
    plan tests => 1;
    my $plugin = $self->tzil->plugin_named( $self->plugin );
    cmp_deeply( $plugin->text, $self->exp_text, 'text' );
    done_testing;
};

1;

# end of file #
