#!/usr/bin/perl

package eBay::API::XML::DataType::ProductFinderConstraintType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ProductFinderConstraintType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ProductFinderConstraintType

=head1 DESCRIPTION

An attribute (constraint) that was specified in a search request that was
based on a product finder query. Used to help you map each query in a batch
request to the corresponding search result in the response.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ProductFinderConstraintType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'DisplayName', 'xs:string', '', '', '' ]
	, [ 'DisplayValue', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDisplayName()

The search attribute name (e.g., Manufacturer).

#    Argument: 'xs:string'

=cut

sub setDisplayName {
  my $self = shift;
  $self->{'DisplayName'} = shift
}

=head2 getDisplayName()

  Calls: GetProductSearchResults
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDisplayName {
  my $self = shift;
  return $self->{'DisplayName'};
}


=head2 setDisplayValue()

The search attribute value the user specified in the query
(e.g., the actual name the user chose for the manufacturer).

#    Argument: 'xs:string'

=cut

sub setDisplayValue {
  my $self = shift;
  $self->{'DisplayValue'} = shift
}

=head2 getDisplayValue()

  Calls: GetProductSearchResults
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDisplayValue {
  my $self = shift;
  return $self->{'DisplayValue'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
