#!/usr/bin/perl

package eBay::API::XML::DataType::ProductArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ProductArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ProductArrayType

=head1 DESCRIPTION

Container for a list of eBay Express products. Can contain zero, one, or multiple
ExpressProductType objects, each of which conveys the data for one product.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ProductArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ExpressProductType;


my @gaProperties = ( [ 'Product', 'ns:ExpressProductType', '1'
	     ,'eBay::API::XML::DataType::ExpressProductType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setProduct()

Contains the data properties that define one eBay catalog product that matches the request, if any.
GetSearchResultsExpress only returns products when matching products are found.
For each product, the set of fields returned is controlled by the value of ProductDetails in the request.
Multiple Product nodes can be returned (up to the amount specified in EntriesPerPage).

#    Argument: reference to an array  
                      of 'ns:ExpressProductType'

=cut

sub setProduct {
  my $self = shift;
  $self->{'Product'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getProduct()

  Calls: GetSearchResultsExpress
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:ExpressProductType'

=cut

sub getProduct {
  my $self = shift;
  return $self->_getDataTypeArray('Product');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
