/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.unify;

import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import opennlp.common.unify.FeatureStructure;
import opennlp.common.unify.Substitution;
import opennlp.common.unify.Unifiable;
import opennlp.common.unify.Unifier;
import opennlp.common.unify.UnifyFailure;
import opennlp.common.unify.Variable;
import opennlp.common.util.FilterFcn;
import opennlp.hylo.HyloHelper;
import org.jdom.Element;

public class GFeatStruc
extends THashMap
implements FeatureStructure {
    boolean _empty = true;
    int _index = 0;
    int _inheritorId = 0;
    TIntObjectHashMap _featureIndices = new TIntObjectHashMap();

    public GFeatStruc() {
        super(3);
    }

    public GFeatStruc(int i) {
        super(i);
    }

    public GFeatStruc(Element fsEl) {
        super(fsEl.getChildren().size());
        List feats;
        String inherit;
        String index = fsEl.getAttributeValue("id");
        if (index != null) {
            this._index = Integer.parseInt(index);
        }
        if ((inherit = fsEl.getAttributeValue("inheritorId")) != null) {
            this._inheritorId = Integer.parseInt(inherit);
        }
        if ((feats = fsEl.getChildren()).size() == 0) {
            this.setFeature(fsEl);
        } else {
            Iterator featIt = feats.iterator();
            while (featIt.hasNext()) {
                this.setFeature((Element)featIt.next());
            }
        }
    }

    public void setFeature(String attribute, Object val) {
        this.put(attribute, val);
        this._empty = false;
    }

    private void setFeature(Element e) {
        String attr = e.getAttributeValue("a");
        if (attr == null) {
            return;
        }
        String val = e.getAttributeValue("v");
        String value = val != null ? val : HyloHelper.getLF((Element)((Element)e.getChildren().get(0)));
        this.setFeature(attr, value);
    }

    public Object getValue(String attribute) {
        return this.get(attribute);
    }

    public boolean hasAttribute(String attribute) {
        return this.containsKey(attribute);
    }

    public boolean attributeHasValue(String attribute, Object val) {
        return val.equals(this.getValue(attribute));
    }

    public Set getAttributes() {
        return this.keySet();
    }

    public void clear() {
        this.clear();
        this._empty = true;
    }

    public boolean equals(FeatureStructure fs) {
        Set atts2;
        if (!(fs instanceof GFeatStruc)) {
            return false;
        }
        GFeatStruc bfs = (GFeatStruc)fs;
        if (this.size() != bfs.size()) {
            return false;
        }
        Set atts1 = this.getAttributes();
        if (atts1.containsAll(atts2 = bfs.getAttributes()) && atts2.containsAll(atts1)) {
            Iterator i1 = atts1.iterator();
            while (i1.hasNext()) {
                String a1 = (String)i1.next();
                boolean foundA1 = false;
                Iterator i2 = atts2.iterator();
                while (!foundA1 && i2.hasNext()) {
                    String a2 = (String)i2.next();
                    if (!a1.equals(a2)) continue;
                    if (!this.getValue(a1).equals(bfs.getValue(a2))) {
                        return false;
                    }
                    foundA1 = true;
                }
            }
            return true;
        }
        return false;
    }

    public FeatureStructure copy() {
        GFeatStruc $fs = new GFeatStruc(this.size());
        $fs.setIndex(this._index);
        $fs.setInheritorIndex(this._inheritorId);
        Iterator i = this.getAttributes().iterator();
        while (i.hasNext()) {
            String a = (String)i.next();
            $fs.setFeature(a, this.getValue(a));
        }
        return $fs;
    }

    public FeatureStructure filter(FilterFcn ff) {
        GFeatStruc $fs = new GFeatStruc(this.size());
        Iterator i = this.getAttributes().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!ff.filter(key)) continue;
            $fs.setFeature(key, this.getValue(key));
        }
        return $fs;
    }

    public boolean contains(FeatureStructure fs) {
        Set atts2;
        if (this.size() < fs.size()) {
            return false;
        }
        Set atts1 = this.getAttributes();
        if (atts1.containsAll(atts2 = fs.getAttributes())) {
            Iterator i2 = atts2.iterator();
            while (i2.hasNext()) {
                String a2 = (String)i2.next();
                boolean foundA2 = false;
                Iterator i1 = atts1.iterator();
                while (!foundA2 && i1.hasNext()) {
                    String a1 = (String)i1.next();
                    if (!a1.equals(a2)) continue;
                    if (!this.getValue(a1).equals(fs.getValue(a2))) {
                        return false;
                    }
                    foundA2 = true;
                }
            }
            return true;
        }
        return false;
    }

    public boolean occurs(Variable v) {
        Iterator i = this.values().iterator();
        while (i.hasNext()) {
            Object $_ = i.next();
            if (!($_ instanceof Unifiable) || !((Unifiable)$_).occurs(v)) continue;
            return true;
        }
        return false;
    }

    public void unifyCheck(Object u) throws UnifyFailure {
        if (!(u instanceof FeatureStructure)) {
            throw new UnifyFailure();
        }
    }

    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (!(u instanceof FeatureStructure)) {
            throw new UnifyFailure();
        }
        FeatureStructure fs2 = (FeatureStructure)u;
        GFeatStruc $fs = new GFeatStruc(this.size());
        Set keys1 = this.getAttributes();
        Set keys2 = fs2.getAttributes();
        Iterator i1 = keys1.iterator();
        while (i1.hasNext()) {
            String k1 = (String)i1.next();
            Object val1 = this.getValue(k1);
            boolean foundK1 = false;
            Iterator i2 = keys2.iterator();
            while (!foundK1 && i2.hasNext()) {
                String k2 = (String)i2.next();
                if (!k1.equals(k2)) continue;
                foundK1 = true;
                Object val2 = fs2.getValue(k2);
                $fs.setFeature(k1, Unifier.unify((Object)val1, (Object)val2, (Substitution)sub));
            }
            if (foundK1) continue;
            $fs.setFeature(k1, val1);
        }
        Iterator i2 = keys2.iterator();
        while (i2.hasNext()) {
            String k2 = (String)i2.next();
            if (keys1.contains(k2)) continue;
            $fs.setFeature(k2, fs2.getValue(k2));
        }
        if (this._index > 0) {
            $fs.setIndex(this._index);
        } else {
            $fs.setIndex(fs2.getIndex());
        }
        if (this._inheritorId > 0) {
            $fs.setInheritorIndex(this._inheritorId);
        } else {
            $fs.setInheritorIndex(fs2.getInheritorIndex());
        }
        return $fs;
    }

    public Object fill(Substitution sub) {
        return this.copy();
    }

    public FeatureStructure inherit(FeatureStructure fs) {
        Iterator i = fs.getAttributes().iterator();
        while (i.hasNext()) {
            String a = (String)i.next();
            if (this.hasAttribute(a)) continue;
            this.setFeature(a, fs.getValue(a));
        }
        return this;
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public int getInheritorIndex() {
        return this._inheritorId;
    }

    public void setInheritorIndex(int inheritorId) {
        this._inheritorId = inheritorId;
    }

    public String toString() {
        if (this._empty) {
            return "";
        }
        StringBuffer sb = new StringBuffer(this.size() * 4);
        sb.append('{');
        Iterator i = this.keySet().iterator();
        int size = this.size();
        while (--size > 0) {
            String k = (String)i.next();
            sb.append(k).append('=').append(this.getValue(k).toString()).append(", ");
        }
        String lastKey = (String)i.next();
        sb.append(lastKey).append('=').append(this.getValue(lastKey).toString()).append('}');
        return sb.toString();
    }
}

