/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.symbol;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.function.Modifiable;
import org.maltparser.core.feature.value.FeatureValue;
import org.maltparser.core.feature.value.SingleFeatureValue;
import org.maltparser.core.symbol.SymbolTable;
import org.maltparser.core.symbol.SymbolTableHandler;
import org.maltparser.core.symbol.nullvalue.NullValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableFeature
implements FeatureFunction,
Modifiable {
    protected SingleFeatureValue featureValue = new SingleFeatureValue(this);
    protected SymbolTable table;
    protected String tableName;
    protected SymbolTableHandler tableHandler;

    @Override
    public abstract void update() throws MaltChainedException;

    @Override
    public abstract void initialize(Object[] var1) throws MaltChainedException;

    @Override
    public abstract Class<?>[] getParameterTypes();

    @Override
    public String getSymbol(int value) throws MaltChainedException {
        return this.table.getSymbolCodeToString(value);
    }

    @Override
    public int getCode(String value) throws MaltChainedException {
        return this.table.getSymbolStringToCode(value);
    }

    @Override
    public SymbolTable getSymbolTable() {
        return this.table;
    }

    public void setSymbolTable(SymbolTable table) {
        this.table = table;
    }

    @Override
    public void updateCardinality() {
        if (this.table != null) {
            this.featureValue.setCardinality(this.table.getValueCounter());
        } else {
            this.featureValue.setCardinality(0);
        }
    }

    @Override
    public void setFeatureValue(int value) throws MaltChainedException {
        if (this.table.getSymbolCodeToString(value) == null) {
            this.featureValue.setCode(value);
            this.featureValue.setKnown(this.table.getKnown(value));
            this.featureValue.setSymbol(this.table.getNullValueSymbol(NullValues.NullValueId.NO_NODE));
            this.featureValue.setNullValue(true);
        } else {
            this.featureValue.setCode(value);
            this.featureValue.setKnown(this.table.getKnown(value));
            this.featureValue.setSymbol(this.table.getSymbolCodeToString(value));
            this.featureValue.setNullValue(this.table.isNullValue(value));
        }
    }

    @Override
    public void setFeatureValue(String value) throws MaltChainedException {
        if (this.table.getSymbolStringToCode(value) < 0) {
            this.featureValue.setCode(this.table.getNullValueCode(NullValues.NullValueId.NO_NODE));
            this.featureValue.setKnown(this.table.getKnown(value));
            this.featureValue.setSymbol(value);
            this.featureValue.setNullValue(true);
        } else {
            this.featureValue.setCode(this.table.getSymbolStringToCode(value));
            this.featureValue.setKnown(this.table.getKnown(value));
            this.featureValue.setSymbol(value);
            this.featureValue.setNullValue(this.table.isNullValue(value));
        }
    }

    @Override
    public FeatureValue getFeatureValue() {
        return this.featureValue;
    }

    public SymbolTableHandler getTableHandler() {
        return this.tableHandler;
    }

    public void setTableHandler(SymbolTableHandler tableHandler) {
        this.tableHandler = tableHandler;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableFeature)) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    public void setTableName(String name) {
        this.tableName = name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String toString() {
        return this.tableName;
    }
}

